/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.async;

import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.async.AsyncExecCallback;
import org.apache.hc.client5.http.async.AsyncExecChain;
import org.apache.hc.client5.http.async.AsyncExecChain$Scheduler;
import org.apache.hc.client5.http.async.AsyncExecChain$Scope;
import org.apache.hc.client5.http.async.AsyncExecRuntime;
import org.apache.hc.client5.http.auth.AuthSchemeFactory;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.config.Configurable;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.cookie.CookieSpecFactory;
import org.apache.hc.client5.http.cookie.CookieStore;
import org.apache.hc.client5.http.impl.ExecSupport;
import org.apache.hc.client5.http.impl.async.AbstractHttpAsyncClientBase;
import org.apache.hc.client5.http.impl.async.AsyncExecChainElement;
import org.apache.hc.client5.http.impl.async.AsyncPushConsumerRegistry;
import org.apache.hc.client5.http.impl.async.InternalAbstractHttpAsyncClient$1;
import org.apache.hc.client5.http.impl.async.InternalAbstractHttpAsyncClient$2;
import org.apache.hc.client5.http.impl.async.InternalAbstractHttpAsyncClient$3;
import org.apache.hc.client5.http.impl.async.InternalAbstractHttpAsyncClient$ScheduledRequestExecution;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.routing.RoutingSupport;
import org.apache.hc.core5.concurrent.BasicFuture;
import org.apache.hc.core5.concurrent.Cancellable;
import org.apache.hc.core5.concurrent.ComplexFuture;
import org.apache.hc.core5.concurrent.DefaultThreadFactory;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.config.Lookup;
import org.apache.hc.core5.http.nio.AsyncEntityProducer;
import org.apache.hc.core5.http.nio.AsyncPushConsumer;
import org.apache.hc.core5.http.nio.AsyncRequestProducer;
import org.apache.hc.core5.http.nio.AsyncResponseConsumer;
import org.apache.hc.core5.http.nio.HandlerFactory;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.support.BasicRequestBuilder;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.io.ModalCloseable;
import org.apache.hc.core5.net.NamedEndpoint;
import org.apache.hc.core5.net.URIAuthority;
import org.apache.hc.core5.reactor.DefaultConnectingIOReactor;
import org.apache.hc.core5.util.TimeValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class InternalAbstractHttpAsyncClient
extends AbstractHttpAsyncClientBase {
    private static final ThreadFactory SCHEDULER_THREAD_FACTORY = new DefaultThreadFactory("Scheduled-executor", true);
    private static final Logger LOG = LoggerFactory.getLogger(InternalAbstractHttpAsyncClient.class);
    private final AsyncExecChainElement execChain;
    private final Lookup<CookieSpecFactory> cookieSpecRegistry;
    private final Lookup<AuthSchemeFactory> authSchemeRegistry;
    private final CookieStore cookieStore;
    private final CredentialsProvider credentialsProvider;
    private final Function<HttpContext, HttpClientContext> contextAdaptor;
    private final RequestConfig defaultConfig;
    private final ConcurrentLinkedQueue<Closeable> closeables;
    private final ScheduledExecutorService scheduledExecutorService;
    private final AsyncExecChain$Scheduler scheduler;

    InternalAbstractHttpAsyncClient(DefaultConnectingIOReactor defaultConnectingIOReactor, AsyncPushConsumerRegistry asyncPushConsumerRegistry, ThreadFactory threadFactory, AsyncExecChainElement asyncExecChainElement, Lookup<CookieSpecFactory> lookup, Lookup<AuthSchemeFactory> lookup2, CookieStore cookieStore, CredentialsProvider credentialsProvider, Function<HttpContext, HttpClientContext> function, RequestConfig requestConfig, List<Closeable> list) {
        super(defaultConnectingIOReactor, asyncPushConsumerRegistry, threadFactory);
        this.execChain = asyncExecChainElement;
        this.cookieSpecRegistry = lookup;
        this.authSchemeRegistry = lookup2;
        this.cookieStore = cookieStore;
        this.credentialsProvider = credentialsProvider;
        this.contextAdaptor = function;
        this.defaultConfig = requestConfig;
        this.closeables = list != null ? new ConcurrentLinkedQueue<Closeable>(list) : null;
        this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(SCHEDULER_THREAD_FACTORY);
        this.scheduler = new InternalAbstractHttpAsyncClient$1(this, asyncExecChainElement);
    }

    @Override
    void internalClose(CloseMode object) {
        Iterator<Runnable> iterator;
        if (this.closeables != null) {
            while ((iterator = this.closeables.poll()) != null) {
                try {
                    if (iterator instanceof ModalCloseable) {
                        ((ModalCloseable)((Object)iterator)).close((CloseMode)((Object)object));
                        continue;
                    }
                    iterator.close();
                }
                catch (IOException iOException) {
                    LOG.error(iOException.getMessage(), iOException);
                }
            }
        }
        iterator = this.scheduledExecutorService.shutdownNow();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (!(object instanceof Cancellable)) continue;
            ((Cancellable)object).cancel();
        }
    }

    private void setupContext(HttpClientContext httpClientContext) {
        if (httpClientContext.getAuthSchemeRegistry() == null) {
            httpClientContext.setAuthSchemeRegistry(this.authSchemeRegistry);
        }
        if (httpClientContext.getCookieSpecRegistry() == null) {
            httpClientContext.setCookieSpecRegistry(this.cookieSpecRegistry);
        }
        if (httpClientContext.getCookieStore() == null) {
            httpClientContext.setCookieStore(this.cookieStore);
        }
        if (httpClientContext.getCredentialsProvider() == null) {
            httpClientContext.setCredentialsProvider(this.credentialsProvider);
        }
        if (httpClientContext.getRequestConfig() == null) {
            httpClientContext.setRequestConfig(this.defaultConfig);
        }
    }

    abstract AsyncExecRuntime createAsyncExecRuntime(HandlerFactory<AsyncPushConsumer> var1);

    abstract HttpRoute determineRoute(HttpHost var1, HttpRequest var2, HttpClientContext var3) throws HttpException;

    @Override
    protected <T> Future<T> doExecute(HttpHost httpHost, AsyncRequestProducer asyncRequestProducer, AsyncResponseConsumer<T> asyncResponseConsumer, HandlerFactory<AsyncPushConsumer> handlerFactory, HttpContext httpContext, FutureCallback<T> object) {
        object = new ComplexFuture<T>(object);
        try {
            if (!this.isRunning()) {
                throw new CancellationException("Request execution cancelled");
            }
            httpContext = this.contextAdaptor.apply(httpContext);
            asyncRequestProducer.sendRequest((arg_0, arg_1, arg_2) -> this.lambda$doExecute$0((HttpClientContext)httpContext, httpHost, handlerFactory, (ComplexFuture)object, asyncRequestProducer, asyncResponseConsumer, arg_0, arg_1, arg_2), httpContext);
        }
        catch (IOException | IllegalStateException | HttpException exception) {
            ((BasicFuture)object).failed(exception);
        }
        return object;
    }

    void executeImmediate(HttpRequest httpRequest, AsyncEntityProducer asyncEntityProducer, AsyncExecChain$Scope asyncExecChain$Scope, AsyncExecChain asyncExecChain, AsyncExecCallback asyncExecCallback) throws HttpException, IOException {
        asyncExecChain.proceed(httpRequest, asyncEntityProducer, asyncExecChain$Scope, asyncExecCallback);
    }

    void executeScheduled(HttpRequest object, AsyncEntityProducer asyncEntityProducer, AsyncExecChain$Scope asyncExecChain$Scope, AsyncExecChain asyncExecChain, AsyncExecCallback asyncExecCallback, TimeValue timeValue) {
        object = new InternalAbstractHttpAsyncClient$ScheduledRequestExecution(this, (HttpRequest)object, asyncEntityProducer, asyncExecChain$Scope, asyncExecChain, asyncExecCallback, timeValue);
        if (TimeValue.isPositive(timeValue)) {
            this.scheduledExecutorService.schedule((Runnable)object, timeValue.getDuration(), timeValue.getTimeUnit());
            return;
        }
        this.scheduledExecutorService.execute((Runnable)object);
    }

    private /* synthetic */ void lambda$doExecute$0(HttpClientContext object, HttpHost object2, HandlerFactory object3, ComplexFuture complexFuture, AsyncRequestProducer asyncRequestProducer, AsyncResponseConsumer asyncResponseConsumer, HttpRequest httpRequest, EntityDetails entityDetails, HttpContext httpContext) throws HttpException, IOException {
        Object object4 = null;
        if (httpRequest instanceof Configurable) {
            object4 = ((Configurable)((Object)httpRequest)).getConfig();
        }
        if (object4 != null) {
            ((HttpClientContext)object).setRequestConfig((RequestConfig)object4);
        }
        this.setupContext((HttpClientContext)object);
        if ((object2 = object2 != null ? object2 : RoutingSupport.determineHost(httpRequest)) != null) {
            if (httpRequest.getScheme() == null) {
                httpRequest.setScheme(((HttpHost)object2).getSchemeName());
            }
            if (httpRequest.getAuthority() == null) {
                httpRequest.setAuthority(new URIAuthority((NamedEndpoint)object2));
            }
        }
        object2 = this.determineRoute((HttpHost)object2, httpRequest, (HttpClientContext)object);
        object4 = ExecSupport.getNextExchangeId();
        ((HttpClientContext)object).setExchangeId((String)object4);
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} preparing request execution", object4);
        }
        object3 = this.createAsyncExecRuntime((HandlerFactory<AsyncPushConsumer>)object3);
        object = new AsyncExecChain$Scope((String)object4, (HttpRoute)object2, httpRequest, complexFuture, (HttpClientContext)object, (AsyncExecRuntime)object3, this.scheduler, new AtomicInteger(1));
        object2 = new AtomicBoolean(false);
        this.executeImmediate(BasicRequestBuilder.copy(httpRequest).build(), entityDetails != null ? new InternalAbstractHttpAsyncClient$3(this, asyncRequestProducer, entityDetails, (AtomicBoolean)object2) : null, (AsyncExecChain$Scope)object, this.execChain::execute, new InternalAbstractHttpAsyncClient$2(this, (AtomicBoolean)object2, asyncRequestProducer, asyncResponseConsumer, httpContext, complexFuture, (String)object4, (AsyncExecRuntime)object3));
    }

    static /* synthetic */ Logger access$000() {
        return LOG;
    }
}

