/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.async;

import java.net.InetSocketAddress;
import java.util.concurrent.Future;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.impl.async.InternalH2ConnPool$SessionPool$1;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.function.Callback;
import org.apache.hc.core5.function.Resolver;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.nio.command.ShutdownCommand;
import org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import org.apache.hc.core5.http2.nio.command.PingCommand;
import org.apache.hc.core5.http2.nio.support.BasicPingHandler;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.reactor.AbstractIOSessionPool;
import org.apache.hc.core5.reactor.Command$Priority;
import org.apache.hc.core5.reactor.ConnectionInitiator;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;

class InternalH2ConnPool$SessionPool
extends AbstractIOSessionPool<HttpRoute> {
    private final ConnectionInitiator connectionInitiator;
    private final Resolver<HttpHost, InetSocketAddress> addressResolver;
    private final TlsStrategy tlsStrategy;
    private volatile TimeValue validateAfterInactivity = TimeValue.NEG_ONE_MILLISECOND;

    InternalH2ConnPool$SessionPool(ConnectionInitiator connectionInitiator, Resolver<HttpHost, InetSocketAddress> resolver, TlsStrategy tlsStrategy) {
        this.connectionInitiator = connectionInitiator;
        this.addressResolver = resolver;
        this.tlsStrategy = tlsStrategy;
    }

    @Override
    protected Future<IOSession> connectSession(HttpRoute httpRoute, Timeout timeout, FutureCallback<IOSession> futureCallback) {
        HttpHost httpHost = httpRoute.getTargetHost();
        InetSocketAddress inetSocketAddress = httpRoute.getLocalSocketAddress();
        InetSocketAddress inetSocketAddress2 = this.addressResolver.resolve(httpHost);
        return this.connectionInitiator.connect(httpHost, inetSocketAddress2, inetSocketAddress, timeout, null, new InternalH2ConnPool$SessionPool$1(this, futureCallback, httpHost, httpRoute, timeout, futureCallback));
    }

    @Override
    protected void validateSession(IOSession iOSession, Callback<Boolean> callback) {
        if (iOSession.isOpen()) {
            long l2;
            long l3;
            TimeValue timeValue = this.validateAfterInactivity;
            if (TimeValue.isNonNegative(timeValue) && (l3 = (l2 = Math.min(iOSession.getLastReadTime(), iOSession.getLastWriteTime())) + timeValue.toMilliseconds()) <= System.currentTimeMillis()) {
                timeValue = iOSession.getSocketTimeout();
                iOSession.enqueue(new PingCommand(new BasicPingHandler(arg_0 -> InternalH2ConnPool$SessionPool.lambda$validateSession$0(iOSession, (Timeout)timeValue, callback, arg_0))), Command$Priority.NORMAL);
                return;
            }
            callback.execute(Boolean.TRUE);
            return;
        }
        callback.execute(Boolean.FALSE);
    }

    @Override
    protected void closeSession(IOSession iOSession, CloseMode closeMode) {
        if (closeMode == CloseMode.GRACEFUL) {
            iOSession.enqueue(ShutdownCommand.GRACEFUL, Command$Priority.NORMAL);
            return;
        }
        iOSession.close(closeMode);
    }

    private static /* synthetic */ void lambda$validateSession$0(IOSession iOSession, Timeout timeout, Callback callback, Boolean bl2) {
        iOSession.setSocketTimeout(timeout);
        callback.execute(bl2);
    }

    static /* synthetic */ TimeValue access$000(InternalH2ConnPool$SessionPool internalH2ConnPool$SessionPool) {
        return internalH2ConnPool$SessionPool.validateAfterInactivity;
    }

    static /* synthetic */ TimeValue access$002(InternalH2ConnPool$SessionPool internalH2ConnPool$SessionPool, TimeValue timeValue) {
        internalH2ConnPool$SessionPool.validateAfterInactivity = timeValue;
        return internalH2ConnPool$SessionPool.validateAfterInactivity;
    }

    static /* synthetic */ TlsStrategy access$100(InternalH2ConnPool$SessionPool internalH2ConnPool$SessionPool) {
        return internalH2ConnPool$SessionPool.tlsStrategy;
    }
}

