/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.async;

import java.net.InetSocketAddress;
import java.util.concurrent.Future;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.impl.async.InternalH2ConnPool$1;
import org.apache.hc.client5.http.impl.async.InternalH2ConnPool$SessionPool;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.function.Resolver;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.io.ModalCloseable;
import org.apache.hc.core5.reactor.ConnectionInitiator;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;

class InternalH2ConnPool
implements ModalCloseable {
    private final InternalH2ConnPool$SessionPool sessionPool;
    private volatile Resolver<HttpHost, ConnectionConfig> connectionConfigResolver;

    InternalH2ConnPool(ConnectionInitiator connectionInitiator, Resolver<HttpHost, InetSocketAddress> resolver, TlsStrategy tlsStrategy) {
        this.sessionPool = new InternalH2ConnPool$SessionPool(connectionInitiator, resolver, tlsStrategy);
    }

    @Override
    public void close(CloseMode closeMode) {
        this.sessionPool.close(closeMode);
    }

    @Override
    public void close() {
        this.sessionPool.close();
    }

    private ConnectionConfig resolveConnectionConfig(HttpHost object) {
        Resolver<HttpHost, ConnectionConfig> resolver = this.connectionConfigResolver;
        object = resolver != null ? resolver.resolve((HttpHost)object) : null;
        if (object != null) {
            return object;
        }
        return ConnectionConfig.DEFAULT;
    }

    public Future<IOSession> getSession(HttpRoute httpRoute, Timeout timeout, FutureCallback<IOSession> futureCallback) {
        ConnectionConfig connectionConfig = this.resolveConnectionConfig(httpRoute.getTargetHost());
        return this.sessionPool.getSession(httpRoute, timeout != null ? timeout : connectionConfig.getConnectTimeout(), new InternalH2ConnPool$1(this, futureCallback, connectionConfig, futureCallback));
    }

    public void closeIdle(TimeValue timeValue) {
        this.sessionPool.closeIdle(timeValue);
    }

    public void setConnectionConfigResolver(Resolver<HttpHost, ConnectionConfig> resolver) {
        this.connectionConfigResolver = resolver;
    }

    public TimeValue getValidateAfterInactivity() {
        return InternalH2ConnPool$SessionPool.access$000(this.sessionPool);
    }

    public void setValidateAfterInactivity(TimeValue timeValue) {
        InternalH2ConnPool$SessionPool.access$002(this.sessionPool, timeValue);
    }
}

