/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.async;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.hc.client5.http.EndpointInfo;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.async.AsyncExecRuntime;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.config.TlsConfig;
import org.apache.hc.client5.http.impl.ConnPoolSupport;
import org.apache.hc.client5.http.impl.Operations;
import org.apache.hc.client5.http.impl.async.InternalHttpAsyncExecRuntime$1;
import org.apache.hc.client5.http.impl.async.InternalHttpAsyncExecRuntime$2;
import org.apache.hc.client5.http.impl.async.InternalHttpAsyncExecRuntime$3;
import org.apache.hc.client5.http.impl.async.InternalHttpAsyncExecRuntime$4;
import org.apache.hc.client5.http.impl.async.InternalHttpAsyncExecRuntime$ReUseData;
import org.apache.hc.client5.http.nio.AsyncClientConnectionManager;
import org.apache.hc.client5.http.nio.AsyncConnectionEndpoint;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.concurrent.Cancellable;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.nio.AsyncClientExchangeHandler;
import org.apache.hc.core5.http.nio.AsyncPushConsumer;
import org.apache.hc.core5.http.nio.HandlerFactory;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.reactor.ConnectionInitiator;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.slf4j.Logger;

class InternalHttpAsyncExecRuntime
implements AsyncExecRuntime {
    private final Logger log;
    private final AsyncClientConnectionManager manager;
    private final ConnectionInitiator connectionInitiator;
    private final HandlerFactory<AsyncPushConsumer> pushHandlerFactory;
    @Deprecated
    private final TlsConfig tlsConfig;
    private final AtomicReference<AsyncConnectionEndpoint> endpointRef;
    private final AtomicReference<InternalHttpAsyncExecRuntime$ReUseData> reuseDataRef;

    InternalHttpAsyncExecRuntime(Logger logger, AsyncClientConnectionManager asyncClientConnectionManager, ConnectionInitiator connectionInitiator, HandlerFactory<AsyncPushConsumer> handlerFactory, TlsConfig tlsConfig) {
        this.log = logger;
        this.manager = asyncClientConnectionManager;
        this.connectionInitiator = connectionInitiator;
        this.pushHandlerFactory = handlerFactory;
        this.tlsConfig = tlsConfig;
        this.endpointRef = new AtomicReference();
        this.reuseDataRef = new AtomicReference();
    }

    @Override
    public boolean isEndpointAcquired() {
        return this.endpointRef.get() != null;
    }

    @Override
    public Cancellable acquireEndpoint(String string, HttpRoute httpRoute, Object object, HttpClientContext object2, FutureCallback<AsyncExecRuntime> futureCallback) {
        if (this.endpointRef.get() == null) {
            object2 = ((HttpClientContext)object2).getRequestConfigOrDefault();
            object2 = ((RequestConfig)object2).getConnectionRequestTimeout();
            if (this.log.isDebugEnabled()) {
                this.log.debug("{} acquiring endpoint ({})", (Object)string, object2);
            }
            return Operations.cancellable(this.manager.lease(string, httpRoute, object, (Timeout)object2, new InternalHttpAsyncExecRuntime$1(this, string, futureCallback)));
        }
        futureCallback.completed(this);
        return Operations.nonCancellable();
    }

    private void discardEndpoint(AsyncConnectionEndpoint asyncConnectionEndpoint) {
        try {
            asyncConnectionEndpoint.close(CloseMode.IMMEDIATE);
            if (this.log.isDebugEnabled()) {
                this.log.debug("{} endpoint closed", (Object)ConnPoolSupport.getId(asyncConnectionEndpoint));
            }
            return;
        }
        finally {
            if (this.log.isDebugEnabled()) {
                this.log.debug("{} discarding endpoint", (Object)ConnPoolSupport.getId(asyncConnectionEndpoint));
            }
            this.manager.release(asyncConnectionEndpoint, null, TimeValue.ZERO_MILLISECONDS);
        }
    }

    @Override
    public void releaseEndpoint() {
        AsyncConnectionEndpoint asyncConnectionEndpoint = this.endpointRef.getAndSet(null);
        if (asyncConnectionEndpoint != null) {
            InternalHttpAsyncExecRuntime$ReUseData internalHttpAsyncExecRuntime$ReUseData = this.reuseDataRef.getAndSet(null);
            if (internalHttpAsyncExecRuntime$ReUseData != null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("{} releasing valid endpoint", (Object)ConnPoolSupport.getId(asyncConnectionEndpoint));
                }
                this.manager.release(asyncConnectionEndpoint, internalHttpAsyncExecRuntime$ReUseData.state, internalHttpAsyncExecRuntime$ReUseData.validDuration);
                return;
            }
            this.discardEndpoint(asyncConnectionEndpoint);
        }
    }

    @Override
    public void discardEndpoint() {
        AsyncConnectionEndpoint asyncConnectionEndpoint = this.endpointRef.getAndSet(null);
        if (asyncConnectionEndpoint != null) {
            this.discardEndpoint(asyncConnectionEndpoint);
        }
    }

    @Override
    public boolean validateConnection() {
        if (this.reuseDataRef != null) {
            AsyncConnectionEndpoint asyncConnectionEndpoint = this.endpointRef.get();
            return asyncConnectionEndpoint != null && asyncConnectionEndpoint.isConnected();
        }
        AsyncConnectionEndpoint asyncConnectionEndpoint = this.endpointRef.getAndSet(null);
        if (asyncConnectionEndpoint != null) {
            this.discardEndpoint(asyncConnectionEndpoint);
        }
        return false;
    }

    AsyncConnectionEndpoint ensureValid() {
        AsyncConnectionEndpoint asyncConnectionEndpoint = this.endpointRef.get();
        if (asyncConnectionEndpoint == null) {
            throw new IllegalStateException("Endpoint not acquired / already released");
        }
        return asyncConnectionEndpoint;
    }

    @Override
    public boolean isEndpointConnected() {
        AsyncConnectionEndpoint asyncConnectionEndpoint = this.endpointRef.get();
        return asyncConnectionEndpoint != null && asyncConnectionEndpoint.isConnected();
    }

    @Override
    public Cancellable connectEndpoint(HttpClientContext httpClientContext, FutureCallback<AsyncExecRuntime> futureCallback) {
        AsyncConnectionEndpoint asyncConnectionEndpoint = this.ensureValid();
        if (asyncConnectionEndpoint.isConnected()) {
            futureCallback.completed(this);
            return Operations.nonCancellable();
        }
        Object object = httpClientContext.getRequestConfigOrDefault();
        object = ((RequestConfig)object).getConnectTimeout();
        if (this.log.isDebugEnabled()) {
            this.log.debug("{} connecting endpoint ({})", (Object)ConnPoolSupport.getId(asyncConnectionEndpoint), object);
        }
        FutureCallback<AsyncExecRuntime> futureCallback2 = futureCallback;
        return Operations.cancellable(this.manager.connect(asyncConnectionEndpoint, this.connectionInitiator, (Timeout)object, this.tlsConfig, httpClientContext, new InternalHttpAsyncExecRuntime$2(this, futureCallback2, futureCallback2)));
    }

    @Override
    public void disconnectEndpoint() {
        AsyncConnectionEndpoint asyncConnectionEndpoint = this.endpointRef.get();
        if (asyncConnectionEndpoint != null) {
            asyncConnectionEndpoint.close(CloseMode.GRACEFUL);
        }
    }

    @Override
    public void upgradeTls(HttpClientContext httpClientContext) {
        this.upgradeTls(httpClientContext, null);
    }

    @Override
    public void upgradeTls(HttpClientContext httpClientContext, FutureCallback<AsyncExecRuntime> futureCallback) {
        AsyncConnectionEndpoint asyncConnectionEndpoint = this.ensureValid();
        if (this.log.isDebugEnabled()) {
            this.log.debug("{} upgrading endpoint", (Object)ConnPoolSupport.getId(asyncConnectionEndpoint));
        }
        FutureCallback<AsyncExecRuntime> futureCallback2 = futureCallback;
        this.manager.upgrade(asyncConnectionEndpoint, this.tlsConfig, httpClientContext, new InternalHttpAsyncExecRuntime$3(this, futureCallback2, futureCallback2));
    }

    @Override
    public EndpointInfo getEndpointInfo() {
        AsyncConnectionEndpoint asyncConnectionEndpoint = this.endpointRef.get();
        if (asyncConnectionEndpoint != null) {
            return asyncConnectionEndpoint.getInfo();
        }
        return null;
    }

    @Override
    public Cancellable execute(String string, AsyncClientExchangeHandler asyncClientExchangeHandler, HttpClientContext httpClientContext) {
        AsyncConnectionEndpoint asyncConnectionEndpoint = this.ensureValid();
        if (asyncConnectionEndpoint.isConnected()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("{} start execution {}", (Object)ConnPoolSupport.getId(asyncConnectionEndpoint), (Object)string);
            }
            Object object = httpClientContext.getRequestConfigOrDefault();
            if ((object = ((RequestConfig)object).getResponseTimeout()) != null) {
                asyncConnectionEndpoint.setSocketTimeout((Timeout)object);
            }
            asyncConnectionEndpoint.execute(string, asyncClientExchangeHandler, this.pushHandlerFactory, httpClientContext);
            if (httpClientContext.getRequestConfigOrDefault().isHardCancellationEnabled()) {
                return () -> {
                    asyncClientExchangeHandler.cancel();
                    return true;
                };
            }
        } else {
            this.connectEndpoint(httpClientContext, new InternalHttpAsyncExecRuntime$4(this, asyncConnectionEndpoint, string, asyncClientExchangeHandler, httpClientContext));
        }
        return Operations.nonCancellable();
    }

    @Override
    public void markConnectionReusable(Object object, TimeValue timeValue) {
        this.reuseDataRef.set(new InternalHttpAsyncExecRuntime$ReUseData(object, timeValue));
    }

    @Override
    public void markConnectionNonReusable() {
        this.reuseDataRef.set(null);
    }

    @Override
    public AsyncExecRuntime fork() {
        return new InternalHttpAsyncExecRuntime(this.log, this.manager, this.connectionInitiator, this.pushHandlerFactory, this.tlsConfig);
    }

    static /* synthetic */ AtomicReference access$000(InternalHttpAsyncExecRuntime internalHttpAsyncExecRuntime) {
        return internalHttpAsyncExecRuntime.endpointRef;
    }

    static /* synthetic */ Logger access$100(InternalHttpAsyncExecRuntime internalHttpAsyncExecRuntime) {
        return internalHttpAsyncExecRuntime.log;
    }

    static /* synthetic */ HandlerFactory access$200(InternalHttpAsyncExecRuntime internalHttpAsyncExecRuntime) {
        return internalHttpAsyncExecRuntime.pushHandlerFactory;
    }
}

