/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.async;

import java.io.IOException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import org.apache.hc.client5.http.DnsResolver;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.config.Configurable;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.async.AbstractMinimalHttpAsyncClientBase;
import org.apache.hc.client5.http.impl.async.AsyncPushConsumerRegistry;
import org.apache.hc.client5.http.impl.async.InternalH2ConnPool;
import org.apache.hc.client5.http.impl.async.LoggingExceptionCallback;
import org.apache.hc.client5.http.impl.async.LoggingIOSessionDecorator;
import org.apache.hc.client5.http.impl.async.MinimalH2AsyncClient$1;
import org.apache.hc.client5.http.impl.nio.MultihomeConnectionInitiator;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.concurrent.Cancellable;
import org.apache.hc.core5.concurrent.ComplexCancellable;
import org.apache.hc.core5.function.Resolver;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.nio.AsyncClientExchangeHandler;
import org.apache.hc.core5.http.nio.AsyncPushConsumer;
import org.apache.hc.core5.http.nio.HandlerFactory;
import org.apache.hc.core5.http.nio.command.ShutdownCommand;
import org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.reactor.Command$Priority;
import org.apache.hc.core5.reactor.ConnectionInitiator;
import org.apache.hc.core5.reactor.DefaultConnectingIOReactor;
import org.apache.hc.core5.reactor.IOEventHandlerFactory;
import org.apache.hc.core5.reactor.IOReactorConfig;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Contract(threading=ThreadingBehavior.SAFE_CONDITIONAL)
public final class MinimalH2AsyncClient
extends AbstractMinimalHttpAsyncClientBase {
    private static final Logger LOG = LoggerFactory.getLogger(MinimalH2AsyncClient.class);
    private final InternalH2ConnPool connPool;
    private final ConnectionInitiator connectionInitiator;

    MinimalH2AsyncClient(IOEventHandlerFactory iOEventHandlerFactory, AsyncPushConsumerRegistry asyncPushConsumerRegistry, IOReactorConfig iOReactorConfig, ThreadFactory threadFactory, ThreadFactory threadFactory2, DnsResolver dnsResolver, TlsStrategy tlsStrategy) {
        super(new DefaultConnectingIOReactor(iOEventHandlerFactory, iOReactorConfig, threadFactory2, LoggingIOSessionDecorator.INSTANCE, LoggingExceptionCallback.INSTANCE, null, iOSession -> iOSession.enqueue(new ShutdownCommand(CloseMode.GRACEFUL), Command$Priority.IMMEDIATE)), asyncPushConsumerRegistry, threadFactory);
        this.connectionInitiator = new MultihomeConnectionInitiator(this.getConnectionInitiator(), dnsResolver);
        this.connPool = new InternalH2ConnPool(this.connectionInitiator, httpHost -> null, tlsStrategy);
    }

    @Override
    public final Cancellable execute(AsyncClientExchangeHandler asyncClientExchangeHandler, HandlerFactory<AsyncPushConsumer> handlerFactory, HttpContext httpContext) {
        Args.notNull(asyncClientExchangeHandler, "Message exchange handler");
        ComplexCancellable complexCancellable = new ComplexCancellable();
        try {
            if (!this.isRunning()) {
                throw new CancellationException("Request execution cancelled");
            }
            HttpClientContext httpClientContext = HttpClientContext.castOrCreate(httpContext);
            asyncClientExchangeHandler.produceRequest((httpRequest, entityDetails, object2) -> {
                object2 = null;
                if (httpRequest instanceof Configurable) {
                    object2 = ((Configurable)((Object)httpRequest)).getConfig();
                }
                if (object2 != null) {
                    ((HttpClientContext)httpClientContext).setRequestConfig((RequestConfig)((Object)object2));
                } else {
                    object2 = ((HttpClientContext)httpClientContext).getRequestConfigOrDefault();
                }
                object2 = ((RequestConfig)((Object)object2)).getConnectTimeout();
                HttpHost httpHost = new HttpHost(httpRequest.getScheme(), httpRequest.getAuthority());
                httpClientContext = this.connPool.getSession(new HttpRoute(httpHost), (Timeout)((Object)object2), new MinimalH2AsyncClient$1(this, asyncClientExchangeHandler, httpRequest, entityDetails, httpClientContext, handlerFactory, complexCancellable));
                complexCancellable.setDependency(() -> MinimalH2AsyncClient.lambda$null$2((Future)((Object)httpClientContext)));
            }, httpContext);
        }
        catch (IOException | IllegalStateException | HttpException exception) {
            asyncClientExchangeHandler.failed(exception);
        }
        return complexCancellable;
    }

    public final void setConnectionConfigResolver(Resolver<HttpHost, ConnectionConfig> resolver) {
        this.connPool.setConnectionConfigResolver(resolver);
    }

    private static /* synthetic */ boolean lambda$null$2(Future future) {
        return future.cancel(true);
    }

    static /* synthetic */ Logger access$000() {
        return LOG;
    }
}

