/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.async;

import java.io.IOException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.SchemePortResolver;
import org.apache.hc.client5.http.config.Configurable;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.config.TlsConfig;
import org.apache.hc.client5.http.impl.DefaultSchemePortResolver;
import org.apache.hc.client5.http.impl.ExecSupport;
import org.apache.hc.client5.http.impl.async.AbstractMinimalHttpAsyncClientBase;
import org.apache.hc.client5.http.impl.async.AsyncPushConsumerRegistry;
import org.apache.hc.client5.http.impl.async.LoggingExceptionCallback;
import org.apache.hc.client5.http.impl.async.LoggingIOSessionDecorator;
import org.apache.hc.client5.http.impl.async.MinimalHttpAsyncClient$1;
import org.apache.hc.client5.http.impl.async.MinimalHttpAsyncClient$2;
import org.apache.hc.client5.http.impl.async.MinimalHttpAsyncClient$3;
import org.apache.hc.client5.http.nio.AsyncClientConnectionManager;
import org.apache.hc.client5.http.nio.AsyncConnectionEndpoint;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.routing.RoutingSupport;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.concurrent.BasicFuture;
import org.apache.hc.core5.concurrent.Cancellable;
import org.apache.hc.core5.concurrent.ComplexCancellable;
import org.apache.hc.core5.concurrent.ComplexFuture;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.nio.AsyncClientEndpoint;
import org.apache.hc.core5.http.nio.AsyncClientExchangeHandler;
import org.apache.hc.core5.http.nio.AsyncPushConsumer;
import org.apache.hc.core5.http.nio.HandlerFactory;
import org.apache.hc.core5.http.nio.command.ShutdownCommand;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.reactor.Command$Priority;
import org.apache.hc.core5.reactor.DefaultConnectingIOReactor;
import org.apache.hc.core5.reactor.IOEventHandlerFactory;
import org.apache.hc.core5.reactor.IOReactorConfig;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Contract(threading=ThreadingBehavior.SAFE_CONDITIONAL)
public final class MinimalHttpAsyncClient
extends AbstractMinimalHttpAsyncClientBase {
    private static final Logger LOG = LoggerFactory.getLogger(MinimalHttpAsyncClient.class);
    private final AsyncClientConnectionManager manager;
    private final SchemePortResolver schemePortResolver;
    private final TlsConfig tlsConfig;

    MinimalHttpAsyncClient(IOEventHandlerFactory iOEventHandlerFactory, AsyncPushConsumerRegistry asyncPushConsumerRegistry, IOReactorConfig iOReactorConfig, ThreadFactory threadFactory, ThreadFactory threadFactory2, AsyncClientConnectionManager asyncClientConnectionManager, SchemePortResolver schemePortResolver, TlsConfig tlsConfig) {
        super(new DefaultConnectingIOReactor(iOEventHandlerFactory, iOReactorConfig, threadFactory2, LoggingIOSessionDecorator.INSTANCE, LoggingExceptionCallback.INSTANCE, null, iOSession -> iOSession.enqueue(new ShutdownCommand(CloseMode.GRACEFUL), Command$Priority.NORMAL)), asyncPushConsumerRegistry, threadFactory);
        this.manager = asyncClientConnectionManager;
        this.schemePortResolver = schemePortResolver != null ? schemePortResolver : DefaultSchemePortResolver.INSTANCE;
        this.tlsConfig = tlsConfig;
    }

    private Future<AsyncConnectionEndpoint> leaseEndpoint(HttpHost future, Timeout timeout, Timeout timeout2, HttpClientContext httpClientContext, FutureCallback<AsyncConnectionEndpoint> futureCallback) {
        future = new HttpRoute(RoutingSupport.normalize((HttpHost)((Object)future), this.schemePortResolver));
        ComplexFuture<AsyncConnectionEndpoint> complexFuture = new ComplexFuture<AsyncConnectionEndpoint>(futureCallback);
        String string = ExecSupport.getNextExchangeId();
        httpClientContext.setExchangeId(string);
        future = this.manager.lease(string, (HttpRoute)((Object)future), null, timeout, new MinimalHttpAsyncClient$1(this, complexFuture, timeout2, httpClientContext, futureCallback));
        complexFuture.setDependency(future);
        return complexFuture;
    }

    public final Future<AsyncClientEndpoint> lease(HttpHost httpHost, FutureCallback<AsyncClientEndpoint> futureCallback) {
        return this.lease(httpHost, null, futureCallback);
    }

    public final Future<AsyncClientEndpoint> lease(HttpHost httpHost, HttpContext httpContext, FutureCallback<AsyncClientEndpoint> object) {
        Args.notNull(httpHost, "Host");
        object = new BasicFuture<AsyncClientEndpoint>((FutureCallback<AsyncClientEndpoint>)object);
        if (!this.isRunning()) {
            ((BasicFuture)object).failed(new CancellationException("Connection lease cancelled"));
            return object;
        }
        httpContext = HttpClientContext.castOrCreate(httpContext);
        Object object2 = ((HttpClientContext)httpContext).getRequestConfigOrDefault();
        Timeout timeout = ((RequestConfig)object2).getConnectionRequestTimeout();
        object2 = ((RequestConfig)object2).getConnectTimeout();
        this.leaseEndpoint(httpHost, timeout, (Timeout)object2, (HttpClientContext)httpContext, new MinimalHttpAsyncClient$2(this, (BasicFuture)object));
        return object;
    }

    @Override
    public final Cancellable execute(AsyncClientExchangeHandler asyncClientExchangeHandler, HandlerFactory<AsyncPushConsumer> handlerFactory, HttpContext httpContext) {
        ComplexCancellable complexCancellable = new ComplexCancellable();
        try {
            if (!this.isRunning()) {
                throw new CancellationException("Request execution cancelled");
            }
            HttpClientContext httpClientContext = HttpClientContext.castOrCreate(httpContext);
            asyncClientExchangeHandler.produceRequest((httpRequest, entityDetails, object2) -> {
                object2 = null;
                if (httpRequest instanceof Configurable) {
                    object2 = ((Configurable)((Object)httpRequest)).getConfig();
                }
                if (object2 != null) {
                    ((HttpClientContext)httpClientContext).setRequestConfig((RequestConfig)((Object)object2));
                } else {
                    object2 = ((HttpClientContext)httpClientContext).getRequestConfigOrDefault();
                }
                Timeout timeout = ((RequestConfig)((Object)object2)).getConnectionRequestTimeout();
                Timeout timeout2 = ((RequestConfig)((Object)object2)).getConnectTimeout();
                object2 = ((RequestConfig)((Object)object2)).getResponseTimeout();
                HttpHost httpHost = new HttpHost(httpRequest.getScheme(), httpRequest.getAuthority());
                httpClientContext = this.leaseEndpoint(httpHost, timeout, timeout2, httpClientContext, new MinimalHttpAsyncClient$3(this, asyncClientExchangeHandler, httpRequest, entityDetails, (Timeout)((Object)object2), handlerFactory, httpClientContext));
                complexCancellable.setDependency(() -> MinimalHttpAsyncClient.lambda$null$1((Future)((Object)httpClientContext)));
            }, httpContext);
        }
        catch (IOException | IllegalStateException | HttpException exception) {
            asyncClientExchangeHandler.failed(exception);
        }
        return complexCancellable;
    }

    private static /* synthetic */ boolean lambda$null$1(Future future) {
        return future.cancel(true);
    }

    static /* synthetic */ TlsConfig access$000(MinimalHttpAsyncClient minimalHttpAsyncClient) {
        return minimalHttpAsyncClient.tlsConfig;
    }

    static /* synthetic */ AsyncClientConnectionManager access$100(MinimalHttpAsyncClient minimalHttpAsyncClient) {
        return minimalHttpAsyncClient.manager;
    }

    static /* synthetic */ Logger access$200() {
        return LOG;
    }
}

