/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.auth;

import org.apache.hc.client5.http.SchemePortResolver;
import org.apache.hc.client5.http.auth.AuthCache;
import org.apache.hc.client5.http.auth.AuthExchange;
import org.apache.hc.client5.http.auth.AuthExchange$State;
import org.apache.hc.client5.http.auth.AuthScheme;
import org.apache.hc.client5.http.auth.AuthStateCacheable;
import org.apache.hc.client5.http.impl.auth.BasicAuthCache;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
@Contract(threading=ThreadingBehavior.STATELESS)
public final class AuthCacheKeeper {
    private static final Logger LOG = LoggerFactory.getLogger(AuthCacheKeeper.class);
    private final SchemePortResolver schemePortResolver;

    public AuthCacheKeeper(SchemePortResolver schemePortResolver) {
        this.schemePortResolver = schemePortResolver;
    }

    public final void updateOnChallenge(HttpHost httpHost, String string, AuthExchange authExchange, HttpContext httpContext) {
        this.clearCache(httpHost, string, HttpClientContext.cast(httpContext));
    }

    public final void updateOnNoChallenge(HttpHost httpHost, String string, AuthExchange authExchange, HttpContext httpContext) {
        if (authExchange.getState() == AuthExchange$State.SUCCESS) {
            this.updateCache(httpHost, string, authExchange.getAuthScheme(), HttpClientContext.cast(httpContext));
        }
    }

    public final void updateOnResponse(HttpHost httpHost, String string, AuthExchange authExchange, HttpContext httpContext) {
        if (authExchange.getState() == AuthExchange$State.FAILURE) {
            this.clearCache(httpHost, string, HttpClientContext.cast(httpContext));
        }
    }

    public final void loadPreemptively(HttpHost httpHost, String string, AuthExchange authExchange, HttpContext httpContext) {
        if (authExchange.getState() == AuthExchange$State.UNCHALLENGED) {
            AuthScheme authScheme = this.loadFromCache(httpHost, string, HttpClientContext.cast(httpContext));
            if (authScheme == null && string != null) {
                authScheme = this.loadFromCache(httpHost, null, HttpClientContext.cast(httpContext));
            }
            if (authScheme != null) {
                authExchange.select(authScheme);
            }
        }
    }

    private AuthScheme loadFromCache(HttpHost httpHost, String string, HttpClientContext object) {
        Object object2 = ((HttpClientContext)object).getAuthCache();
        if (object2 != null && (object2 = object2.get(httpHost, string)) != null) {
            if (LOG.isDebugEnabled()) {
                object = ((HttpClientContext)object).getExchangeId();
                LOG.debug("{} Re-using cached '{}' auth scheme for {}{}", object, object2.getName(), httpHost, string != null ? string : "");
            }
            return object2;
        }
        return null;
    }

    private void updateCache(HttpHost httpHost, String string, AuthScheme authScheme, HttpClientContext object) {
        boolean bl2 = authScheme.getClass().getAnnotation(AuthStateCacheable.class) != null;
        if (bl2) {
            AuthCache authCache = ((HttpClientContext)object).getAuthCache();
            if (authCache == null) {
                authCache = new BasicAuthCache(this.schemePortResolver);
                ((HttpClientContext)object).setAuthCache(authCache);
            }
            if (LOG.isDebugEnabled()) {
                object = ((HttpClientContext)object).getExchangeId();
                LOG.debug("{} Caching '{}' auth scheme for {}{}", object, authScheme.getName(), httpHost, string != null ? string : "");
            }
            authCache.put(httpHost, string, authScheme);
        }
    }

    private void clearCache(HttpHost httpHost, String string, HttpClientContext object) {
        AuthCache authCache = ((HttpClientContext)object).getAuthCache();
        if (authCache != null) {
            if (LOG.isDebugEnabled()) {
                object = ((HttpClientContext)object).getExchangeId();
                LOG.debug("{} Clearing cached auth scheme for {}{}", object, httpHost, string != null ? string : "");
            }
            authCache.remove(httpHost, string);
        }
    }
}

