/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.auth;

import java.util.ArrayList;
import java.util.List;
import org.apache.hc.client5.http.auth.AuthChallenge;
import org.apache.hc.client5.http.auth.ChallengeType;
import org.apache.hc.client5.http.impl.auth.AuthChallengeParser$ChallengeInt;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.apache.hc.core5.http.message.ParserCursor;
import org.apache.hc.core5.util.TextUtils;
import org.apache.hc.core5.util.Tokenizer;
import org.apache.hc.core5.util.Tokenizer$Cursor;
import org.apache.hc.core5.util.Tokenizer$Delimiter;

public class AuthChallengeParser {
    public static final AuthChallengeParser INSTANCE = new AuthChallengeParser();
    private final Tokenizer tokenParser = Tokenizer.INSTANCE;
    private static final char BLANK = ' ';
    private static final char COMMA_CHAR = ',';
    private static final char EQUAL_CHAR = '=';
    private static final Tokenizer$Delimiter TERMINATORS = Tokenizer.delimiters(' ', '=', ',');
    private static final Tokenizer$Delimiter DELIMITER = Tokenizer.delimiters(',');
    private static final Tokenizer$Delimiter SPACE = Tokenizer.delimiters(' ');

    public List<AuthChallenge> parse(ChallengeType challengeType, CharSequence object, ParserCursor object2) throws ParseException {
        this.tokenParser.skipWhiteSpace((CharSequence)object, (Tokenizer$Cursor)object2);
        if (((Tokenizer$Cursor)object2).atEnd()) {
            throw new ParseException("Malformed auth challenge");
        }
        Object object3 = new ArrayList<List<NameValuePair>>();
        Object object4 = this.tokenParser.parseToken((CharSequence)object, (Tokenizer$Cursor)object2, SPACE);
        if (TextUtils.isBlank((CharSequence)object4)) {
            throw new ParseException("Malformed auth challenge");
        }
        object4 = new AuthChallengeParser$ChallengeInt((String)object4);
        while (object4 != null) {
            object3.add(object4);
            object4 = this.parseChallenge((CharSequence)object, (ParserCursor)object2, (AuthChallengeParser$ChallengeInt)object4);
        }
        object = new ArrayList(object3.size());
        object2 = object3.iterator();
        while (object2.hasNext()) {
            NameValuePair nameValuePair;
            object3 = (AuthChallengeParser$ChallengeInt)object2.next();
            object4 = ((AuthChallengeParser$ChallengeInt)object3).params;
            String string = null;
            if (object4.size() == 1 && (nameValuePair = object4.get(0)).getValue() == null) {
                string = nameValuePair.getName();
                object4.clear();
            }
            object.add(new AuthChallenge(challengeType, ((AuthChallengeParser$ChallengeInt)object3).schemeName, string, !object4.isEmpty() ? object4 : null));
        }
        return object;
    }

    AuthChallengeParser$ChallengeInt parseChallenge(CharSequence charSequence, ParserCursor parserCursor, AuthChallengeParser$ChallengeInt authChallengeParser$ChallengeInt) throws ParseException {
        String string;
        while (true) {
            this.tokenParser.skipWhiteSpace(charSequence, parserCursor);
            if (parserCursor.atEnd()) {
                return null;
            }
            string = this.parseToken(charSequence, parserCursor);
            if (TextUtils.isBlank(string)) {
                throw new ParseException("Malformed auth challenge");
            }
            this.tokenParser.skipWhiteSpace(charSequence, parserCursor);
            if (parserCursor.atEnd()) {
                authChallengeParser$ChallengeInt.params.add(new BasicNameValuePair(string, null));
                continue;
            }
            char c2 = charSequence.charAt(parserCursor.getPos());
            if (c2 == '=') {
                ParserCursor parserCursor2 = parserCursor;
                parserCursor2.updatePos(parserCursor2.getPos() + 1);
                String string2 = this.tokenParser.parseValue(charSequence, (Tokenizer$Cursor)parserCursor, DELIMITER);
                this.tokenParser.skipWhiteSpace(charSequence, parserCursor);
                if (!parserCursor.atEnd() && (c2 = charSequence.charAt(parserCursor.getPos())) == ',') {
                    ParserCursor parserCursor3 = parserCursor;
                    parserCursor3.updatePos(parserCursor3.getPos() + 1);
                }
                authChallengeParser$ChallengeInt.params.add(new BasicNameValuePair(string, string2));
                continue;
            }
            if (c2 != ',') break;
            ParserCursor parserCursor4 = parserCursor;
            parserCursor4.updatePos(parserCursor4.getPos() + 1);
            authChallengeParser$ChallengeInt.params.add(new BasicNameValuePair(string, null));
        }
        if (authChallengeParser$ChallengeInt.params.isEmpty()) {
            throw new ParseException("Malformed auth challenge");
        }
        return new AuthChallengeParser$ChallengeInt(string);
    }

    String parseToken(CharSequence charSequence, ParserCursor parserCursor) {
        StringBuilder stringBuilder = new StringBuilder();
        while (!parserCursor.atEnd()) {
            int n2 = parserCursor.getPos();
            char c2 = charSequence.charAt(n2);
            if (TERMINATORS.test(c2)) {
                if (c2 != '=' || n2 + 1 < parserCursor.getUpperBound() && charSequence.charAt(n2 + 1) != '=') break;
                do {
                    stringBuilder.append(c2);
                    parserCursor.updatePos(++n2);
                } while (!parserCursor.atEnd() && (c2 = charSequence.charAt(n2)) == '=');
                continue;
            }
            stringBuilder.append(c2);
            parserCursor.updatePos(n2 + 1);
        }
        return stringBuilder.toString();
    }
}

