/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.auth;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hc.client5.http.SchemePortResolver;
import org.apache.hc.client5.http.auth.AuthCache;
import org.apache.hc.client5.http.auth.AuthScheme;
import org.apache.hc.client5.http.impl.DefaultSchemePortResolver;
import org.apache.hc.client5.http.impl.StateHolder;
import org.apache.hc.client5.http.impl.auth.BasicAuthCache$AuthData;
import org.apache.hc.client5.http.impl.auth.BasicAuthCache$Key;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.net.NamedEndpoint;
import org.apache.hc.core5.util.Args;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Contract(threading=ThreadingBehavior.SAFE_CONDITIONAL)
public class BasicAuthCache
implements AuthCache {
    private static final Logger LOG = LoggerFactory.getLogger(BasicAuthCache.class);
    private final Map<BasicAuthCache$Key, BasicAuthCache$AuthData> map = new ConcurrentHashMap<BasicAuthCache$Key, BasicAuthCache$AuthData>();
    private final SchemePortResolver schemePortResolver;

    public BasicAuthCache(SchemePortResolver schemePortResolver) {
        this.schemePortResolver = schemePortResolver != null ? schemePortResolver : DefaultSchemePortResolver.INSTANCE;
    }

    public BasicAuthCache() {
        this(null);
    }

    private BasicAuthCache$Key key(String string, NamedEndpoint namedEndpoint, String string2) {
        return new BasicAuthCache$Key(string, namedEndpoint.getHostName(), this.schemePortResolver.resolve(string, namedEndpoint), string2);
    }

    private BasicAuthCache$AuthData data(AuthScheme authScheme) {
        return new BasicAuthCache$AuthData(authScheme.getClass(), ((StateHolder)((Object)authScheme)).store());
    }

    @Override
    public void put(HttpHost httpHost, AuthScheme authScheme) {
        this.put(httpHost, null, authScheme);
    }

    @Override
    public AuthScheme get(HttpHost httpHost) {
        return this.get(httpHost, null);
    }

    @Override
    public void remove(HttpHost httpHost) {
        this.remove(httpHost, null);
    }

    @Override
    public void put(HttpHost httpHost, String string, AuthScheme authScheme) {
        Args.notNull(httpHost, "HTTP host");
        if (authScheme == null) {
            return;
        }
        if (authScheme instanceof StateHolder) {
            this.map.put(this.key(httpHost.getSchemeName(), httpHost, string), this.data(authScheme));
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Auth scheme {} cannot be cached", (Object)authScheme.getClass());
        }
    }

    @Override
    public AuthScheme get(HttpHost object, String object2) {
        block3: {
            Args.notNull(object, "HTTP host");
            object = this.map.get(this.key(((HttpHost)object).getSchemeName(), (NamedEndpoint)object, (String)object2));
            if (object != null) {
                try {
                    object2 = ((BasicAuthCache$AuthData)object).clazz.newInstance();
                    ((StateHolder)object2).restore(((BasicAuthCache$AuthData)object).state);
                    return object2;
                }
                catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                    if (!LOG.isWarnEnabled()) break block3;
                    LOG.warn("Unexpected error while reading auth scheme state", reflectiveOperationException);
                }
            }
        }
        return null;
    }

    @Override
    public void remove(HttpHost httpHost, String string) {
        Args.notNull(httpHost, "HTTP host");
        this.map.remove(this.key(httpHost.getSchemeName(), httpHost, string));
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    public String toString() {
        return this.map.toString();
    }
}

