/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.auth;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.hc.client5.http.auth.AuthChallenge;
import org.apache.hc.client5.http.auth.AuthScheme;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.AuthStateCacheable;
import org.apache.hc.client5.http.auth.AuthenticationException;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.MalformedChallengeException;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.impl.StateHolder;
import org.apache.hc.client5.http.impl.auth.AuthSchemeSupport;
import org.apache.hc.client5.http.impl.auth.BasicScheme$State;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.utils.Base64;
import org.apache.hc.client5.http.utils.ByteArrayBuilder;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.Args;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AuthStateCacheable
public class BasicScheme
implements Serializable,
AuthScheme,
StateHolder<BasicScheme$State> {
    private static final long serialVersionUID = -1931571557597830536L;
    private static final Logger LOG = LoggerFactory.getLogger(BasicScheme.class);
    private final Map<String, String> paramMap = new HashMap<String, String>();
    private transient ByteArrayBuilder buffer;
    private transient Base64 base64codec;
    private boolean complete = false;
    private UsernamePasswordCredentials credentials;

    @Deprecated
    public BasicScheme(Charset charset) {
    }

    public BasicScheme() {
    }

    public void initPreemptive(Credentials credentials) {
        if (credentials != null) {
            Args.check(credentials instanceof UsernamePasswordCredentials, "Unsupported credential type: " + credentials.getClass());
            this.credentials = (UsernamePasswordCredentials)credentials;
            this.complete = true;
            return;
        }
        this.credentials = null;
    }

    @Override
    public String getName() {
        return "Basic";
    }

    @Override
    public boolean isConnectionBased() {
        return false;
    }

    @Override
    public String getRealm() {
        return this.paramMap.get("realm");
    }

    @Override
    public void processChallenge(AuthChallenge iterator, HttpContext object) throws MalformedChallengeException {
        this.paramMap.clear();
        iterator = ((AuthChallenge)((Object)iterator)).getParams();
        if (iterator != null) {
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                object = (NameValuePair)iterator.next();
                this.paramMap.put(object.getName().toLowerCase(Locale.ROOT), object.getValue());
            }
        }
        this.complete = true;
    }

    @Override
    public boolean isChallengeComplete() {
        return this.complete;
    }

    @Override
    public boolean isResponseReady(HttpHost object, CredentialsProvider object2, HttpContext httpContext) throws AuthenticationException {
        Args.notNull(object, "Auth host");
        Args.notNull(object2, "CredentialsProvider");
        object = new AuthScope((HttpHost)object, this.getRealm(), this.getName());
        object2 = object2.getCredentials((AuthScope)object, httpContext);
        if (object2 instanceof UsernamePasswordCredentials) {
            this.credentials = (UsernamePasswordCredentials)object2;
            return true;
        }
        if (LOG.isDebugEnabled()) {
            object2 = HttpClientContext.cast(httpContext);
            object2 = ((HttpClientContext)object2).getExchangeId();
            LOG.debug("{} No credentials found for auth scope [{}]", object2, object);
        }
        this.credentials = null;
        return false;
    }

    @Override
    public Principal getPrincipal() {
        return null;
    }

    private void validateUsername() throws AuthenticationException {
        if (this.credentials == null) {
            throw new AuthenticationException("User credentials not set");
        }
        String string = this.credentials.getUserName();
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (Character.isISOControl(c2)) {
                throw new AuthenticationException("Username must not contain any control characters");
            }
            if (c2 != ':') continue;
            throw new AuthenticationException("Username contains a colon character and is invalid");
        }
    }

    private void validatePassword() throws AuthenticationException {
        if (this.credentials == null) {
            throw new AuthenticationException("User credentials not set");
        }
        char[] cArray = this.credentials.getUserPassword();
        if (cArray != null) {
            for (char c2 : cArray) {
                if (!Character.isISOControl(c2)) continue;
                throw new AuthenticationException("Password must not contain any control characters");
            }
        }
    }

    @Override
    public String generateAuthResponse(HttpHost object, HttpRequest httpRequest, HttpContext httpContext) throws AuthenticationException {
        this.validateUsername();
        this.validatePassword();
        if (this.buffer == null) {
            this.buffer = new ByteArrayBuilder(64);
        } else {
            this.buffer.reset();
        }
        object = AuthSchemeSupport.parseCharset(this.paramMap.get("charset"), StandardCharsets.UTF_8);
        this.buffer.charset((Charset)object);
        this.buffer.append(this.credentials.getUserName()).append(":").append(this.credentials.getUserPassword());
        if (this.base64codec == null) {
            this.base64codec = new Base64();
        }
        object = this.base64codec.encode(this.buffer.toByteArray());
        this.buffer.reset();
        return "Basic " + new String((byte[])object, 0, ((Object)object).length, StandardCharsets.US_ASCII);
    }

    @Override
    public BasicScheme$State store() {
        if (this.complete) {
            return new BasicScheme$State(new HashMap<String, String>(this.paramMap), this.credentials);
        }
        return null;
    }

    @Override
    public void restore(BasicScheme$State basicScheme$State) {
        if (basicScheme$State != null) {
            this.paramMap.clear();
            this.paramMap.putAll(basicScheme$State.params);
            this.credentials = basicScheme$State.credentials;
            this.complete = true;
        }
    }

    public String toString() {
        return this.getName() + this.paramMap;
    }
}

