/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.auth;

import java.util.HashMap;
import java.util.Map;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.auth.FixedCredentialsProvider;
import org.apache.hc.client5.http.impl.auth.SingleCredentialsProvider;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.util.Args;

public final class CredentialsProviderBuilder {
    private final Map<AuthScope, Credentials> credMap = new HashMap<AuthScope, Credentials>();

    public static CredentialsProviderBuilder create() {
        return new CredentialsProviderBuilder();
    }

    public final CredentialsProviderBuilder add(AuthScope authScope, Credentials credentials) {
        Args.notNull(authScope, "Host");
        this.credMap.put(authScope, credentials);
        return this;
    }

    public final CredentialsProviderBuilder add(AuthScope authScope, String string, char[] cArray) {
        Args.notNull(authScope, "Host");
        this.credMap.put(authScope, new UsernamePasswordCredentials(string, cArray));
        return this;
    }

    public final CredentialsProviderBuilder add(HttpHost httpHost, Credentials credentials) {
        Args.notNull(httpHost, "Host");
        this.credMap.put(new AuthScope(httpHost), credentials);
        return this;
    }

    public final CredentialsProviderBuilder add(HttpHost httpHost, String string, char[] cArray) {
        Args.notNull(httpHost, "Host");
        this.credMap.put(new AuthScope(httpHost), new UsernamePasswordCredentials(string, cArray));
        return this;
    }

    public final CredentialsProvider build() {
        if (this.credMap.size() == 0) {
            return new BasicCredentialsProvider();
        }
        if (this.credMap.size() == 1) {
            Map.Entry<AuthScope, Credentials> entry = this.credMap.entrySet().iterator().next();
            return new SingleCredentialsProvider(entry.getKey(), entry.getValue());
        }
        return new FixedCredentialsProvider(this.credMap);
    }
}

