/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.auth;

import java.util.Locale;
import org.apache.hc.client5.http.impl.auth.UnsupportedDigestAlgorithmException;

enum DigestScheme$DigestAlgorithm {
    MD5("MD5", false),
    MD5_SESS("MD5", true),
    SHA_256("SHA-256", false),
    SHA_256_SESS("SHA-256", true),
    SHA_512_256("SHA-512/256", false),
    SHA_512_256_SESS("SHA-512/256", true);

    private final String baseAlgorithm;
    private final boolean sessionBased;

    private DigestScheme$DigestAlgorithm(String string2, boolean bl2) {
        this.baseAlgorithm = string2;
        this.sessionBased = bl2;
    }

    private String getBaseAlgorithm() {
        return this.baseAlgorithm;
    }

    private boolean isSessionBased() {
        return this.sessionBased;
    }

    private static DigestScheme$DigestAlgorithm fromString(String string) {
        switch (string.toUpperCase(Locale.ROOT)) {
            case "MD5": {
                return MD5;
            }
            case "MD5-SESS": {
                return MD5_SESS;
            }
            case "SHA-256": {
                return SHA_256;
            }
            case "SHA-256-SESS": {
                return SHA_256_SESS;
            }
            case "SHA-512/256": 
            case "SHA-512-256": {
                return SHA_512_256;
            }
            case "SHA-512-256-SESS": {
                return SHA_512_256_SESS;
            }
        }
        throw new UnsupportedDigestAlgorithmException("Unsupported digest algorithm: " + string);
    }

    static /* synthetic */ DigestScheme$DigestAlgorithm access$000(String string) {
        return DigestScheme$DigestAlgorithm.fromString(string);
    }

    static /* synthetic */ String access$100(DigestScheme$DigestAlgorithm digestScheme$DigestAlgorithm) {
        return digestScheme$DigestAlgorithm.getBaseAlgorithm();
    }

    static /* synthetic */ boolean access$200(DigestScheme$DigestAlgorithm digestScheme$DigestAlgorithm) {
        return digestScheme$DigestAlgorithm.isSessionBased();
    }
}

