/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.auth;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.Principal;
import java.security.SecureRandom;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.hc.client5.http.auth.AuthChallenge;
import org.apache.hc.client5.http.auth.AuthScheme;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.AuthenticationException;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.MalformedChallengeException;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.impl.auth.AuthSchemeSupport;
import org.apache.hc.client5.http.impl.auth.DigestScheme$DigestAlgorithm;
import org.apache.hc.client5.http.impl.auth.DigestScheme$QualityOfProtection;
import org.apache.hc.client5.http.impl.auth.HttpEntityDigester;
import org.apache.hc.client5.http.impl.auth.UnsupportedDigestAlgorithmException;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.utils.ByteArrayBuilder;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.message.BasicHeaderValueFormatter;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.net.PercentCodec;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.CharArrayBuffer;
import org.apache.hc.core5.util.TextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DigestScheme
implements Serializable,
AuthScheme {
    private static final long serialVersionUID = 3883908186234566916L;
    private static final Logger LOG = LoggerFactory.getLogger(DigestScheme.class);
    private static final char[] HEXADECIMAL = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private transient Charset defaultCharset = StandardCharsets.UTF_8;
    private final Map<String, String> paramMap = new HashMap<String, String>();
    private boolean complete = false;
    private transient ByteArrayBuilder buffer;
    private boolean userhashSupported = false;
    private String lastNonce;
    private long nounceCount;
    private String cnonce;
    private byte[] a1;
    private byte[] a2;
    private UsernamePasswordCredentials credentials;

    public DigestScheme() {
    }

    @Deprecated
    public DigestScheme(Charset charset) {
        this();
    }

    public void initPreemptive(Credentials credentials, String string, String string2) {
        Args.notNull(credentials, "Credentials");
        Args.check(credentials instanceof UsernamePasswordCredentials, "Unsupported credential type: " + credentials.getClass());
        this.credentials = (UsernamePasswordCredentials)credentials;
        this.paramMap.put("cnonce", string);
        this.paramMap.put("realm", string2);
    }

    @Override
    public String getName() {
        return "Digest";
    }

    @Override
    public boolean isConnectionBased() {
        return false;
    }

    @Override
    public String getRealm() {
        return this.paramMap.get("realm");
    }

    @Override
    public void processChallenge(AuthChallenge object, HttpContext object2) throws MalformedChallengeException {
        Args.notNull(object, "AuthChallenge");
        this.paramMap.clear();
        object = ((AuthChallenge)object).getParams();
        if (object != null) {
            object = object.iterator();
            while (object.hasNext()) {
                object2 = (NameValuePair)object.next();
                this.paramMap.put(object2.getName().toLowerCase(Locale.ROOT), object2.getValue());
            }
        }
        if (this.paramMap.isEmpty()) {
            throw new MalformedChallengeException("Missing digest auth parameters");
        }
        object = this.paramMap.get("userhash");
        this.userhashSupported = "true".equalsIgnoreCase((String)object);
        this.complete = true;
    }

    @Override
    public boolean isChallengeComplete() {
        String string = this.paramMap.get("stale");
        return !"true".equalsIgnoreCase(string) && this.complete;
    }

    @Override
    public boolean isResponseReady(HttpHost object, CredentialsProvider object2, HttpContext httpContext) throws AuthenticationException {
        Args.notNull(object, "Auth host");
        Args.notNull(object2, "CredentialsProvider");
        object = new AuthScope((HttpHost)object, this.getRealm(), this.getName());
        object2 = object2.getCredentials((AuthScope)object, httpContext);
        if (object2 instanceof UsernamePasswordCredentials) {
            this.credentials = (UsernamePasswordCredentials)object2;
            return true;
        }
        if (LOG.isDebugEnabled()) {
            object2 = HttpClientContext.cast(httpContext);
            object2 = ((HttpClientContext)object2).getExchangeId();
            LOG.debug("{} No credentials found for auth scope [{}]", object2, object);
        }
        this.credentials = null;
        return false;
    }

    @Override
    public Principal getPrincipal() {
        return null;
    }

    @Override
    public String generateAuthResponse(HttpHost object, HttpRequest httpRequest, HttpContext object2) throws AuthenticationException {
        Args.notNull(httpRequest, "HTTP request");
        if (this.paramMap.get("realm") == null) {
            throw new AuthenticationException("missing realm");
        }
        if (this.paramMap.get("nonce") == null) {
            throw new AuthenticationException("missing nonce");
        }
        if (object2 != null && !TextUtils.isBlank((CharSequence)(object2 = ((HttpClientContext)(object = HttpClientContext.cast((HttpContext)object2))).getNextNonce()))) {
            this.paramMap.put("nonce", (String)object2);
            ((HttpClientContext)object).setNextNonce(null);
        }
        return this.createDigestResponse(httpRequest);
    }

    private static MessageDigest createMessageDigest(String string) throws UnsupportedDigestAlgorithmException {
        try {
            return MessageDigest.getInstance(string);
        }
        catch (Exception exception) {
            throw new UnsupportedDigestAlgorithmException("Unsupported algorithm in HTTP Digest authentication: " + string);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String createDigestResponse(HttpRequest object) throws AuthenticationException {
        Object object2;
        String string;
        DigestScheme$DigestAlgorithm digestScheme$DigestAlgorithm;
        Object object3;
        if (this.credentials == null) {
            throw new AuthenticationException("User credentials have not been provided");
        }
        Object object4 = object.getRequestUri();
        CharSequence charSequence = object.getMethod();
        String string2 = this.paramMap.get("realm");
        String string3 = this.paramMap.get("nonce");
        String string4 = this.paramMap.get("opaque");
        String string5 = this.paramMap.get("algorithm");
        AbstractCollection abstractCollection = new HashSet<String>(8);
        DigestScheme$QualityOfProtection digestScheme$QualityOfProtection = DigestScheme$QualityOfProtection.UNKNOWN;
        Object object5 = this.paramMap.get("qop");
        if (object5 != null) {
            object3 = new StringTokenizer((String)object5, ",");
            while (((StringTokenizer)object3).hasMoreTokens()) {
                String string6 = ((StringTokenizer)object3).nextToken().trim();
                abstractCollection.add(string6.toLowerCase(Locale.ROOT));
            }
            HttpEntity httpEntity = object instanceof ClassicHttpRequest ? ((ClassicHttpRequest)object).getEntity() : null;
            if (httpEntity != null && abstractCollection.contains("auth-int")) {
                digestScheme$QualityOfProtection = DigestScheme$QualityOfProtection.AUTH_INT;
            } else if (abstractCollection.contains("auth")) {
                digestScheme$QualityOfProtection = DigestScheme$QualityOfProtection.AUTH;
            } else if (abstractCollection.contains("auth-int")) {
                digestScheme$QualityOfProtection = DigestScheme$QualityOfProtection.AUTH_INT;
            }
        } else {
            digestScheme$QualityOfProtection = DigestScheme$QualityOfProtection.MISSING;
        }
        if (digestScheme$QualityOfProtection == DigestScheme$QualityOfProtection.UNKNOWN) {
            throw new AuthenticationException("None of the qop methods is supported: " + (String)object5);
        }
        object3 = AuthSchemeSupport.parseCharset(this.paramMap.get("charset"), this.defaultCharset);
        Object var12_18 = null;
        try {
            digestScheme$DigestAlgorithm = DigestScheme$DigestAlgorithm.access$000(string5 == null ? "MD5" : string5);
            object5 = DigestScheme.createMessageDigest(DigestScheme$DigestAlgorithm.access$100(digestScheme$DigestAlgorithm));
        }
        catch (UnsupportedDigestAlgorithmException unsupportedDigestAlgorithmException) {
            throw new AuthenticationException("Unsupported digest algorithm: " + var12_18);
        }
        if (string3.equals(this.lastNonce)) {
            ++this.nounceCount;
        } else {
            this.nounceCount = 1L;
            this.cnonce = null;
            this.lastNonce = string3;
        }
        Object object6 = new StringBuilder(8);
        Object object7 = new Formatter((Appendable)object6, Locale.ROOT);
        Object object8 = null;
        try {
            ((Formatter)object7).format("%08x", this.nounceCount);
            ((Formatter)object7).close();
        }
        catch (Throwable throwable) {
            try {
                object3 = throwable;
                object8 = throwable;
                throw object3;
            }
            catch (Throwable throwable2) {
                if (object8 != null) {
                    try {
                        ((Formatter)object7).close();
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        ((Throwable)object8).addSuppressed(throwable3);
                    }
                    throw throwable2;
                } else {
                    ((Formatter)object7).close();
                }
                throw throwable2;
            }
        }
        object7 = ((StringBuilder)object6).toString();
        if (this.cnonce == null) {
            this.cnonce = DigestScheme.formatHex(DigestScheme.createCnonce(digestScheme$DigestAlgorithm));
        }
        if (this.buffer == null) {
            this.buffer = new ByteArrayBuilder(128);
        } else {
            this.buffer.reset();
        }
        this.buffer.charset((Charset)object3);
        this.a1 = null;
        this.a2 = null;
        object8 = this.credentials.getUserName();
        object3 = null;
        if (object8 != null && this.containsInvalidABNFChars((String)object8)) {
            object3 = "UTF-8''" + PercentCodec.RFC5987.encode((CharSequence)object8);
        }
        if (this.userhashSupported) {
            string = (String)object8 + ":" + string2;
            object2 = ((MessageDigest)object5).digest(string.getBytes(StandardCharsets.UTF_8));
            object8 = object6 = DigestScheme.formatHex((byte[])object2);
        } else {
            object6 = object3 != null ? object3 : object8;
        }
        if (DigestScheme$DigestAlgorithm.access$200(digestScheme$DigestAlgorithm)) {
            this.buffer.append((String)object8).append(":").append(string2).append(":").append(this.credentials.getUserPassword());
            string = DigestScheme.formatHex(((MessageDigest)object5).digest(this.buffer.toByteArray()));
            this.buffer.reset();
            this.buffer.append(string).append(":").append(string3).append(":").append(this.cnonce);
        } else {
            this.buffer.append((String)object8).append(":").append(string2).append(":").append(this.credentials.getUserPassword());
        }
        this.a1 = this.buffer.toByteArray();
        string = DigestScheme.formatHex(((MessageDigest)object5).digest(this.a1));
        this.buffer.reset();
        if (digestScheme$QualityOfProtection == DigestScheme$QualityOfProtection.AUTH) {
            this.a2 = this.buffer.append((String)charSequence).append(":").append((String)object4).toByteArray();
        } else if (digestScheme$QualityOfProtection == DigestScheme$QualityOfProtection.AUTH_INT) {
            HttpEntity httpEntity = object instanceof ClassicHttpRequest ? ((ClassicHttpRequest)object).getEntity() : null;
            object2 = httpEntity;
            if (httpEntity != null && !object2.isRepeatable()) {
                if (!abstractCollection.contains("auth")) throw new AuthenticationException("Qop auth-int cannot be used with a non-repeatable entity");
                digestScheme$QualityOfProtection = DigestScheme$QualityOfProtection.AUTH;
                this.a2 = this.buffer.append((String)charSequence).append(":").append((String)object4).toByteArray();
            } else {
                object = new HttpEntityDigester((MessageDigest)object5);
                try {
                    if (object2 != null) {
                        object2.writeTo((OutputStream)object);
                    }
                    ((HttpEntityDigester)object).close();
                }
                catch (IOException iOException) {
                    throw new AuthenticationException("I/O error reading entity content", iOException);
                }
                this.a2 = this.buffer.append((String)charSequence).append(":").append((String)object4).append(":").append(DigestScheme.formatHex(((HttpEntityDigester)object).getDigest())).toByteArray();
            }
        } else {
            this.a2 = this.buffer.append((String)charSequence).append(":").append((String)object4).toByteArray();
        }
        object2 = DigestScheme.formatHex(((MessageDigest)object5).digest(this.a2));
        this.buffer.reset();
        if (digestScheme$QualityOfProtection == DigestScheme$QualityOfProtection.MISSING) {
            this.buffer.append(string).append(":").append(string3).append(":").append((String)object2);
        } else {
            this.buffer.append(string).append(":").append(string3).append(":").append((String)object7).append(":").append(this.cnonce).append(":").append(digestScheme$QualityOfProtection == DigestScheme$QualityOfProtection.AUTH_INT ? "auth-int" : "auth").append(":").append((String)object2);
        }
        object = this.buffer.toByteArray();
        this.buffer.reset();
        object = DigestScheme.formatHex(((MessageDigest)object5).digest((byte[])object));
        charSequence = new CharArrayBuffer(128);
        ((CharArrayBuffer)charSequence).append("Digest ");
        abstractCollection = new ArrayList(20);
        if (this.userhashSupported) {
            abstractCollection.add((BasicNameValuePair)new BasicNameValuePair("username", (String)object6));
            abstractCollection.add(new BasicNameValuePair("userhash", "true"));
        } else if (object3 != null) {
            abstractCollection.add(new BasicNameValuePair("username*", (String)object3));
        } else {
            abstractCollection.add(new BasicNameValuePair("username", (String)object8));
        }
        abstractCollection.add(new BasicNameValuePair("realm", string2));
        abstractCollection.add(new BasicNameValuePair("nonce", string3));
        abstractCollection.add(new BasicNameValuePair("uri", (String)object4));
        abstractCollection.add(new BasicNameValuePair("response", (String)object));
        if (digestScheme$QualityOfProtection != DigestScheme$QualityOfProtection.MISSING) {
            abstractCollection.add(new BasicNameValuePair("qop", digestScheme$QualityOfProtection == DigestScheme$QualityOfProtection.AUTH_INT ? "auth-int" : "auth"));
            abstractCollection.add(new BasicNameValuePair("nc", (String)object7));
            abstractCollection.add(new BasicNameValuePair("cnonce", this.cnonce));
        }
        if (string5 != null) {
            abstractCollection.add(new BasicNameValuePair("algorithm", string5));
        }
        if (string4 != null) {
            abstractCollection.add(new BasicNameValuePair("opaque", string4));
        }
        for (int i2 = 0; i2 < abstractCollection.size(); ++i2) {
            String string7;
            object4 = (BasicNameValuePair)abstractCollection.get(i2);
            if (i2 > 0) {
                ((CharArrayBuffer)charSequence).append(", ");
            }
            boolean bl2 = "nc".equals(string7 = ((BasicNameValuePair)object4).getName()) || "qop".equals(string7) || "algorithm".equals(string7);
            BasicHeaderValueFormatter.INSTANCE.formatNameValuePair((CharArrayBuffer)charSequence, (NameValuePair)object4, !bl2);
        }
        return ((CharArrayBuffer)charSequence).toString();
    }

    @Internal
    public String getNonce() {
        return this.lastNonce;
    }

    @Internal
    public long getNounceCount() {
        return this.nounceCount;
    }

    @Internal
    public String getCnonce() {
        return this.cnonce;
    }

    String getA1() {
        if (this.a1 != null) {
            return new String(this.a1, StandardCharsets.US_ASCII);
        }
        return null;
    }

    String getA2() {
        if (this.a2 != null) {
            return new String(this.a2, StandardCharsets.US_ASCII);
        }
        return null;
    }

    static String formatHex(byte[] byArray) {
        int n2 = byArray.length;
        char[] cArray = new char[n2 << 1];
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = byArray[i2] & 0xF;
            int n4 = (byArray[i2] & 0xF0) >> 4;
            cArray[i2 << 1] = HEXADECIMAL[n4];
            cArray[(i2 << 1) + 1] = HEXADECIMAL[n3];
        }
        return new String(cArray);
    }

    static byte[] createCnonce(DigestScheme$DigestAlgorithm object) {
        int n2;
        SecureRandom secureRandom = new SecureRandom();
        switch (((Enum)object).name().toUpperCase()) {
            case "SHA-256": 
            case "SHA-512/256": {
                n2 = 32;
                break;
            }
            default: {
                n2 = 16;
            }
        }
        byte[] byArray = new byte[n2];
        secureRandom.nextBytes(byArray);
        return byArray;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeUTF(this.defaultCharset.name());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.defaultCharset = Charset.forName(objectInputStream.readUTF());
    }

    public String toString() {
        return this.getName() + this.paramMap;
    }

    private boolean containsInvalidABNFChars(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Input string should not be null.");
        }
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 <= '\u001f' || c2 == '\u007f') {
                return true;
            }
            if (c2 > '~') {
                return true;
            }
            if (c2 != '\"' && c2 != '\\') continue;
            return true;
        }
        return false;
    }
}

