/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.auth;

import java.net.UnknownHostException;
import java.security.Principal;
import org.apache.hc.client5.http.DnsResolver;
import org.apache.hc.client5.http.SystemDefaultDnsResolver;
import org.apache.hc.client5.http.auth.AuthChallenge;
import org.apache.hc.client5.http.auth.AuthScheme;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.AuthenticationException;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.InvalidCredentialsException;
import org.apache.hc.client5.http.auth.KerberosConfig;
import org.apache.hc.client5.http.auth.KerberosConfig$Option;
import org.apache.hc.client5.http.auth.KerberosCredentials;
import org.apache.hc.client5.http.auth.MalformedChallengeException;
import org.apache.hc.client5.http.impl.auth.GGSSchemeBase$State;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.utils.Base64;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.Args;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public abstract class GGSSchemeBase
implements AuthScheme {
    private static final Logger LOG = LoggerFactory.getLogger(GGSSchemeBase.class);
    private static final String NO_TOKEN = "";
    private static final String KERBEROS_SCHEME = "HTTP";
    private final KerberosConfig config;
    private final DnsResolver dnsResolver;
    private GGSSchemeBase$State state;
    private GSSCredential gssCredential;
    private String challenge;
    private byte[] token;

    GGSSchemeBase(KerberosConfig kerberosConfig, DnsResolver dnsResolver) {
        this.config = kerberosConfig != null ? kerberosConfig : KerberosConfig.DEFAULT;
        this.dnsResolver = dnsResolver != null ? dnsResolver : SystemDefaultDnsResolver.INSTANCE;
        this.state = GGSSchemeBase$State.UNINITIATED;
    }

    GGSSchemeBase(KerberosConfig kerberosConfig) {
        this(kerberosConfig, SystemDefaultDnsResolver.INSTANCE);
    }

    GGSSchemeBase() {
        this(KerberosConfig.DEFAULT, SystemDefaultDnsResolver.INSTANCE);
    }

    @Override
    public String getRealm() {
        return null;
    }

    @Override
    public void processChallenge(AuthChallenge object, HttpContext httpContext) throws MalformedChallengeException {
        Args.notNull(object, "AuthChallenge");
        String string = this.challenge = ((AuthChallenge)object).getValue() != null ? ((AuthChallenge)object).getValue() : NO_TOKEN;
        if (this.state == GGSSchemeBase$State.UNINITIATED) {
            this.token = Base64.decodeBase64(this.challenge.getBytes());
            this.state = GGSSchemeBase$State.CHALLENGE_RECEIVED;
            return;
        }
        if (LOG.isDebugEnabled()) {
            object = HttpClientContext.cast(httpContext);
            object = ((HttpClientContext)object).getExchangeId();
            LOG.debug("{} Authentication already attempted", object);
        }
        this.state = GGSSchemeBase$State.FAILED;
    }

    protected GSSManager getManager() {
        return GSSManager.getInstance();
    }

    protected byte[] generateGSSToken(byte[] byArray, Oid object, String object2, String string) throws GSSException {
        GSSManager gSSManager = this.getManager();
        object2 = gSSManager.createName((String)object2 + "@" + string, GSSName.NT_HOSTBASED_SERVICE);
        object = this.createGSSContext(gSSManager, (Oid)object, (GSSName)object2, this.gssCredential);
        if (byArray != null) {
            return object.initSecContext(byArray, 0, byArray.length);
        }
        return object.initSecContext(new byte[0], 0, 0);
    }

    protected GSSContext createGSSContext(GSSManager object, Oid oid, GSSName gSSName, GSSCredential gSSCredential) throws GSSException {
        object = ((GSSManager)object).createContext(gSSName.canonicalize(oid), oid, gSSCredential, 0);
        object.requestMutualAuth(true);
        if (this.config.getRequestDelegCreds() != KerberosConfig$Option.DEFAULT) {
            object.requestCredDeleg(this.config.getRequestDelegCreds() == KerberosConfig$Option.ENABLE);
        }
        return object;
    }

    protected abstract byte[] generateToken(byte[] var1, String var2, String var3) throws GSSException;

    @Override
    public boolean isChallengeComplete() {
        return this.state == GGSSchemeBase$State.TOKEN_GENERATED || this.state == GGSSchemeBase$State.FAILED;
    }

    @Override
    public boolean isResponseReady(HttpHost object, CredentialsProvider credentialsProvider, HttpContext httpContext) throws AuthenticationException {
        Args.notNull(object, "Auth host");
        Args.notNull(credentialsProvider, "CredentialsProvider");
        object = credentialsProvider.getCredentials(new AuthScope((HttpHost)object, null, this.getName()), httpContext);
        this.gssCredential = object instanceof KerberosCredentials ? ((KerberosCredentials)object).getGSSCredential() : null;
        return true;
    }

    @Override
    public Principal getPrincipal() {
        return null;
    }

    @Override
    public String generateAuthResponse(HttpHost object, HttpRequest object2, HttpContext httpContext) throws AuthenticationException {
        Args.notNull(object, "HTTP host");
        Args.notNull(object2, "HTTP request");
        switch (this.state) {
            case UNINITIATED: {
                throw new AuthenticationException(this.getName() + " authentication has not been initiated");
            }
            case FAILED: {
                throw new AuthenticationException(this.getName() + " authentication has failed");
            }
            case CHALLENGE_RECEIVED: {
                Object object3;
                try {
                    object2 = ((HttpHost)object).getHostName();
                    if (this.config.getUseCanonicalHostname() != KerberosConfig$Option.DISABLE) {
                        try {
                            object2 = this.dnsResolver.resolveCanonicalHostname(((HttpHost)object).getHostName());
                        }
                        catch (UnknownHostException unknownHostException) {}
                    }
                    object = this.config.getStripPort() != KerberosConfig$Option.DISABLE ? object2 : (String)object2 + ":" + ((HttpHost)object).getPort();
                    if (LOG.isDebugEnabled()) {
                        object3 = HttpClientContext.cast(httpContext);
                        object3 = ((HttpClientContext)object3).getExchangeId();
                        LOG.debug("{} init {}", object3, object);
                    }
                    this.token = this.generateToken(this.token, KERBEROS_SCHEME, (String)object);
                    this.state = GGSSchemeBase$State.TOKEN_GENERATED;
                }
                catch (GSSException gSSException) {
                    this.state = GGSSchemeBase$State.FAILED;
                    if (gSSException.getMajor() == 9 || gSSException.getMajor() == 8) {
                        throw new InvalidCredentialsException(gSSException.getMessage(), gSSException);
                    }
                    if (gSSException.getMajor() == 13) {
                        throw new InvalidCredentialsException(gSSException.getMessage(), gSSException);
                    }
                    if (gSSException.getMajor() == 10 || gSSException.getMajor() == 19 || gSSException.getMajor() == 20) {
                        throw new AuthenticationException(gSSException.getMessage(), gSSException);
                    }
                    throw new AuthenticationException(gSSException.getMessage());
                }
            }
            case TOKEN_GENERATED: {
                Object object3;
                object = new Base64(0);
                object2 = new String(((Base64)object).encode(this.token));
                if (LOG.isDebugEnabled()) {
                    object3 = HttpClientContext.cast(httpContext);
                    object3 = ((HttpClientContext)object3).getExchangeId();
                    LOG.debug("{} Sending response '{}' back to the auth server", object3, object2);
                }
                return "Negotiate " + (String)object2;
            }
        }
        throw new IllegalStateException("Illegal state: " + (Object)((Object)this.state));
    }

    public String toString() {
        return this.getName() + "{" + (Object)((Object)this.state) + " " + this.challenge + '}';
    }
}

