/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.auth;

import java.security.Key;
import java.util.Arrays;
import java.util.Random;
import javax.crypto.Cipher;
import org.apache.hc.client5.http.impl.auth.NTLMEngineException;
import org.apache.hc.client5.http.impl.auth.NTLMEngineImpl;
import org.apache.hc.client5.http.impl.auth.NTLMEngineImpl$MD4;

class NTLMEngineImpl$CipherGen {
    final Random random;
    final long currentTime;
    final String domain;
    final String user;
    final char[] password;
    final byte[] challenge;
    final String target;
    final byte[] targetInformation;
    byte[] clientChallenge;
    byte[] clientChallenge2;
    byte[] secondaryKey;
    byte[] timestamp;
    byte[] lmHash;
    byte[] lmResponse;
    byte[] ntlmHash;
    byte[] ntlmResponse;
    byte[] ntlmv2Hash;
    byte[] lmv2Hash;
    byte[] lmv2Response;
    byte[] ntlmv2Blob;
    byte[] ntlmv2Response;
    byte[] ntlm2SessionResponse;
    byte[] lm2SessionResponse;
    byte[] lmUserSessionKey;
    byte[] ntlmUserSessionKey;
    byte[] ntlmv2UserSessionKey;
    byte[] ntlm2SessionResponseUserSessionKey;
    byte[] lanManagerSessionKey;

    NTLMEngineImpl$CipherGen(Random random, long l2, String string, String string2, char[] cArray, byte[] byArray, String string3, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5, byte[] byArray6) {
        this.random = random;
        this.currentTime = l2;
        this.domain = string;
        this.target = string3;
        this.user = string2;
        this.password = cArray;
        this.challenge = byArray;
        this.targetInformation = byArray2;
        this.clientChallenge = byArray3;
        this.clientChallenge2 = byArray4;
        this.secondaryKey = byArray5;
        this.timestamp = byArray6;
    }

    NTLMEngineImpl$CipherGen(Random random, long l2, String string, String string2, char[] cArray, byte[] byArray, String string3, byte[] byArray2) {
        this(random, l2, string, string2, cArray, byArray, string3, byArray2, null, null, null, null);
    }

    byte[] getClientChallenge() {
        if (this.clientChallenge == null) {
            this.clientChallenge = NTLMEngineImpl.access$000(this.random);
        }
        return this.clientChallenge;
    }

    byte[] getClientChallenge2() {
        if (this.clientChallenge2 == null) {
            this.clientChallenge2 = NTLMEngineImpl.access$000(this.random);
        }
        return this.clientChallenge2;
    }

    byte[] getSecondaryKey() {
        if (this.secondaryKey == null) {
            this.secondaryKey = NTLMEngineImpl.access$100(this.random);
        }
        return this.secondaryKey;
    }

    byte[] getLMHash() throws NTLMEngineException {
        if (this.lmHash == null) {
            this.lmHash = NTLMEngineImpl.access$200(this.password);
        }
        return this.lmHash;
    }

    byte[] getLMResponse() throws NTLMEngineException {
        if (this.lmResponse == null) {
            this.lmResponse = NTLMEngineImpl.access$300(this.getLMHash(), this.challenge);
        }
        return this.lmResponse;
    }

    byte[] getNTLMHash() {
        if (this.ntlmHash == null) {
            this.ntlmHash = NTLMEngineImpl.access$400(this.password);
        }
        return this.ntlmHash;
    }

    byte[] getNTLMResponse() throws NTLMEngineException {
        if (this.ntlmResponse == null) {
            this.ntlmResponse = NTLMEngineImpl.access$300(this.getNTLMHash(), this.challenge);
        }
        return this.ntlmResponse;
    }

    byte[] getLMv2Hash() {
        if (this.lmv2Hash == null) {
            this.lmv2Hash = NTLMEngineImpl.access$500(this.domain, this.user, this.getNTLMHash());
        }
        return this.lmv2Hash;
    }

    byte[] getNTLMv2Hash() {
        if (this.ntlmv2Hash == null) {
            this.ntlmv2Hash = NTLMEngineImpl.access$600(this.domain, this.user, this.getNTLMHash());
        }
        return this.ntlmv2Hash;
    }

    byte[] getTimestamp() {
        if (this.timestamp == null) {
            long l2 = this.currentTime;
            l2 += 11644473600000L;
            l2 *= 10000L;
            this.timestamp = new byte[8];
            for (int i2 = 0; i2 < 8; ++i2) {
                this.timestamp[i2] = (byte)l2;
                l2 >>>= 8;
            }
        }
        return this.timestamp;
    }

    byte[] getNTLMv2Blob() {
        if (this.ntlmv2Blob == null) {
            this.ntlmv2Blob = NTLMEngineImpl.access$700(this.getClientChallenge2(), this.targetInformation, this.getTimestamp());
        }
        return this.ntlmv2Blob;
    }

    byte[] getNTLMv2Response() {
        if (this.ntlmv2Response == null) {
            this.ntlmv2Response = NTLMEngineImpl.access$800(this.getNTLMv2Hash(), this.challenge, this.getNTLMv2Blob());
        }
        return this.ntlmv2Response;
    }

    byte[] getLMv2Response() {
        if (this.lmv2Response == null) {
            this.lmv2Response = NTLMEngineImpl.access$800(this.getLMv2Hash(), this.challenge, this.getClientChallenge());
        }
        return this.lmv2Response;
    }

    byte[] getNTLM2SessionResponse() throws NTLMEngineException {
        if (this.ntlm2SessionResponse == null) {
            this.ntlm2SessionResponse = NTLMEngineImpl.ntlm2SessionResponse(this.getNTLMHash(), this.challenge, this.getClientChallenge());
        }
        return this.ntlm2SessionResponse;
    }

    byte[] getLM2SessionResponse() {
        if (this.lm2SessionResponse == null) {
            byte[] byArray = this.getClientChallenge();
            this.lm2SessionResponse = new byte[24];
            System.arraycopy(byArray, 0, this.lm2SessionResponse, 0, byArray.length);
            Arrays.fill(this.lm2SessionResponse, byArray.length, this.lm2SessionResponse.length, (byte)0);
        }
        return this.lm2SessionResponse;
    }

    byte[] getLMUserSessionKey() throws NTLMEngineException {
        if (this.lmUserSessionKey == null) {
            this.lmUserSessionKey = new byte[16];
            System.arraycopy(this.getLMHash(), 0, this.lmUserSessionKey, 0, 8);
            Arrays.fill(this.lmUserSessionKey, 8, 16, (byte)0);
        }
        return this.lmUserSessionKey;
    }

    byte[] getNTLMUserSessionKey() {
        if (this.ntlmUserSessionKey == null) {
            NTLMEngineImpl$MD4 nTLMEngineImpl$MD4 = new NTLMEngineImpl$MD4();
            nTLMEngineImpl$MD4.update(this.getNTLMHash());
            this.ntlmUserSessionKey = nTLMEngineImpl$MD4.getOutput();
        }
        return this.ntlmUserSessionKey;
    }

    byte[] getNTLMv2UserSessionKey() {
        if (this.ntlmv2UserSessionKey == null) {
            byte[] byArray = this.getNTLMv2Hash();
            byte[] byArray2 = new byte[16];
            System.arraycopy(this.getNTLMv2Response(), 0, byArray2, 0, 16);
            this.ntlmv2UserSessionKey = NTLMEngineImpl.hmacMD5(byArray2, byArray);
        }
        return this.ntlmv2UserSessionKey;
    }

    byte[] getNTLM2SessionResponseUserSessionKey() {
        if (this.ntlm2SessionResponseUserSessionKey == null) {
            byte[] byArray = this.getLM2SessionResponse();
            byte[] byArray2 = new byte[this.challenge.length + byArray.length];
            System.arraycopy(this.challenge, 0, byArray2, 0, this.challenge.length);
            System.arraycopy(byArray, 0, byArray2, this.challenge.length, byArray.length);
            this.ntlm2SessionResponseUserSessionKey = NTLMEngineImpl.hmacMD5(byArray2, this.getNTLMUserSessionKey());
        }
        return this.ntlm2SessionResponseUserSessionKey;
    }

    byte[] getLanManagerSessionKey() throws NTLMEngineException {
        if (this.lanManagerSessionKey == null) {
            try {
                Object object = new byte[14];
                System.arraycopy(this.getLMHash(), 0, object, 0, 8);
                Arrays.fill(object, 8, ((byte[])object).length, (byte)-67);
                Object object2 = NTLMEngineImpl.access$900(object, 0);
                object = NTLMEngineImpl.access$900(object, 7);
                byte[] byArray = new byte[8];
                System.arraycopy(this.getLMResponse(), 0, byArray, 0, byArray.length);
                Cipher cipher = Cipher.getInstance("DES/ECB/NoPadding");
                cipher.init(1, (Key)object2);
                object2 = cipher.doFinal(byArray);
                cipher = Cipher.getInstance("DES/ECB/NoPadding");
                cipher.init(1, (Key)object);
                object = cipher.doFinal(byArray);
                this.lanManagerSessionKey = new byte[16];
                System.arraycopy(object2, 0, this.lanManagerSessionKey, 0, ((Object)object2).length);
                System.arraycopy(object, 0, this.lanManagerSessionKey, ((Object)object2).length, ((byte[])object).length);
            }
            catch (Exception exception) {
                throw new NTLMEngineException(exception.getMessage(), exception);
            }
        }
        return this.lanManagerSessionKey;
    }
}

