/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.auth;

import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.Locale;
import java.util.Random;
import org.apache.hc.client5.http.impl.auth.NTLMEngineException;
import org.apache.hc.client5.http.impl.auth.NTLMEngineImpl;
import org.apache.hc.client5.http.impl.auth.NTLMEngineImpl$CipherGen;
import org.apache.hc.client5.http.impl.auth.NTLMEngineImpl$HMACMD5;
import org.apache.hc.client5.http.impl.auth.NTLMEngineImpl$NTLMMessage;

class NTLMEngineImpl$Type3Message
extends NTLMEngineImpl$NTLMMessage {
    final byte[] type1Message;
    final byte[] type2Message;
    final int type2Flags;
    final byte[] domainBytes;
    final byte[] hostBytes;
    final byte[] userBytes;
    byte[] lmResp;
    byte[] ntResp;
    final byte[] sessionKey;
    final byte[] exportedSessionKey;
    final boolean computeMic;

    NTLMEngineImpl$Type3Message(String string, String string2, String string3, char[] cArray, byte[] byArray, int n2, String string4, byte[] byArray2) throws NTLMEngineException {
        this(string, string2, string3, cArray, byArray, n2, string4, byArray2, null, null, null);
    }

    NTLMEngineImpl$Type3Message(Random random, long l2, String string, String string2, String string3, char[] cArray, byte[] byArray, int n2, String string4, byte[] byArray2) throws NTLMEngineException {
        this(random, l2, string, string2, string3, cArray, byArray, n2, string4, byArray2, null, null, null);
    }

    NTLMEngineImpl$Type3Message(String string, String string2, String string3, char[] cArray, byte[] byArray, int n2, String string4, byte[] byArray2, Certificate certificate, byte[] byArray3, byte[] byArray4) throws NTLMEngineException {
        this(NTLMEngineImpl.access$2300(), System.currentTimeMillis(), string, string2, string3, cArray, byArray, n2, string4, byArray2, certificate, byArray3, byArray4);
    }

    NTLMEngineImpl$Type3Message(Random object, long l2, String string, String string2, String string3, char[] cArray, byte[] byArray, int n2, String string4, byte[] byArray2, Certificate certificate, byte[] byArray3, byte[] byArray4) throws NTLMEngineException {
        byte[] byArray5;
        if (object == null) {
            throw new NTLMEngineException("Random generator not available");
        }
        this.type2Flags = n2;
        this.type1Message = byArray3;
        this.type2Message = byArray4;
        byArray3 = byArray2;
        if (certificate != null) {
            byArray3 = this.addGssMicAvsToTargetInfo(byArray2, certificate);
            this.computeMic = true;
        } else {
            this.computeMic = false;
        }
        object = new NTLMEngineImpl$CipherGen((Random)object, l2, string, string3, cArray, byArray, string4, byArray3);
        try {
            if ((n2 & 0x800000) != 0 && byArray2 != null && string4 != null) {
                this.ntResp = ((NTLMEngineImpl$CipherGen)object).getNTLMv2Response();
                this.lmResp = ((NTLMEngineImpl$CipherGen)object).getLMv2Response();
                byArray5 = (n2 & 0x80) != 0 ? ((NTLMEngineImpl$CipherGen)object).getLanManagerSessionKey() : ((NTLMEngineImpl$CipherGen)object).getNTLMv2UserSessionKey();
            } else if ((n2 & 0x80000) != 0) {
                this.ntResp = ((NTLMEngineImpl$CipherGen)object).getNTLM2SessionResponse();
                this.lmResp = ((NTLMEngineImpl$CipherGen)object).getLM2SessionResponse();
                byArray5 = (n2 & 0x80) != 0 ? ((NTLMEngineImpl$CipherGen)object).getLanManagerSessionKey() : ((NTLMEngineImpl$CipherGen)object).getNTLM2SessionResponseUserSessionKey();
            } else {
                this.ntResp = ((NTLMEngineImpl$CipherGen)object).getNTLMResponse();
                this.lmResp = ((NTLMEngineImpl$CipherGen)object).getLMResponse();
                byArray5 = (n2 & 0x80) != 0 ? ((NTLMEngineImpl$CipherGen)object).getLanManagerSessionKey() : ((NTLMEngineImpl$CipherGen)object).getNTLMUserSessionKey();
            }
        }
        catch (NTLMEngineException nTLMEngineException) {
            this.ntResp = new byte[0];
            this.lmResp = ((NTLMEngineImpl$CipherGen)object).getLMResponse();
            byArray5 = (n2 & 0x80) != 0 ? ((NTLMEngineImpl$CipherGen)object).getLanManagerSessionKey() : ((NTLMEngineImpl$CipherGen)object).getLMUserSessionKey();
        }
        if ((n2 & 0x10) != 0) {
            if ((n2 & 0x40000000) != 0) {
                this.exportedSessionKey = ((NTLMEngineImpl$CipherGen)object).getSecondaryKey();
                this.sessionKey = NTLMEngineImpl.RC4(this.exportedSessionKey, byArray5);
            } else {
                this.sessionKey = byArray5;
                this.exportedSessionKey = this.sessionKey;
            }
        } else {
            if (this.computeMic) {
                throw new NTLMEngineException("Cannot sign/seal: no exported session key");
            }
            this.sessionKey = null;
            this.exportedSessionKey = null;
        }
        object = NTLMEngineImpl.access$2200(n2);
        this.hostBytes = string2 != null ? string2.getBytes((Charset)object) : null;
        this.domainBytes = string != null ? string.toUpperCase(Locale.ROOT).getBytes((Charset)object) : null;
        this.userBytes = string3.getBytes((Charset)object);
    }

    byte[] getEncryptedRandomSessionKey() {
        return this.sessionKey;
    }

    byte[] getExportedSessionKey() {
        return this.exportedSessionKey;
    }

    @Override
    void buildMessage() {
        int n2 = this.ntResp.length;
        int n3 = this.lmResp.length;
        int n4 = this.domainBytes != null ? this.domainBytes.length : 0;
        int n5 = this.hostBytes != null ? this.hostBytes.length : 0;
        int n6 = this.userBytes.length;
        int n7 = this.sessionKey != null ? this.sessionKey.length : 0;
        int n8 = 72 + (this.computeMic ? 16 : 0);
        int n9 = n8 + n3;
        int n10 = n9 + n2;
        int n11 = n10 + n4;
        int n12 = n11 + n6;
        int n13 = n12 + n5;
        int n14 = n13 + n7;
        this.prepareResponse(n14, 3);
        this.addUShort(n3);
        this.addUShort(n3);
        this.addULong(n8);
        this.addUShort(n2);
        this.addUShort(n2);
        this.addULong(n9);
        this.addUShort(n4);
        this.addUShort(n4);
        this.addULong(n10);
        this.addUShort(n6);
        this.addUShort(n6);
        this.addULong(n11);
        this.addUShort(n5);
        this.addUShort(n5);
        this.addULong(n12);
        this.addUShort(n7);
        this.addUShort(n7);
        this.addULong(n13);
        NTLMEngineImpl$Type3Message nTLMEngineImpl$Type3Message = this;
        nTLMEngineImpl$Type3Message.addULong(nTLMEngineImpl$Type3Message.type2Flags);
        this.addUShort(261);
        this.addULong(2600);
        this.addUShort(3840);
        n2 = -1;
        if (this.computeMic) {
            n2 = this.currentOutputPosition;
            this.currentOutputPosition += 16;
        }
        NTLMEngineImpl$Type3Message nTLMEngineImpl$Type3Message2 = this;
        nTLMEngineImpl$Type3Message2.addBytes(nTLMEngineImpl$Type3Message2.lmResp);
        NTLMEngineImpl$Type3Message nTLMEngineImpl$Type3Message3 = this;
        nTLMEngineImpl$Type3Message3.addBytes(nTLMEngineImpl$Type3Message3.ntResp);
        NTLMEngineImpl$Type3Message nTLMEngineImpl$Type3Message4 = this;
        nTLMEngineImpl$Type3Message4.addBytes(nTLMEngineImpl$Type3Message4.domainBytes);
        NTLMEngineImpl$Type3Message nTLMEngineImpl$Type3Message5 = this;
        nTLMEngineImpl$Type3Message5.addBytes(nTLMEngineImpl$Type3Message5.userBytes);
        NTLMEngineImpl$Type3Message nTLMEngineImpl$Type3Message6 = this;
        nTLMEngineImpl$Type3Message6.addBytes(nTLMEngineImpl$Type3Message6.hostBytes);
        if (this.sessionKey != null) {
            NTLMEngineImpl$Type3Message nTLMEngineImpl$Type3Message7 = this;
            nTLMEngineImpl$Type3Message7.addBytes(nTLMEngineImpl$Type3Message7.sessionKey);
        }
        if (this.computeMic) {
            Object object = new NTLMEngineImpl$HMACMD5(this.exportedSessionKey);
            ((NTLMEngineImpl$HMACMD5)object).update(this.type1Message);
            ((NTLMEngineImpl$HMACMD5)object).update(this.type2Message);
            ((NTLMEngineImpl$HMACMD5)object).update(this.messageContents);
            byte[] byArray = ((NTLMEngineImpl$HMACMD5)object).getOutput();
            object = byArray;
            System.arraycopy(byArray, 0, this.messageContents, n2, ((Object)object).length);
        }
    }

    private byte[] addGssMicAvsToTargetInfo(byte[] object, Certificate object2) throws NTLMEngineException {
        byte[] byArray = new byte[((byte[])object).length + 8 + 20];
        int n2 = ((byte[])object).length - 4;
        System.arraycopy(object, 0, byArray, 0, n2);
        NTLMEngineImpl.writeUShort(byArray, 6, n2);
        NTLMEngineImpl.writeUShort(byArray, 4, n2 + 2);
        NTLMEngineImpl.writeULong(byArray, 2, n2 + 4);
        NTLMEngineImpl.writeUShort(byArray, 10, n2 + 8);
        NTLMEngineImpl.writeUShort(byArray, 16, n2 + 10);
        try {
            object = ((Certificate)object2).getEncoded();
            object2 = MessageDigest.getInstance("SHA-256");
            object = ((MessageDigest)object2).digest((byte[])object);
            byte[] byArray2 = new byte[20 + NTLMEngineImpl.access$2400().length + ((byte[])object).length];
            object2 = byArray2;
            NTLMEngineImpl.writeULong(byArray2, 53, 16);
            System.arraycopy(NTLMEngineImpl.access$2400(), 0, object2, 20, NTLMEngineImpl.access$2400().length);
            System.arraycopy(object, 0, object2, 20 + NTLMEngineImpl.access$2400().length, ((byte[])object).length);
            MessageDigest messageDigest = NTLMEngineImpl.getMD5();
            object = messageDigest;
            object = messageDigest.digest((byte[])object2);
        }
        catch (NoSuchAlgorithmException | CertificateEncodingException generalSecurityException) {
            throw new NTLMEngineException(generalSecurityException.getMessage(), generalSecurityException);
        }
        System.arraycopy(object, 0, byArray, n2 + 12, 16);
        return byArray;
    }
}

