/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.auth;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.util.Locale;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.hc.client5.http.impl.auth.NTLMEngine;
import org.apache.hc.client5.http.impl.auth.NTLMEngineException;
import org.apache.hc.client5.http.impl.auth.NTLMEngineImpl$HMACMD5;
import org.apache.hc.client5.http.impl.auth.NTLMEngineImpl$MD4;
import org.apache.hc.client5.http.impl.auth.NTLMEngineImpl$NTLMMessage;
import org.apache.hc.client5.http.impl.auth.NTLMEngineImpl$Type1Message;
import org.apache.hc.client5.http.impl.auth.NTLMEngineImpl$Type2Message;
import org.apache.hc.client5.http.impl.auth.NTLMEngineImpl$Type3Message;
import org.apache.hc.client5.http.utils.ByteArrayBuilder;

@Deprecated
final class NTLMEngineImpl
implements NTLMEngine {
    private static final Charset UNICODE_LITTLE_UNMARKED = Charset.forName("UnicodeLittleUnmarked");
    private static final Charset DEFAULT_CHARSET = StandardCharsets.US_ASCII;
    static final int FLAG_REQUEST_UNICODE_ENCODING = 1;
    static final int FLAG_REQUEST_OEM_ENCODING = 2;
    static final int FLAG_REQUEST_TARGET = 4;
    static final int FLAG_REQUEST_SIGN = 16;
    static final int FLAG_REQUEST_SEAL = 32;
    static final int FLAG_REQUEST_LAN_MANAGER_KEY = 128;
    static final int FLAG_REQUEST_NTLMv1 = 512;
    static final int FLAG_DOMAIN_PRESENT = 4096;
    static final int FLAG_WORKSTATION_PRESENT = 8192;
    static final int FLAG_REQUEST_ALWAYS_SIGN = 32768;
    static final int FLAG_REQUEST_NTLM2_SESSION = 524288;
    static final int FLAG_REQUEST_VERSION = 0x2000000;
    static final int FLAG_TARGETINFO_PRESENT = 0x800000;
    static final int FLAG_REQUEST_128BIT_KEY_EXCH = 0x20000000;
    static final int FLAG_REQUEST_EXPLICIT_KEY_EXCH = 0x40000000;
    static final int FLAG_REQUEST_56BIT_ENCRYPTION = Integer.MIN_VALUE;
    static final int MSV_AV_EOL = 0;
    static final int MSV_AV_NB_COMPUTER_NAME = 1;
    static final int MSV_AV_NB_DOMAIN_NAME = 2;
    static final int MSV_AV_DNS_COMPUTER_NAME = 3;
    static final int MSV_AV_DNS_DOMAIN_NAME = 4;
    static final int MSV_AV_DNS_TREE_NAME = 5;
    static final int MSV_AV_FLAGS = 6;
    static final int MSV_AV_TIMESTAMP = 7;
    static final int MSV_AV_SINGLE_HOST = 8;
    static final int MSV_AV_TARGET_NAME = 9;
    static final int MSV_AV_CHANNEL_BINDINGS = 10;
    static final int MSV_AV_FLAGS_ACCOUNT_AUTH_CONSTAINED = 1;
    static final int MSV_AV_FLAGS_MIC = 2;
    static final int MSV_AV_FLAGS_UNTRUSTED_TARGET_SPN = 4;
    private static final SecureRandom RND_GEN;
    private static final byte[] SIGNATURE;
    private static final byte[] SIGN_MAGIC_SERVER;
    private static final byte[] SIGN_MAGIC_CLIENT;
    private static final byte[] SEAL_MAGIC_SERVER;
    private static final byte[] SEAL_MAGIC_CLIENT;
    private static final byte[] MAGIC_TLS_SERVER_ENDPOINT;
    private static final String TYPE_1_MESSAGE;

    private static byte[] getNullTerminatedAsciiString(String object) {
        byte[] byArray = ((String)object).getBytes(StandardCharsets.US_ASCII);
        object = byArray;
        byte[] byArray2 = new byte[byArray.length + 1];
        System.arraycopy(object, 0, byArray2, 0, ((Object)object).length);
        byArray2[((Object)object).length] = 0;
        return byArray2;
    }

    NTLMEngineImpl() {
    }

    static String getResponseFor(String object, String string, char[] cArray, String string2, String string3) throws NTLMEngineException {
        if (object == null || ((String)object).trim().isEmpty()) {
            object = NTLMEngineImpl.getType1Message(string2, string3);
        } else {
            object = new NTLMEngineImpl$Type2Message((String)object);
            object = NTLMEngineImpl.getType3Message(string, cArray, string2, string3, ((NTLMEngineImpl$Type2Message)object).getChallenge(), ((NTLMEngineImpl$Type2Message)object).getFlags(), ((NTLMEngineImpl$Type2Message)object).getTarget(), ((NTLMEngineImpl$Type2Message)object).getTargetInfo());
        }
        return object;
    }

    static String getResponseFor(String object, String string, char[] cArray, String string2, String string3, Certificate certificate) throws NTLMEngineException {
        if (object == null || ((String)object).trim().isEmpty()) {
            object = new NTLMEngineImpl$Type1Message(string2, string3).getResponse();
        } else {
            NTLMEngineImpl$Type1Message nTLMEngineImpl$Type1Message = new NTLMEngineImpl$Type1Message(string2, string3);
            object = new NTLMEngineImpl$Type2Message((String)object);
            object = NTLMEngineImpl.getType3Message(string, cArray, string2, string3, ((NTLMEngineImpl$Type2Message)object).getChallenge(), ((NTLMEngineImpl$Type2Message)object).getFlags(), ((NTLMEngineImpl$Type2Message)object).getTarget(), ((NTLMEngineImpl$Type2Message)object).getTargetInfo(), certificate, nTLMEngineImpl$Type1Message.getBytes(), ((NTLMEngineImpl$NTLMMessage)object).getBytes());
        }
        return object;
    }

    static String getType1Message(String string, String string2) {
        return TYPE_1_MESSAGE;
    }

    static String getType3Message(String string, char[] cArray, String string2, String string3, byte[] byArray, int n2, String string4, byte[] byArray2) throws NTLMEngineException {
        return new NTLMEngineImpl$Type3Message(string3, string2, string, cArray, byArray, n2, string4, byArray2).getResponse();
    }

    static String getType3Message(String string, char[] cArray, String string2, String string3, byte[] byArray, int n2, String string4, byte[] byArray2, Certificate certificate, byte[] byArray3, byte[] byArray4) throws NTLMEngineException {
        return new NTLMEngineImpl$Type3Message(string3, string2, string, cArray, byArray, n2, string4, byArray2, certificate, byArray3, byArray4).getResponse();
    }

    private static int readULong(byte[] byArray, int n2) {
        if (byArray.length < n2 + 4) {
            return 0;
        }
        return byArray[n2] & 0xFF | (byArray[n2 + 1] & 0xFF) << 8 | (byArray[n2 + 2] & 0xFF) << 16 | (byArray[n2 + 3] & 0xFF) << 24;
    }

    private static int readUShort(byte[] byArray, int n2) {
        if (byArray.length < n2 + 2) {
            return 0;
        }
        return byArray[n2] & 0xFF | (byArray[n2 + 1] & 0xFF) << 8;
    }

    private static byte[] readSecurityBuffer(byte[] byArray, int n2) {
        int n3 = NTLMEngineImpl.readUShort(byArray, n2);
        if (byArray.length < (n2 = NTLMEngineImpl.readULong(byArray, n2 + 4)) + n3) {
            return new byte[n3];
        }
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, n2, byArray2, 0, n3);
        return byArray2;
    }

    private static byte[] makeRandomChallenge(Random random) {
        byte[] byArray = new byte[8];
        Random random2 = random;
        synchronized (random2) {
            random.nextBytes(byArray);
        }
        return byArray;
    }

    private static byte[] makeSecondaryKey(Random random) {
        byte[] byArray = new byte[16];
        Random random2 = random;
        synchronized (random2) {
            random.nextBytes(byArray);
        }
        return byArray;
    }

    static byte[] hmacMD5(byte[] byArray, byte[] object) {
        NTLMEngineImpl$HMACMD5 nTLMEngineImpl$HMACMD5 = new NTLMEngineImpl$HMACMD5((byte[])object);
        object = nTLMEngineImpl$HMACMD5;
        nTLMEngineImpl$HMACMD5.update(byArray);
        return ((NTLMEngineImpl$HMACMD5)object).getOutput();
    }

    static byte[] RC4(byte[] byArray, byte[] byArray2) throws NTLMEngineException {
        try {
            Cipher cipher = Cipher.getInstance("RC4");
            cipher.init(1, new SecretKeySpec(byArray2, "RC4"));
            return cipher.doFinal(byArray);
        }
        catch (Exception exception) {
            throw new NTLMEngineException(exception.getMessage(), exception);
        }
    }

    static byte[] ntlm2SessionResponse(byte[] byArray, byte[] byArray2, byte[] byArray3) throws NTLMEngineException {
        try {
            MessageDigest messageDigest = NTLMEngineImpl.getMD5();
            messageDigest.update(byArray2);
            messageDigest.update(byArray3);
            byArray2 = messageDigest.digest();
            byArray3 = new byte[8];
            System.arraycopy(byArray2, 0, byArray3, 0, 8);
            return NTLMEngineImpl.lmResponse(byArray, byArray3);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            if (exception instanceof NTLMEngineException) {
                throw (NTLMEngineException)exception2;
            }
            throw new NTLMEngineException(exception2.getMessage(), exception2);
        }
    }

    private static byte[] lmHash(char[] cArray) throws NTLMEngineException {
        try {
            Object object = new char[cArray.length];
            for (int i2 = 0; i2 < cArray.length; ++i2) {
                object[i2] = Character.toUpperCase(cArray[i2]);
            }
            byte[] byArray = new ByteArrayBuilder().append((char[])object).toByteArray();
            int n2 = Math.min(byArray.length, 14);
            object = new byte[14];
            System.arraycopy(byArray, 0, object, 0, n2);
            Object object2 = NTLMEngineImpl.createDESKey((byte[])object, 0);
            object = NTLMEngineImpl.createDESKey((byte[])object, 7);
            byArray = "KGS!@#$%".getBytes(StandardCharsets.US_ASCII);
            Cipher cipher = Cipher.getInstance("DES/ECB/NoPadding");
            cipher.init(1, (Key)object2);
            object2 = cipher.doFinal(byArray);
            cipher.init(1, (Key)object);
            object = cipher.doFinal(byArray);
            byArray = new byte[16];
            System.arraycopy(object2, 0, byArray, 0, 8);
            System.arraycopy(object, 0, byArray, 8, 8);
            return byArray;
        }
        catch (Exception exception) {
            throw new NTLMEngineException(exception.getMessage(), exception);
        }
    }

    private static byte[] ntlmHash(char[] objectArray) {
        objectArray = new ByteArrayBuilder().charset(UNICODE_LITTLE_UNMARKED).append((char[])objectArray).toByteArray();
        NTLMEngineImpl$MD4 nTLMEngineImpl$MD4 = new NTLMEngineImpl$MD4();
        nTLMEngineImpl$MD4.update((byte[])objectArray);
        return nTLMEngineImpl$MD4.getOutput();
    }

    private static byte[] lmv2Hash(String string, String string2, byte[] object) {
        NTLMEngineImpl$HMACMD5 nTLMEngineImpl$HMACMD5 = new NTLMEngineImpl$HMACMD5((byte[])object);
        object = nTLMEngineImpl$HMACMD5;
        nTLMEngineImpl$HMACMD5.update(string2.toUpperCase(Locale.ROOT).getBytes(UNICODE_LITTLE_UNMARKED));
        if (string != null) {
            ((NTLMEngineImpl$HMACMD5)object).update(string.toUpperCase(Locale.ROOT).getBytes(UNICODE_LITTLE_UNMARKED));
        }
        return ((NTLMEngineImpl$HMACMD5)object).getOutput();
    }

    private static byte[] ntlmv2Hash(String string, String string2, byte[] object) {
        NTLMEngineImpl$HMACMD5 nTLMEngineImpl$HMACMD5 = new NTLMEngineImpl$HMACMD5((byte[])object);
        object = nTLMEngineImpl$HMACMD5;
        nTLMEngineImpl$HMACMD5.update(string2.toUpperCase(Locale.ROOT).getBytes(UNICODE_LITTLE_UNMARKED));
        if (string != null) {
            ((NTLMEngineImpl$HMACMD5)object).update(string.getBytes(UNICODE_LITTLE_UNMARKED));
        }
        return ((NTLMEngineImpl$HMACMD5)object).getOutput();
    }

    private static byte[] lmResponse(byte[] object, byte[] byArray) throws NTLMEngineException {
        try {
            Object object2 = new byte[21];
            System.arraycopy(object, 0, object2, 0, 16);
            object = NTLMEngineImpl.createDESKey(object2, 0);
            Object object3 = NTLMEngineImpl.createDESKey(object2, 7);
            object2 = NTLMEngineImpl.createDESKey(object2, 14);
            Cipher cipher = Cipher.getInstance("DES/ECB/NoPadding");
            cipher.init(1, (Key)object);
            object = cipher.doFinal(byArray);
            cipher.init(1, (Key)object3);
            object3 = cipher.doFinal(byArray);
            cipher.init(1, (Key)object2);
            byArray = cipher.doFinal(byArray);
            object2 = new byte[24];
            System.arraycopy(object, 0, object2, 0, 8);
            System.arraycopy(object3, 0, object2, 8, 8);
            System.arraycopy(byArray, 0, object2, 16, 8);
            return object2;
        }
        catch (Exception exception) {
            throw new NTLMEngineException(exception.getMessage(), exception);
        }
    }

    private static byte[] lmv2Response(byte[] object, byte[] byArray, byte[] byArray2) {
        NTLMEngineImpl$HMACMD5 nTLMEngineImpl$HMACMD5 = new NTLMEngineImpl$HMACMD5((byte[])object);
        object = nTLMEngineImpl$HMACMD5;
        nTLMEngineImpl$HMACMD5.update(byArray);
        object.update(byArray2);
        byte[] byArray3 = object.getOutput();
        object = byArray3;
        byArray = new byte[byArray3.length + byArray2.length];
        System.arraycopy(object, 0, byArray, 0, ((byte[])object).length);
        System.arraycopy(byArray2, 0, byArray, ((byte[])object).length, byArray2.length);
        return byArray;
    }

    private static byte[] encodeLong(int n2) {
        byte[] byArray = new byte[4];
        NTLMEngineImpl.encodeLong(byArray, 0, n2);
        return byArray;
    }

    private static void encodeLong(byte[] byArray, int n2, int n3) {
        byArray[n2] = (byte)n3;
        byArray[n2 + 1] = (byte)(n3 >> 8);
        byArray[n2 + 2] = (byte)(n3 >> 16);
        byArray[n2 + 3] = (byte)(n3 >>> 24);
    }

    private static byte[] createBlob(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        byte[] byArray4 = new byte[]{1, 1, 0, 0};
        byte[] byArray5 = new byte[]{0, 0, 0, 0};
        byte[] byArray6 = new byte[]{0, 0, 0, 0};
        byte[] byArray7 = new byte[]{0, 0, 0, 0};
        int cfr_ignored_0 = byArray4.length;
        int cfr_ignored_1 = byArray5.length;
        byte[] byArray8 = new byte[8 + byArray3.length + 8 + byArray6.length + byArray2.length + byArray7.length];
        System.arraycopy(byArray4, 0, byArray8, 0, byArray4.length);
        int cfr_ignored_2 = byArray4.length;
        System.arraycopy(byArray5, 0, byArray8, 4, byArray5.length);
        int cfr_ignored_3 = byArray5.length;
        System.arraycopy(byArray3, 0, byArray8, 8, byArray3.length);
        int n2 = 8 + byArray3.length;
        System.arraycopy(byArray, 0, byArray8, n2, 8);
        System.arraycopy(byArray6, 0, byArray8, n2 += 8, byArray6.length);
        System.arraycopy(byArray2, 0, byArray8, n2 += byArray6.length, byArray2.length);
        System.arraycopy(byArray7, 0, byArray8, n2 += byArray2.length, byArray7.length);
        int cfr_ignored_4 = byArray7.length;
        return byArray8;
    }

    private static Key createDESKey(byte[] byArray, int n2) {
        byte[] byArray2 = new byte[7];
        System.arraycopy(byArray, n2, byArray2, 0, 7);
        byte[] byArray3 = new byte[8];
        byArray = byArray3;
        byArray3[0] = byArray2[0];
        byArray[1] = (byte)(byArray2[0] << 7 | (byArray2[1] & 0xFF) >>> 1);
        byArray[2] = (byte)(byArray2[1] << 6 | (byArray2[2] & 0xFF) >>> 2);
        byArray[3] = (byte)(byArray2[2] << 5 | (byArray2[3] & 0xFF) >>> 3);
        byArray[4] = (byte)(byArray2[3] << 4 | (byArray2[4] & 0xFF) >>> 4);
        byArray[5] = (byte)(byArray2[4] << 3 | (byArray2[5] & 0xFF) >>> 5);
        byArray[6] = (byte)(byArray2[5] << 2 | (byArray2[6] & 0xFF) >>> 6);
        byArray[7] = (byte)(byArray2[6] << 1);
        NTLMEngineImpl.oddParity(byArray);
        return new SecretKeySpec(byArray, "DES");
    }

    private static void oddParity(byte[] byArray) {
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byte by2 = byArray[i2];
            if ((by2 = ((by2 >>> 7 ^ by2 >>> 6 ^ by2 >>> 5 ^ by2 >>> 4 ^ by2 >>> 3 ^ by2 >>> 2 ^ by2 >>> 1) & 1) == 0 ? (byte)1 : 0) != 0) {
                int n2 = i2;
                byArray[n2] = (byte)(byArray[n2] | 1);
                continue;
            }
            int n3 = i2;
            byArray[n3] = (byte)(byArray[n3] & 0xFFFFFFFE);
        }
    }

    private static Charset getCharset(int n2) {
        if ((n2 & 1) == 0) {
            return DEFAULT_CHARSET;
        }
        return UNICODE_LITTLE_UNMARKED;
    }

    static void writeUShort(byte[] byArray, int n2, int n3) {
        byArray[n3] = (byte)n2;
        byArray[n3 + 1] = (byte)(n2 >> 8);
    }

    static void writeULong(byte[] byArray, int n2, int n3) {
        byArray[n3] = (byte)n2;
        byArray[n3 + 1] = (byte)(n2 >> 8);
        byArray[n3 + 2] = (byte)(n2 >> 16);
        byArray[n3 + 3] = (byte)(n2 >>> 24);
    }

    static int F(int n2, int n3, int n4) {
        return n2 & n3 | ~n2 & n4;
    }

    static int G(int n2, int n3, int n4) {
        return n2 & n3 | n2 & n4 | n3 & n4;
    }

    static int H(int n2, int n3, int n4) {
        return n2 ^ n3 ^ n4;
    }

    static int rotintlft(int n2, int n3) {
        return n2 << n3 | n2 >>> 32 - n3;
    }

    static MessageDigest getMD5() {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException("MD5 message digest doesn't seem to exist - fatal error: " + noSuchAlgorithmException.getMessage(), noSuchAlgorithmException);
        }
    }

    @Override
    public final String generateType1Msg(String string, String string2) throws NTLMEngineException {
        return NTLMEngineImpl.getType1Message(string2, string);
    }

    @Override
    public final String generateType3Msg(String string, char[] cArray, String string2, String string3, String object) throws NTLMEngineException {
        object = new NTLMEngineImpl$Type2Message((String)object);
        return NTLMEngineImpl.getType3Message(string, cArray, string3, string2, ((NTLMEngineImpl$Type2Message)object).getChallenge(), ((NTLMEngineImpl$Type2Message)object).getFlags(), ((NTLMEngineImpl$Type2Message)object).getTarget(), ((NTLMEngineImpl$Type2Message)object).getTargetInfo());
    }

    static /* synthetic */ byte[] access$000(Random random) {
        return NTLMEngineImpl.makeRandomChallenge(random);
    }

    static /* synthetic */ byte[] access$100(Random random) {
        return NTLMEngineImpl.makeSecondaryKey(random);
    }

    static /* synthetic */ byte[] access$200(char[] cArray) throws NTLMEngineException {
        return NTLMEngineImpl.lmHash(cArray);
    }

    static /* synthetic */ byte[] access$300(byte[] byArray, byte[] byArray2) throws NTLMEngineException {
        return NTLMEngineImpl.lmResponse(byArray, byArray2);
    }

    static /* synthetic */ byte[] access$400(char[] cArray) {
        return NTLMEngineImpl.ntlmHash(cArray);
    }

    static /* synthetic */ byte[] access$500(String string, String string2, byte[] byArray) {
        return NTLMEngineImpl.lmv2Hash(string, string2, byArray);
    }

    static /* synthetic */ byte[] access$600(String string, String string2, byte[] byArray) {
        return NTLMEngineImpl.ntlmv2Hash(string, string2, byArray);
    }

    static /* synthetic */ byte[] access$700(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        return NTLMEngineImpl.createBlob(byArray, byArray2, byArray3);
    }

    static /* synthetic */ byte[] access$800(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        return NTLMEngineImpl.lmv2Response(byArray, byArray2, byArray3);
    }

    static /* synthetic */ Key access$900(byte[] byArray, int n2) {
        return NTLMEngineImpl.createDESKey(byArray, n2);
    }

    static /* synthetic */ byte[] access$1000() {
        return SIGN_MAGIC_CLIENT;
    }

    static /* synthetic */ byte[] access$1100() {
        return SEAL_MAGIC_CLIENT;
    }

    static /* synthetic */ byte[] access$1200() {
        return SIGN_MAGIC_SERVER;
    }

    static /* synthetic */ byte[] access$1300() {
        return SEAL_MAGIC_SERVER;
    }

    static /* synthetic */ byte[] access$1400(int n2) {
        return NTLMEngineImpl.encodeLong(n2);
    }

    static /* synthetic */ void access$1500(byte[] byArray, int n2, int n3) {
        NTLMEngineImpl.encodeLong(byArray, n2, n3);
    }

    static /* synthetic */ Charset access$1600() {
        return DEFAULT_CHARSET;
    }

    static /* synthetic */ byte[] access$1700() {
        return SIGNATURE;
    }

    static /* synthetic */ int access$1800(byte[] byArray, int n2) {
        return NTLMEngineImpl.readUShort(byArray, n2);
    }

    static /* synthetic */ int access$1900(byte[] byArray, int n2) {
        return NTLMEngineImpl.readULong(byArray, n2);
    }

    static /* synthetic */ byte[] access$2000(byte[] byArray, int n2) {
        return NTLMEngineImpl.readSecurityBuffer(byArray, n2);
    }

    static /* synthetic */ Charset access$2100() {
        return UNICODE_LITTLE_UNMARKED;
    }

    static /* synthetic */ Charset access$2200(int n2) {
        return NTLMEngineImpl.getCharset(n2);
    }

    static /* synthetic */ SecureRandom access$2300() {
        return RND_GEN;
    }

    static /* synthetic */ byte[] access$2400() {
        return MAGIC_TLS_SERVER_ENDPOINT;
    }

    static {
        SecureRandom secureRandom = null;
        try {
            secureRandom = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (Exception exception) {}
        RND_GEN = secureRandom;
        SIGNATURE = NTLMEngineImpl.getNullTerminatedAsciiString("NTLMSSP");
        SIGN_MAGIC_SERVER = NTLMEngineImpl.getNullTerminatedAsciiString("session key to server-to-client signing key magic constant");
        SIGN_MAGIC_CLIENT = NTLMEngineImpl.getNullTerminatedAsciiString("session key to client-to-server signing key magic constant");
        SEAL_MAGIC_SERVER = NTLMEngineImpl.getNullTerminatedAsciiString("session key to server-to-client sealing key magic constant");
        SEAL_MAGIC_CLIENT = NTLMEngineImpl.getNullTerminatedAsciiString("session key to client-to-server sealing key magic constant");
        MAGIC_TLS_SERVER_ENDPOINT = "tls-server-end-point:".getBytes(StandardCharsets.US_ASCII);
        TYPE_1_MESSAGE = new NTLMEngineImpl$Type1Message().getResponse();
    }
}

