/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.classic;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.classic.BackoffManager;
import org.apache.hc.core5.pool.ConnPoolControl;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.TimeValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBackoff
implements BackoffManager {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractBackoff.class);
    private final ConnPoolControl<HttpRoute> connPerRoute;
    private final Map<HttpRoute, Instant> lastRouteProbes;
    private final Map<HttpRoute, Instant> lastRouteBackoffs;
    private final AtomicReference<TimeValue> coolDown = new AtomicReference<TimeValue>(TimeValue.ofSeconds(5L));
    private final AtomicReference<Double> backoffFactor = new AtomicReference<Double>(0.5);
    private final AtomicInteger cap = new AtomicInteger(2);
    private final AtomicInteger timeInterval = new AtomicInteger(0);

    public AbstractBackoff(ConnPoolControl<HttpRoute> connPoolControl) {
        this.connPerRoute = Args.notNull(connPoolControl, "Connection pool control");
        this.lastRouteProbes = new ConcurrentHashMap<HttpRoute, Instant>();
        this.lastRouteBackoffs = new ConcurrentHashMap<HttpRoute, Instant>();
    }

    @Override
    public void backOff(HttpRoute httpRoute) {
        int n2 = this.connPerRoute.getMaxPerRoute(httpRoute);
        Instant instant = Instant.now();
        this.lastRouteBackoffs.compute(httpRoute, (httpRoute2, instant2) -> {
            if (instant2 == null || instant.isAfter(instant2.plus(this.coolDown.get().toMilliseconds(), ChronoUnit.MILLIS))) {
                n2 = this.getBackedOffPoolSize(n2);
                this.connPerRoute.setMaxPerRoute(httpRoute, n2);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Backoff applied for route: {}, new max connections: {}", (Object)httpRoute, (Object)this.connPerRoute.getMaxPerRoute(httpRoute));
                }
                return instant;
            }
            return instant2;
        });
    }

    protected abstract int getBackedOffPoolSize(int var1);

    @Override
    public void probe(HttpRoute httpRoute) {
        int n2 = this.connPerRoute.getMaxPerRoute(httpRoute);
        n2 = n2 >= this.cap.get() ? this.cap.get() : n2 + 1;
        Instant instant = Instant.now();
        this.lastRouteProbes.compute(httpRoute, (object, instant2) -> {
            if ((instant2 == null || instant.isAfter(instant2.plus(this.coolDown.get().toMilliseconds(), ChronoUnit.MILLIS))) && ((object = this.lastRouteBackoffs.get(object)) == null || instant.isAfter(((Instant)object).plus(this.coolDown.get().toMilliseconds(), ChronoUnit.MILLIS)))) {
                this.connPerRoute.setMaxPerRoute(httpRoute, n2);
                if (LOG.isDebugEnabled()) {
                    LOG.info("Probe applied for route: {}, new max connections: {}", (Object)httpRoute, (Object)this.connPerRoute.getMaxPerRoute(httpRoute));
                }
                this.timeInterval.set(0);
                return instant;
            }
            return instant2;
        });
    }

    public long getLastUpdate(Map<HttpRoute, Long> map, HttpRoute httpRoute) {
        return map.getOrDefault(httpRoute, 0L);
    }

    public void setPerHostConnectionCap(int n2) {
        Args.positive(n2, "Per host connection cap");
        this.cap.set(n2);
    }

    abstract void setBackoffFactor(double var1);

    public void setCoolDown(TimeValue timeValue) {
        Args.notNull(timeValue, "Cool down time value cannot be null");
        Args.positive(timeValue.getDuration(), "coolDown");
        this.coolDown.set(timeValue);
    }

    protected ConnPoolControl<HttpRoute> getConnPerRoute() {
        return this.connPerRoute;
    }

    protected Map<HttpRoute, Instant> getLastRouteProbes() {
        return this.lastRouteProbes;
    }

    protected Map<HttpRoute, Instant> getLastRouteBackoffs() {
        return this.lastRouteBackoffs;
    }

    protected AtomicReference<TimeValue> getCoolDown() {
        return this.coolDown;
    }

    protected AtomicReference<Double> getBackoffFactor() {
        return this.backoffFactor;
    }

    protected AtomicInteger getCap() {
        return this.cap;
    }

    protected AtomicInteger getTimeInterval() {
        return this.timeInterval;
    }
}

