/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.classic;

import java.io.IOException;
import org.apache.hc.client5.http.HttpResponseException;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.io.entity.EntityUtils;

@Contract(threading=ThreadingBehavior.STATELESS)
public abstract class AbstractHttpClientResponseHandler<T>
implements HttpClientResponseHandler<T> {
    @Override
    public T handleResponse(ClassicHttpResponse classicHttpResponse) throws IOException {
        HttpEntity httpEntity = classicHttpResponse.getEntity();
        if (classicHttpResponse.getCode() >= 300) {
            EntityUtils.consume(httpEntity);
            throw new HttpResponseException(classicHttpResponse.getCode(), classicHttpResponse.getReasonPhrase());
        }
        if (httpEntity == null) {
            return null;
        }
        return this.handleEntity(httpEntity);
    }

    public abstract T handleEntity(HttpEntity var1) throws IOException;
}

