/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.classic;

import java.io.IOException;
import org.apache.hc.client5.http.ClientProtocolException;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.routing.RoutingSupport;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.io.ModalCloseable;
import org.apache.hc.core5.util.Args;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Contract(threading=ThreadingBehavior.SAFE)
public abstract class CloseableHttpClient
implements HttpClient,
ModalCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(CloseableHttpClient.class);

    protected abstract CloseableHttpResponse doExecute(HttpHost var1, ClassicHttpRequest var2, HttpContext var3) throws IOException;

    private static HttpHost determineTarget(ClassicHttpRequest classicHttpRequest) throws ClientProtocolException {
        try {
            return RoutingSupport.determineHost(classicHttpRequest);
        }
        catch (HttpException httpException) {
            throw new ClientProtocolException(httpException);
        }
    }

    @Override
    @Deprecated
    public CloseableHttpResponse execute(HttpHost httpHost, ClassicHttpRequest classicHttpRequest, HttpContext httpContext) throws IOException {
        return this.doExecute(httpHost, classicHttpRequest, httpContext);
    }

    @Override
    @Deprecated
    public CloseableHttpResponse execute(ClassicHttpRequest classicHttpRequest, HttpContext httpContext) throws IOException {
        Args.notNull(classicHttpRequest, "HTTP request");
        return this.doExecute(CloseableHttpClient.determineTarget(classicHttpRequest), classicHttpRequest, httpContext);
    }

    @Override
    @Deprecated
    public CloseableHttpResponse execute(ClassicHttpRequest classicHttpRequest) throws IOException {
        return this.doExecute(CloseableHttpClient.determineTarget(classicHttpRequest), classicHttpRequest, null);
    }

    @Override
    @Deprecated
    public CloseableHttpResponse execute(HttpHost httpHost, ClassicHttpRequest classicHttpRequest) throws IOException {
        return this.doExecute(httpHost, classicHttpRequest, null);
    }

    @Override
    public <T> T execute(ClassicHttpRequest classicHttpRequest, HttpClientResponseHandler<? extends T> httpClientResponseHandler) throws IOException {
        return this.execute(classicHttpRequest, null, httpClientResponseHandler);
    }

    @Override
    public <T> T execute(ClassicHttpRequest classicHttpRequest, HttpContext httpContext, HttpClientResponseHandler<? extends T> httpClientResponseHandler) throws IOException {
        HttpHost httpHost = CloseableHttpClient.determineTarget(classicHttpRequest);
        return this.execute(httpHost, classicHttpRequest, httpContext, httpClientResponseHandler);
    }

    @Override
    public <T> T execute(HttpHost httpHost, ClassicHttpRequest classicHttpRequest, HttpClientResponseHandler<? extends T> httpClientResponseHandler) throws IOException {
        return this.execute(httpHost, classicHttpRequest, null, httpClientResponseHandler);
    }

    @Override
    public <T> T execute(HttpHost object, ClassicHttpRequest object2, HttpContext object3, HttpClientResponseHandler<? extends T> object4) throws IOException {
        block13: {
            Args.notNull(object4, "Response handler");
            object = this.doExecute((HttpHost)object, (ClassicHttpRequest)object2, (HttpContext)object3);
            object2 = null;
            try {
                object3 = object4.handleResponse((ClassicHttpResponse)object);
                object4 = object.getEntity();
                EntityUtils.consume((HttpEntity)object4);
                object4 = object3;
                if (object == null) break block13;
            }
            catch (HttpException httpException) {
                try {
                    try {
                        object4 = object.getEntity();
                        try {
                            EntityUtils.consume((HttpEntity)object4);
                        }
                        catch (Exception exception) {
                            LOG.warn("Error consuming content after an exception.", exception);
                        }
                        throw new ClientProtocolException(httpException);
                    }
                    catch (Throwable throwable) {
                        object3 = throwable;
                        object2 = throwable;
                        throw object3;
                    }
                }
                catch (Throwable throwable) {
                    if (object != null) {
                        if (object2 != null) {
                            try {
                                object.close();
                            }
                            catch (Throwable throwable2) {
                                ((Throwable)object2).addSuppressed(throwable2);
                            }
                        } else {
                            object.close();
                        }
                    }
                    throw throwable;
                }
            }
            object.close();
        }
        return (T)object4;
    }
}

