/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.classic;

import java.io.IOException;
import java.util.Iterator;
import java.util.Locale;
import org.apache.hc.client5.http.classic.ExecRuntime;
import org.apache.hc.client5.http.impl.classic.CloseableDelegate;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.io.ModalCloseable;
import org.apache.hc.core5.util.Args;

public final class CloseableHttpResponse
implements ClassicHttpResponse,
ModalCloseable {
    private final ClassicHttpResponse response;
    private final CloseableDelegate closeableDelegate;

    @Internal
    public static CloseableHttpResponse adapt(ClassicHttpResponse classicHttpResponse) {
        if (classicHttpResponse == null) {
            return null;
        }
        if (classicHttpResponse instanceof CloseableHttpResponse) {
            return (CloseableHttpResponse)classicHttpResponse;
        }
        return new CloseableHttpResponse(classicHttpResponse);
    }

    @Internal
    public static CloseableHttpResponse create(ClassicHttpResponse classicHttpResponse, CloseableDelegate closeableDelegate) {
        if (classicHttpResponse == null) {
            return null;
        }
        return new CloseableHttpResponse(classicHttpResponse, closeableDelegate);
    }

    CloseableHttpResponse(ClassicHttpResponse classicHttpResponse) {
        this.response = Args.notNull(classicHttpResponse, "Response");
        this.closeableDelegate = null;
    }

    CloseableHttpResponse(ClassicHttpResponse classicHttpResponse, CloseableDelegate closeableDelegate) {
        this.response = Args.notNull(classicHttpResponse, "Response");
        this.closeableDelegate = closeableDelegate;
    }

    CloseableHttpResponse(ClassicHttpResponse classicHttpResponse, ExecRuntime execRuntime) {
        this.response = Args.notNull(classicHttpResponse, "Response");
        this.closeableDelegate = (closeable, closeMode) -> {
            try {
                if (closeMode == CloseMode.GRACEFUL) {
                    classicHttpResponse.close();
                }
                execRuntime.disconnectEndpoint();
                return;
            }
            finally {
                execRuntime.discardEndpoint();
            }
        };
    }

    @Override
    public final int getCode() {
        return this.response.getCode();
    }

    @Override
    public final HttpEntity getEntity() {
        return this.response.getEntity();
    }

    @Override
    public final boolean containsHeader(String string) {
        return this.response.containsHeader(string);
    }

    @Override
    public final void setVersion(ProtocolVersion protocolVersion) {
        this.response.setVersion(protocolVersion);
    }

    @Override
    public final void setCode(int n2) {
        this.response.setCode(n2);
    }

    @Override
    public final String getReasonPhrase() {
        return this.response.getReasonPhrase();
    }

    @Override
    public final int countHeaders(String string) {
        return this.response.countHeaders(string);
    }

    @Override
    public final void setEntity(HttpEntity httpEntity) {
        this.response.setEntity(httpEntity);
    }

    @Override
    public final ProtocolVersion getVersion() {
        return this.response.getVersion();
    }

    @Override
    public final void setReasonPhrase(String string) {
        this.response.setReasonPhrase(string);
    }

    @Override
    public final Header[] getHeaders(String string) {
        return this.response.getHeaders(string);
    }

    @Override
    public final void addHeader(Header header) {
        this.response.addHeader(header);
    }

    @Override
    public final Locale getLocale() {
        return this.response.getLocale();
    }

    @Override
    public final void addHeader(String string, Object object) {
        this.response.addHeader(string, object);
    }

    @Override
    public final void setLocale(Locale locale) {
        this.response.setLocale(locale);
    }

    @Override
    public final Header getHeader(String string) throws ProtocolException {
        return this.response.getHeader(string);
    }

    @Override
    public final void setHeader(Header header) {
        this.response.setHeader(header);
    }

    @Override
    public final Header getFirstHeader(String string) {
        return this.response.getFirstHeader(string);
    }

    @Override
    public final void setHeader(String string, Object object) {
        this.response.setHeader(string, object);
    }

    @Override
    public final void setHeaders(Header ... headerArray) {
        this.response.setHeaders(headerArray);
    }

    @Override
    public final boolean removeHeader(Header header) {
        return this.response.removeHeader(header);
    }

    @Override
    public final boolean removeHeaders(String string) {
        return this.response.removeHeaders(string);
    }

    @Override
    public final Header getLastHeader(String string) {
        return this.response.getLastHeader(string);
    }

    @Override
    public final Header[] getHeaders() {
        return this.response.getHeaders();
    }

    @Override
    public final Iterator<Header> headerIterator() {
        return this.response.headerIterator();
    }

    @Override
    public final Iterator<Header> headerIterator(String string) {
        return this.response.headerIterator(string);
    }

    private void doClose(CloseMode closeMode) throws IOException {
        if (this.closeableDelegate != null) {
            this.closeableDelegate.close(this.response, closeMode);
            return;
        }
        this.response.close();
    }

    @Override
    public final void close(CloseMode closeMode) {
        try {
            this.doClose(closeMode);
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    @Override
    public final void close() throws IOException {
        this.doClose(CloseMode.GRACEFUL);
    }

    public final String toString() {
        return this.response.toString();
    }
}

