/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.classic;

import java.io.IOException;
import java.io.Serializable;
import org.apache.hc.client5.http.AuthenticationStrategy;
import org.apache.hc.client5.http.EndpointInfo;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.RouteInfo;
import org.apache.hc.client5.http.RouteTracker;
import org.apache.hc.client5.http.SchemePortResolver;
import org.apache.hc.client5.http.auth.AuthExchange;
import org.apache.hc.client5.http.auth.ChallengeType;
import org.apache.hc.client5.http.classic.ExecChain;
import org.apache.hc.client5.http.classic.ExecChain$Scope;
import org.apache.hc.client5.http.classic.ExecChainHandler;
import org.apache.hc.client5.http.classic.ExecRuntime;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.auth.AuthCacheKeeper;
import org.apache.hc.client5.http.impl.auth.AuthenticationHandler;
import org.apache.hc.client5.http.impl.routing.BasicRouteDirector;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.routing.HttpRouteDirector;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ConnectionReuseStrategy;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.Method;
import org.apache.hc.core5.http.io.entity.ByteArrayEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.message.BasicClassicHttpRequest;
import org.apache.hc.core5.http.message.StatusLine;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.protocol.HttpProcessor;
import org.apache.hc.core5.util.Args;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Contract(threading=ThreadingBehavior.STATELESS)
@Internal
public final class ConnectExec
implements ExecChainHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ConnectExec.class);
    private final ConnectionReuseStrategy reuseStrategy;
    private final HttpProcessor proxyHttpProcessor;
    private final AuthenticationStrategy proxyAuthStrategy;
    private final AuthenticationHandler authenticator;
    private final AuthCacheKeeper authCacheKeeper;
    private final HttpRouteDirector routeDirector;

    public ConnectExec(ConnectionReuseStrategy connectionReuseStrategy, HttpProcessor httpProcessor, AuthenticationStrategy authenticationStrategy, SchemePortResolver schemePortResolver, boolean bl2) {
        Args.notNull(connectionReuseStrategy, "Connection reuse strategy");
        Args.notNull(httpProcessor, "Proxy HTTP processor");
        Args.notNull(authenticationStrategy, "Proxy authentication strategy");
        this.reuseStrategy = connectionReuseStrategy;
        this.proxyHttpProcessor = httpProcessor;
        this.proxyAuthStrategy = authenticationStrategy;
        this.authenticator = new AuthenticationHandler();
        this.authCacheKeeper = bl2 ? null : new AuthCacheKeeper(schemePortResolver);
        this.routeDirector = BasicRouteDirector.INSTANCE;
    }

    @Override
    public final ClassicHttpResponse execute(ClassicHttpRequest classicHttpRequest, ExecChain$Scope execChain$Scope, ExecChain execChain) throws IOException, HttpException {
        Object object;
        Args.notNull(classicHttpRequest, "HTTP request");
        Args.notNull(execChain$Scope, "Scope");
        String string = execChain$Scope.exchangeId;
        HttpRoute httpRoute = execChain$Scope.route;
        HttpClientContext httpClientContext = execChain$Scope.clientContext;
        ExecRuntime execRuntime = execChain$Scope.execRuntime;
        if (!execRuntime.isEndpointAcquired()) {
            object = httpClientContext.getUserToken();
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} acquiring connection with route {}", (Object)string, (Object)httpRoute);
            }
            execRuntime.acquireEndpoint(string, httpRoute, object, httpClientContext);
        }
        try {
            if (!execRuntime.isEndpointConnected()) {
                int n2;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} opening connection {}", (Object)string, (Object)httpRoute);
                }
                object = new RouteTracker(httpRoute);
                do {
                    Object object2 = ((RouteTracker)object).toRoute();
                    n2 = this.routeDirector.nextStep(httpRoute, (RouteInfo)object2);
                    switch (n2) {
                        case 1: {
                            execRuntime.connectEndpoint(httpClientContext);
                            ((RouteTracker)object).connectTarget(httpRoute.isSecure());
                            break;
                        }
                        case 2: {
                            execRuntime.connectEndpoint(httpClientContext);
                            object2 = httpRoute.getProxyHost();
                            ((RouteTracker)object).connectProxy((HttpHost)object2, httpRoute.isSecure() && !httpRoute.isTunnelled());
                            break;
                        }
                        case 3: {
                            object2 = this.createTunnelToTarget(string, httpRoute, classicHttpRequest, execRuntime, httpClientContext);
                            if (object2 != null) {
                                return object2;
                            }
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("{} tunnel to target created.", (Object)string);
                            }
                            ((RouteTracker)object).tunnelTarget(false);
                            break;
                        }
                        case 4: {
                            int n3 = ((HttpRoute)object2).getHopCount() - 1;
                            boolean bl2 = this.createTunnelToProxy(httpRoute, n3, httpClientContext);
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("{} tunnel to proxy created.", (Object)string);
                            }
                            ((RouteTracker)object).tunnelProxy(httpRoute.getHopTarget(n3), bl2);
                            break;
                        }
                        case 5: {
                            execRuntime.upgradeTls(httpClientContext);
                            ((RouteTracker)object).layerProtocol(httpRoute.isSecure());
                            break;
                        }
                        case -1: {
                            throw new HttpException("Unable to establish route: planned = " + httpRoute + "; current = " + object2);
                        }
                        case 0: {
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unknown step indicator " + n2 + " from RouteDirector.");
                        }
                    }
                } while (n2 > 0);
            }
            if ((object = execRuntime.getEndpointInfo()) != null) {
                httpClientContext.setSSLSession(((EndpointInfo)object).getSslSession());
            }
            return execChain.proceed(classicHttpRequest, execChain$Scope);
        }
        catch (IOException | RuntimeException | HttpException exception) {
            execRuntime.discardEndpoint();
            throw exception;
        }
    }

    private ClassicHttpResponse createTunnelToTarget(String string, HttpRoute object, HttpRequest object2, ExecRuntime execRuntime, HttpClientContext httpClientContext) throws HttpException, IOException {
        object2 = httpClientContext.getRequestConfigOrDefault();
        Serializable serializable = ((HttpRoute)object).getTargetHost();
        object = ((HttpRoute)object).getProxyHost();
        AuthExchange authExchange = httpClientContext.getAuthExchange((HttpHost)object);
        if (this.authCacheKeeper != null) {
            this.authCacheKeeper.loadPreemptively((HttpHost)object, null, authExchange, httpClientContext);
        }
        Object object3 = null;
        String string2 = ((HttpHost)serializable).toHostString();
        serializable = new BasicClassicHttpRequest(Method.CONNECT, (HttpHost)serializable, string2);
        serializable.setVersion(HttpVersion.HTTP_1_1);
        this.proxyHttpProcessor.process((HttpRequest)((Object)serializable), null, (HttpContext)httpClientContext);
        while (object3 == null) {
            serializable.removeHeaders("Proxy-Authorization");
            this.authenticator.addAuthResponse((HttpHost)object, ChallengeType.PROXY, (HttpRequest)((Object)serializable), authExchange, httpClientContext);
            object3 = execRuntime.execute(string, (ClassicHttpRequest)((Object)serializable), httpClientContext);
            HttpResponse httpResponse = object3;
            this.proxyHttpProcessor.process(httpResponse, (EntityDetails)httpResponse.getEntity(), (HttpContext)httpClientContext);
            int n2 = object3.getCode();
            if (n2 < 200) {
                throw new HttpException("Unexpected response to CONNECT request: " + new StatusLine((HttpResponse)object3));
            }
            if (!((RequestConfig)object2).isAuthenticationEnabled()) continue;
            n2 = this.authenticator.isChallenged((HttpHost)object, ChallengeType.PROXY, (HttpResponse)object3, authExchange, httpClientContext) ? 1 : 0;
            boolean bl2 = this.authenticator.isChallengeExpected(authExchange);
            if (this.authCacheKeeper != null) {
                if (n2 != 0) {
                    this.authCacheKeeper.updateOnChallenge((HttpHost)object, null, authExchange, httpClientContext);
                } else {
                    this.authCacheKeeper.updateOnNoChallenge((HttpHost)object, null, authExchange, httpClientContext);
                }
            }
            if (n2 == 0 && !bl2) continue;
            n2 = this.authenticator.handleResponse((HttpHost)object, ChallengeType.PROXY, (HttpResponse)object3, this.proxyAuthStrategy, authExchange, httpClientContext) ? 1 : 0;
            if (this.authCacheKeeper != null) {
                this.authCacheKeeper.updateOnResponse((HttpHost)object, null, authExchange, httpClientContext);
            }
            if (n2 == 0) continue;
            if (this.reuseStrategy.keepAlive((HttpRequest)((Object)serializable), (HttpResponse)object3, httpClientContext)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} connection kept alive", (Object)string);
                }
                object3 = object3.getEntity();
                EntityUtils.consume((HttpEntity)object3);
            } else {
                execRuntime.disconnectEndpoint();
            }
            object3 = null;
        }
        int n3 = object3.getCode();
        if (n3 != 200) {
            HttpEntity httpEntity = object3.getEntity();
            if (httpEntity != null) {
                object3.setEntity(new ByteArrayEntity(EntityUtils.toByteArray(httpEntity, 4096), ContentType.parseLenient(httpEntity.getContentType())));
                execRuntime.discardEndpoint();
            }
            return object3;
        }
        httpClientContext.setProtocolVersion(null);
        return null;
    }

    private boolean createTunnelToProxy(HttpRoute httpRoute, int n2, HttpClientContext httpClientContext) throws HttpException {
        throw new HttpException("Proxy chains are not supported.");
    }
}

