/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.classic;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.impl.classic.FutureRequestExecutionMetrics;
import org.apache.hc.client5.http.impl.classic.HttpRequestFutureTask;
import org.apache.hc.client5.http.impl.classic.HttpRequestTaskCallable;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.protocol.HttpContext;

@Contract(threading=ThreadingBehavior.SAFE_CONDITIONAL)
public class FutureRequestExecutionService
implements Closeable {
    private final HttpClient httpclient;
    private final ExecutorService executorService;
    private final FutureRequestExecutionMetrics metrics = new FutureRequestExecutionMetrics();
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public FutureRequestExecutionService(HttpClient httpClient, ExecutorService executorService) {
        this.httpclient = httpClient;
        this.executorService = executorService;
    }

    public <T> FutureTask<T> execute(ClassicHttpRequest classicHttpRequest, HttpContext httpContext, HttpClientResponseHandler<T> httpClientResponseHandler) {
        return this.execute(classicHttpRequest, httpContext, httpClientResponseHandler, null);
    }

    public <T> FutureTask<T> execute(ClassicHttpRequest object, HttpContext object2, HttpClientResponseHandler<T> httpClientResponseHandler, FutureCallback<T> futureCallback) {
        if (this.closed.get()) {
            throw new IllegalStateException("Close has been called on this httpclient instance.");
        }
        this.metrics.getScheduledConnections().incrementAndGet();
        object2 = new HttpRequestTaskCallable<T>(this.httpclient, (ClassicHttpRequest)object, (HttpContext)object2, httpClientResponseHandler, futureCallback, this.metrics);
        object = new HttpRequestFutureTask((ClassicHttpRequest)object, object2);
        this.executorService.execute((Runnable)object);
        return object;
    }

    public FutureRequestExecutionMetrics metrics() {
        return this.metrics;
    }

    @Override
    public void close() throws IOException {
        this.closed.set(true);
        this.executorService.shutdownNow();
        if (this.httpclient instanceof Closeable) {
            ((Closeable)((Object)this.httpclient)).close();
        }
    }
}

