/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.classic;

import java.io.IOException;
import java.io.InterruptedIOException;
import org.apache.hc.client5.http.HttpRequestRetryStrategy;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.classic.ExecChain;
import org.apache.hc.client5.http.classic.ExecChain$Scope;
import org.apache.hc.client5.http.classic.ExecChainHandler;
import org.apache.hc.client5.http.impl.classic.RequestFailedException;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.NoHttpResponseException;
import org.apache.hc.core5.http.io.support.ClassicRequestBuilder;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.TimeValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Contract(threading=ThreadingBehavior.STATELESS)
@Internal
public class HttpRequestRetryExec
implements ExecChainHandler {
    private static final Logger LOG = LoggerFactory.getLogger(HttpRequestRetryExec.class);
    private final HttpRequestRetryStrategy retryStrategy;

    public HttpRequestRetryExec(HttpRequestRetryStrategy httpRequestRetryStrategy) {
        Args.notNull(httpRequestRetryStrategy, "retryStrategy");
        this.retryStrategy = httpRequestRetryStrategy;
    }

    @Override
    public ClassicHttpResponse execute(ClassicHttpRequest classicHttpRequest, ExecChain$Scope execChain$Scope, ExecChain execChain) throws IOException, HttpException {
        Args.notNull(classicHttpRequest, "request");
        Args.notNull(execChain$Scope, "scope");
        String string = execChain$Scope.exchangeId;
        Object object = execChain$Scope.route;
        object = ((HttpRoute)object).getTargetHost();
        HttpClientContext httpClientContext = execChain$Scope.clientContext;
        Object object2 = classicHttpRequest;
        int n2 = 1;
        while (true) {
            try {
                ClassicHttpResponse classicHttpResponse = execChain.proceed((ClassicHttpRequest)object2, execChain$Scope);
                try {
                    object2 = classicHttpRequest.getEntity();
                    if (object2 != null && !object2.isRepeatable()) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("{} cannot retry non-repeatable request", (Object)string);
                        }
                        return classicHttpResponse;
                    }
                    if (this.retryStrategy.retryRequest(classicHttpResponse, n2, httpClientContext)) {
                        classicHttpResponse.close();
                        object2 = this.retryStrategy.getRetryInterval(classicHttpResponse, n2, httpClientContext);
                        if (LOG.isInfoEnabled()) {
                            LOG.info("{} {} responded with status {}; request will be automatically re-executed in {} (exec count {})", string, object, classicHttpResponse.getCode(), object2, n2 + 1);
                        }
                    } else {
                        return classicHttpResponse;
                    }
                    HttpRequestRetryExec.pause((TimeValue)object2);
                    object2 = ClassicRequestBuilder.copy(execChain$Scope.originalRequest).build();
                }
                catch (RuntimeException runtimeException) {
                    classicHttpResponse.close();
                    throw runtimeException;
                }
            }
            catch (IOException iOException) {
                if (execChain$Scope.execRuntime.isExecutionAborted()) {
                    throw new RequestFailedException("Request aborted");
                }
                object2 = classicHttpRequest.getEntity();
                if (object2 != null && !object2.isRepeatable()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("{} cannot retry non-repeatable request", (Object)string);
                    }
                    throw iOException;
                }
                if (this.retryStrategy.retryRequest(classicHttpRequest, iOException, n2, httpClientContext)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("{} {}", string, iOException.getMessage(), iOException);
                    }
                    object2 = this.retryStrategy.getRetryInterval(classicHttpRequest, iOException, n2, httpClientContext);
                    if (LOG.isInfoEnabled()) {
                        LOG.info("{} recoverable I/O exception ({}) caught when sending request to {};request will be automatically re-executed in {} (exec count {})", string, iOException.getClass().getName(), object, object2, n2 + 1);
                    }
                    HttpRequestRetryExec.pause((TimeValue)object2);
                    object2 = ClassicRequestBuilder.copy(execChain$Scope.originalRequest).build();
                }
                if (iOException instanceof NoHttpResponseException) {
                    object2 = new NoHttpResponseException(((HttpHost)object).toHostString() + " failed to respond");
                    ((Throwable)object2).setStackTrace(iOException.getStackTrace());
                    throw object2;
                }
                throw iOException;
            }
            ++n2;
        }
    }

    private static void pause(TimeValue timeValue) throws InterruptedIOException {
        if (TimeValue.isPositive(timeValue)) {
            try {
                timeValue.sleep();
                return;
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                throw new InterruptedIOException();
            }
        }
    }
}

