/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.classic;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Function;
import org.apache.hc.client5.http.ClientProtocolException;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.auth.AuthSchemeFactory;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.classic.ExecChain$Scope;
import org.apache.hc.client5.http.config.Configurable;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.cookie.CookieSpecFactory;
import org.apache.hc.client5.http.cookie.CookieStore;
import org.apache.hc.client5.http.impl.ExecSupport;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.ExecChainElement;
import org.apache.hc.client5.http.impl.classic.InternalExecRuntime;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.routing.HttpRoutePlanner;
import org.apache.hc.client5.http.routing.RoutingSupport;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.concurrent.CancellableDependency;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.config.Lookup;
import org.apache.hc.core5.http.impl.io.HttpRequestExecutor;
import org.apache.hc.core5.http.io.support.ClassicRequestBuilder;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.io.ModalCloseable;
import org.apache.hc.core5.net.NamedEndpoint;
import org.apache.hc.core5.net.URIAuthority;
import org.apache.hc.core5.util.Args;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Contract(threading=ThreadingBehavior.SAFE_CONDITIONAL)
@Internal
class InternalHttpClient
extends CloseableHttpClient
implements Configurable {
    private static final Logger LOG = LoggerFactory.getLogger(InternalHttpClient.class);
    private final HttpClientConnectionManager connManager;
    private final HttpRequestExecutor requestExecutor;
    private final ExecChainElement execChain;
    private final HttpRoutePlanner routePlanner;
    private final Lookup<CookieSpecFactory> cookieSpecRegistry;
    private final Lookup<AuthSchemeFactory> authSchemeRegistry;
    private final CookieStore cookieStore;
    private final CredentialsProvider credentialsProvider;
    private final Function<HttpContext, HttpClientContext> contextAdaptor;
    private final RequestConfig defaultConfig;
    private final ConcurrentLinkedQueue<Closeable> closeables;

    public InternalHttpClient(HttpClientConnectionManager httpClientConnectionManager, HttpRequestExecutor httpRequestExecutor, ExecChainElement execChainElement, HttpRoutePlanner httpRoutePlanner, Lookup<CookieSpecFactory> lookup, Lookup<AuthSchemeFactory> lookup2, CookieStore cookieStore, CredentialsProvider credentialsProvider, Function<HttpContext, HttpClientContext> function, RequestConfig requestConfig, List<Closeable> list) {
        this.connManager = Args.notNull(httpClientConnectionManager, "Connection manager");
        this.requestExecutor = Args.notNull(httpRequestExecutor, "Request executor");
        this.execChain = Args.notNull(execChainElement, "Execution chain");
        this.routePlanner = Args.notNull(httpRoutePlanner, "Route planner");
        this.cookieSpecRegistry = lookup;
        this.authSchemeRegistry = lookup2;
        this.cookieStore = cookieStore;
        this.credentialsProvider = credentialsProvider;
        this.contextAdaptor = function;
        this.defaultConfig = requestConfig;
        this.closeables = list != null ? new ConcurrentLinkedQueue<Closeable>(list) : null;
    }

    private HttpRoute determineRoute(HttpHost httpHost, HttpRequest httpRequest, HttpContext httpContext) throws HttpException {
        return this.routePlanner.determineRoute(httpHost, httpRequest, httpContext);
    }

    private void setupContext(HttpClientContext httpClientContext) {
        if (httpClientContext.getAuthSchemeRegistry() == null) {
            httpClientContext.setAuthSchemeRegistry(this.authSchemeRegistry);
        }
        if (httpClientContext.getCookieSpecRegistry() == null) {
            httpClientContext.setCookieSpecRegistry(this.cookieSpecRegistry);
        }
        if (httpClientContext.getCookieStore() == null) {
            httpClientContext.setCookieStore(this.cookieStore);
        }
        if (httpClientContext.getCredentialsProvider() == null) {
            httpClientContext.setCredentialsProvider(this.credentialsProvider);
        }
        if (httpClientContext.getRequestConfig() == null) {
            httpClientContext.setRequestConfig(this.defaultConfig);
        }
    }

    @Override
    protected CloseableHttpResponse doExecute(HttpHost object, ClassicHttpRequest classicHttpRequest, HttpContext httpContext) throws IOException {
        Args.notNull(classicHttpRequest, "HTTP request");
        try {
            httpContext = this.contextAdaptor.apply(httpContext);
            Object object2 = null;
            if (classicHttpRequest instanceof Configurable) {
                object2 = ((Configurable)((Object)classicHttpRequest)).getConfig();
            }
            if (object2 != null) {
                ((HttpClientContext)httpContext).setRequestConfig((RequestConfig)object2);
            }
            this.setupContext((HttpClientContext)httpContext);
            if ((object = object != null ? object : RoutingSupport.determineHost(classicHttpRequest)) != null) {
                if (classicHttpRequest.getScheme() == null) {
                    classicHttpRequest.setScheme(((HttpHost)object).getSchemeName());
                }
                if (classicHttpRequest.getAuthority() == null) {
                    classicHttpRequest.setAuthority(new URIAuthority((NamedEndpoint)object));
                }
            }
            object = this.determineRoute((HttpHost)object, classicHttpRequest, httpContext);
            object2 = ExecSupport.getNextExchangeId();
            ((HttpClientContext)httpContext).setExchangeId((String)object2);
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} preparing request execution", object2);
            }
            InternalExecRuntime internalExecRuntime = new InternalExecRuntime(LOG, this.connManager, this.requestExecutor, classicHttpRequest instanceof CancellableDependency ? (CancellableDependency)((Object)classicHttpRequest) : null);
            object = new ExecChain$Scope((String)object2, (HttpRoute)object, classicHttpRequest, internalExecRuntime, (HttpClientContext)httpContext);
            object = this.execChain.execute(ClassicRequestBuilder.copy(classicHttpRequest).build(), (ExecChain$Scope)object);
            return CloseableHttpResponse.adapt((ClassicHttpResponse)object);
        }
        catch (HttpException httpException) {
            throw new ClientProtocolException(httpException.getMessage(), httpException);
        }
    }

    @Override
    public RequestConfig getConfig() {
        return this.defaultConfig;
    }

    @Override
    public void close() {
        this.close(CloseMode.GRACEFUL);
    }

    @Override
    public void close(CloseMode closeMode) {
        if (this.closeables != null) {
            Closeable closeable;
            while ((closeable = this.closeables.poll()) != null) {
                try {
                    if (closeable instanceof ModalCloseable) {
                        ((ModalCloseable)closeable).close(closeMode);
                        continue;
                    }
                    closeable.close();
                }
                catch (IOException iOException) {
                    LOG.error(iOException.getMessage(), iOException);
                }
            }
        }
    }
}

