/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.classic;

import java.io.IOException;
import java.io.InterruptedIOException;
import org.apache.hc.client5.http.ConnectionKeepAliveStrategy;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.UserTokenHandler;
import org.apache.hc.client5.http.classic.ExecChain;
import org.apache.hc.client5.http.classic.ExecChain$Scope;
import org.apache.hc.client5.http.classic.ExecChainHandler;
import org.apache.hc.client5.http.classic.ExecRuntime;
import org.apache.hc.client5.http.impl.ConnectionShutdownException;
import org.apache.hc.client5.http.impl.ProtocolSwitchStrategy;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ConnectionReuseStrategy;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpConnection;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpMessage;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.protocol.HttpProcessor;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.TimeValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Contract(threading=ThreadingBehavior.STATELESS)
@Internal
public final class MainClientExec
implements ExecChainHandler {
    private static final Logger LOG = LoggerFactory.getLogger(MainClientExec.class);
    private final HttpClientConnectionManager connectionManager;
    private final HttpProcessor httpProcessor;
    private final ConnectionReuseStrategy reuseStrategy;
    private final ConnectionKeepAliveStrategy keepAliveStrategy;
    private final UserTokenHandler userTokenHandler;
    private final ProtocolSwitchStrategy protocolSwitchStrategy;

    public MainClientExec(HttpClientConnectionManager httpClientConnectionManager, HttpProcessor httpProcessor, ConnectionReuseStrategy connectionReuseStrategy, ConnectionKeepAliveStrategy connectionKeepAliveStrategy, UserTokenHandler userTokenHandler) {
        this.connectionManager = Args.notNull(httpClientConnectionManager, "Connection manager");
        this.httpProcessor = Args.notNull(httpProcessor, "HTTP protocol processor");
        this.reuseStrategy = Args.notNull(connectionReuseStrategy, "Connection reuse strategy");
        this.keepAliveStrategy = Args.notNull(connectionKeepAliveStrategy, "Connection keep alive strategy");
        this.userTokenHandler = Args.notNull(userTokenHandler, "User token handler");
        this.protocolSwitchStrategy = new ProtocolSwitchStrategy();
    }

    @Override
    public final ClassicHttpResponse execute(ClassicHttpRequest object, ExecChain$Scope object2, ExecChain object3) throws IOException, HttpException {
        Args.notNull(object, "HTTP request");
        Args.notNull(object2, "Scope");
        object3 = ((ExecChain$Scope)object2).exchangeId;
        Object object4 = ((ExecChain$Scope)object2).route;
        HttpClientContext httpClientContext = ((ExecChain$Scope)object2).clientContext;
        object2 = ((ExecChain$Scope)object2).execRuntime;
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} executing {} {}", object3, object.getMethod(), object.getRequestUri());
        }
        try {
            httpClientContext.setRoute((HttpRoute)object4);
            httpClientContext.setRequest((HttpRequest)object);
            ClassicHttpRequest classicHttpRequest = object;
            this.httpProcessor.process(classicHttpRequest, (EntityDetails)classicHttpRequest.getEntity(), (HttpContext)httpClientContext);
            ClassicHttpResponse classicHttpResponse = object2.execute((String)object3, (ClassicHttpRequest)object, (arg_0, arg_1, arg_2) -> this.lambda$execute$0((ExecRuntime)object2, httpClientContext, arg_0, arg_1, arg_2), httpClientContext);
            httpClientContext.setResponse(classicHttpResponse);
            ClassicHttpResponse classicHttpResponse2 = classicHttpResponse;
            this.httpProcessor.process(classicHttpResponse2, (EntityDetails)classicHttpResponse2.getEntity(), (HttpContext)httpClientContext);
            Object object5 = httpClientContext.getUserToken();
            if (object5 == null) {
                object5 = this.userTokenHandler.getUserToken((HttpRoute)object4, (HttpRequest)object, httpClientContext);
                httpClientContext.setUserToken(object5);
            }
            if (this.reuseStrategy.keepAlive((HttpRequest)object, classicHttpResponse, httpClientContext)) {
                object = this.keepAliveStrategy.getKeepAliveDuration(classicHttpResponse, httpClientContext);
                if (LOG.isDebugEnabled()) {
                    object4 = object != null ? "for " + object : "indefinitely";
                    LOG.debug("{} connection can be kept alive {}", object3, object4);
                }
                object2.markConnectionReusable(object5, (TimeValue)object);
            } else {
                object2.markConnectionNonReusable();
            }
            object = classicHttpResponse.getEntity();
            if (object == null || !object.isStreaming()) {
                object2.releaseEndpoint();
                return new CloseableHttpResponse(classicHttpResponse);
            }
            return new CloseableHttpResponse(classicHttpResponse, (ExecRuntime)object2);
        }
        catch (ConnectionShutdownException connectionShutdownException) {
            InterruptedIOException interruptedIOException = new InterruptedIOException("Connection has been shut down");
            interruptedIOException.initCause(connectionShutdownException);
            object2.discardEndpoint();
            throw interruptedIOException;
        }
        catch (IOException | RuntimeException | HttpException exception) {
            object2.discardEndpoint();
            throw exception;
        }
        catch (Error error) {
            this.connectionManager.close(CloseMode.IMMEDIATE);
            throw error;
        }
    }

    private /* synthetic */ void lambda$execute$0(ExecRuntime execRuntime, HttpClientContext httpClientContext, HttpResponse object, HttpConnection httpConnection, HttpContext httpContext) throws HttpException {
        if (object.getCode() == 101) {
            if ((object = this.protocolSwitchStrategy.switchProtocol((HttpMessage)object)) == null || !((ProtocolVersion)object).getProtocol().equals("TLS")) {
                throw new ProtocolException("Failure switching protocols");
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Switching to {}", object);
            }
            try {
                execRuntime.upgradeTls(httpClientContext);
            }
            catch (IOException iOException) {
                throw new HttpException("Failure upgrading to TLS", iOException);
            }
            LOG.debug("Successfully switched to {}", object);
        }
    }
}

