/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.classic;

import java.io.IOException;
import java.net.Socket;
import org.apache.hc.client5.http.AuthenticationStrategy;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.RouteInfo$LayerType;
import org.apache.hc.client5.http.RouteInfo$TunnelType;
import org.apache.hc.client5.http.auth.AuthExchange;
import org.apache.hc.client5.http.auth.AuthSchemeFactory;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.ChallengeType;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.DefaultAuthenticationStrategy;
import org.apache.hc.client5.http.impl.DefaultClientConnectionReuseStrategy;
import org.apache.hc.client5.http.impl.auth.AuthenticationHandler;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.auth.BasicSchemeFactory;
import org.apache.hc.client5.http.impl.auth.DigestSchemeFactory;
import org.apache.hc.client5.http.impl.io.ManagedHttpClientConnectionFactory;
import org.apache.hc.client5.http.io.ManagedHttpClientConnection;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.protocol.RequestClientConnControl;
import org.apache.hc.core5.http.ConnectionReuseStrategy;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.Method;
import org.apache.hc.core5.http.config.CharCodingConfig;
import org.apache.hc.core5.http.config.Http1Config;
import org.apache.hc.core5.http.config.Lookup;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.apache.hc.core5.http.impl.io.HttpRequestExecutor;
import org.apache.hc.core5.http.io.HttpConnectionFactory;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.message.BasicClassicHttpRequest;
import org.apache.hc.core5.http.message.StatusLine;
import org.apache.hc.core5.http.protocol.DefaultHttpProcessor;
import org.apache.hc.core5.http.protocol.HttpProcessor;
import org.apache.hc.core5.http.protocol.RequestTargetHost;
import org.apache.hc.core5.http.protocol.RequestUserAgent;
import org.apache.hc.core5.util.Args;

public class ProxyClient {
    private final HttpConnectionFactory<ManagedHttpClientConnection> connFactory;
    private final RequestConfig requestConfig;
    private final HttpProcessor httpProcessor;
    private final HttpRequestExecutor requestExec;
    private final AuthenticationStrategy proxyAuthStrategy;
    private final AuthenticationHandler authenticator;
    private final AuthExchange proxyAuthExchange;
    private final Lookup<AuthSchemeFactory> authSchemeRegistry;
    private final ConnectionReuseStrategy reuseStrategy;

    public ProxyClient(HttpConnectionFactory<ManagedHttpClientConnection> managedHttpClientConnectionFactory, Http1Config http1Config, CharCodingConfig charCodingConfig, RequestConfig requestConfig) {
        this.connFactory = managedHttpClientConnectionFactory != null ? managedHttpClientConnectionFactory : ManagedHttpClientConnectionFactory.builder().http1Config(http1Config).charCodingConfig(charCodingConfig).build();
        this.requestConfig = requestConfig != null ? requestConfig : RequestConfig.DEFAULT;
        this.httpProcessor = new DefaultHttpProcessor(new RequestTargetHost(), new RequestClientConnControl(), new RequestUserAgent());
        this.requestExec = new HttpRequestExecutor();
        this.proxyAuthStrategy = new DefaultAuthenticationStrategy();
        this.authenticator = new AuthenticationHandler();
        this.proxyAuthExchange = new AuthExchange();
        this.authSchemeRegistry = RegistryBuilder.create().register("Basic", BasicSchemeFactory.INSTANCE).register("Digest", (BasicSchemeFactory)((Object)DigestSchemeFactory.INSTANCE)).build();
        this.reuseStrategy = DefaultClientConnectionReuseStrategy.INSTANCE;
    }

    public ProxyClient(RequestConfig requestConfig) {
        this(null, null, null, requestConfig);
    }

    public ProxyClient() {
        this(null, null, null, null);
    }

    public Socket tunnel(HttpHost httpHost, HttpHost object, Credentials object2) throws IOException, HttpException {
        int n2;
        Args.notNull(httpHost, "Proxy host");
        Args.notNull(object, "Target host");
        Args.notNull(object2, "Credentials");
        Args.check(((HttpHost)object).getPort() > 0, "A valid port number must be provided for the tunnel CONNECT request.");
        HttpRoute httpRoute = new HttpRoute((HttpHost)object, null, httpHost, false, RouteInfo$TunnelType.TUNNELLED, RouteInfo$LayerType.PLAIN);
        ManagedHttpClientConnection managedHttpClientConnection = this.connFactory.createConnection(null);
        HttpClientContext httpClientContext = HttpClientContext.create();
        BasicClassicHttpRequest basicClassicHttpRequest = new BasicClassicHttpRequest(Method.CONNECT, httpHost, ((HttpHost)object).toHostString());
        object = new BasicCredentialsProvider();
        ((BasicCredentialsProvider)object).setCredentials(new AuthScope(httpHost), (Credentials)object2);
        httpClientContext.setRequest(basicClassicHttpRequest);
        httpClientContext.setRoute(httpRoute);
        httpClientContext.setCredentialsProvider((CredentialsProvider)object);
        httpClientContext.setAuthSchemeRegistry(this.authSchemeRegistry);
        httpClientContext.setRequestConfig(this.requestConfig);
        this.requestExec.preProcess(basicClassicHttpRequest, this.httpProcessor, httpClientContext);
        while (true) {
            if (!managedHttpClientConnection.isOpen()) {
                object2 = new Socket(httpHost.getHostName(), httpHost.getPort());
                managedHttpClientConnection.bind((Socket)object2);
            }
            this.authenticator.addAuthResponse(httpHost, ChallengeType.PROXY, basicClassicHttpRequest, this.proxyAuthExchange, httpClientContext);
            object = this.requestExec.execute(basicClassicHttpRequest, managedHttpClientConnection, httpClientContext);
            n2 = object.getCode();
            if (n2 < 200) {
                throw new HttpException("Unexpected response to CONNECT request: " + object);
            }
            if (!this.authenticator.isChallenged(httpHost, ChallengeType.PROXY, (HttpResponse)object, this.proxyAuthExchange, httpClientContext) && !this.authenticator.isChallengeExpected(this.proxyAuthExchange) || !this.authenticator.handleResponse(httpHost, ChallengeType.PROXY, (HttpResponse)object, this.proxyAuthStrategy, this.proxyAuthExchange, httpClientContext)) break;
            if (this.reuseStrategy.keepAlive(basicClassicHttpRequest, (HttpResponse)object, httpClientContext)) {
                object = object.getEntity();
                EntityUtils.consume((HttpEntity)object);
            } else {
                managedHttpClientConnection.close();
            }
            basicClassicHttpRequest.removeHeaders("Proxy-Authorization");
        }
        n2 = object.getCode();
        if (n2 > 299) {
            EntityUtils.consume(object.getEntity());
            managedHttpClientConnection.close();
            throw new HttpException("Tunnel refused: " + new StatusLine((HttpResponse)object));
        }
        return managedHttpClientConnection.getSocket();
    }
}

