/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.classic;

import java.io.IOException;
import java.net.URI;
import java.util.Objects;
import org.apache.hc.client5.http.CircularRedirectException;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.RedirectException;
import org.apache.hc.client5.http.auth.AuthExchange;
import org.apache.hc.client5.http.classic.ExecChain;
import org.apache.hc.client5.http.classic.ExecChain$Scope;
import org.apache.hc.client5.http.classic.ExecChainHandler;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.RequestEntityProxy;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.protocol.RedirectLocations;
import org.apache.hc.client5.http.protocol.RedirectStrategy;
import org.apache.hc.client5.http.routing.HttpRoutePlanner;
import org.apache.hc.client5.http.utils.URIUtils;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.Method;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.support.ClassicRequestBuilder;
import org.apache.hc.core5.util.Args;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Contract(threading=ThreadingBehavior.STATELESS)
@Internal
public final class RedirectExec
implements ExecChainHandler {
    private static final Logger LOG = LoggerFactory.getLogger(RedirectExec.class);
    private final RedirectStrategy redirectStrategy;
    private final HttpRoutePlanner routePlanner;

    public RedirectExec(HttpRoutePlanner httpRoutePlanner, RedirectStrategy redirectStrategy) {
        Args.notNull(httpRoutePlanner, "HTTP route planner");
        Args.notNull(redirectStrategy, "HTTP redirect strategy");
        this.routePlanner = httpRoutePlanner;
        this.redirectStrategy = redirectStrategy;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final ClassicHttpResponse execute(ClassicHttpRequest classicHttpRequest, ExecChain$Scope execChain$Scope, ExecChain execChain) throws IOException, HttpException {
        Args.notNull(classicHttpRequest, "HTTP request");
        Args.notNull(execChain$Scope, "Scope");
        HttpClientContext httpClientContext = execChain$Scope.clientContext;
        httpClientContext.setRedirectLocations(null);
        RequestConfig requestConfig = httpClientContext.getRequestConfigOrDefault();
        int n2 = requestConfig.getMaxRedirects() > 0 ? requestConfig.getMaxRedirects() : 50;
        Object object = classicHttpRequest;
        Object object2 = execChain$Scope;
        int n3 = 0;
        while (true) {
            String string = ((ExecChain$Scope)object2).exchangeId;
            ClassicHttpResponse classicHttpResponse = execChain.proceed((ClassicHttpRequest)object, (ExecChain$Scope)object2);
            try {
                Object object3;
                Object object4;
                block28: {
                    block27: {
                        if (!requestConfig.isRedirectsEnabled()) return classicHttpResponse;
                        if (!this.redirectStrategy.isRedirected(classicHttpRequest, classicHttpResponse, httpClientContext)) return classicHttpResponse;
                        object4 = classicHttpRequest.getEntity();
                        if (object4 != null && !object4.isRepeatable()) {
                            if (!LOG.isDebugEnabled()) return classicHttpResponse;
                            LOG.debug("{} cannot redirect non-repeatable request", (Object)string);
                            return classicHttpResponse;
                        }
                        if (n3 >= n2) {
                            throw new RedirectException("Maximum redirects (" + n2 + ") exceeded");
                        }
                        ++n3;
                        object = this.redirectStrategy.getLocationURI((HttpRequest)object, classicHttpResponse, httpClientContext);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("{} redirect requested to location '{}'", (Object)string, object);
                        }
                        if ((object4 = URIUtils.extractHost((URI)object)) == null) {
                            throw new ProtocolException("Redirect URI does not specify a valid host name: " + object);
                        }
                        Object object5 = httpClientContext.getRedirectLocations();
                        if (!requestConfig.isCircularRedirectsAllowed() && ((RedirectLocations)object5).contains((URI)object)) {
                            throw new CircularRedirectException("Circular redirect to '" + object + "'");
                        }
                        int n4 = classicHttpResponse.getCode();
                        switch (n4) {
                            case 301: 
                            case 302: {
                                if (Method.POST.isSame(classicHttpRequest.getMethod())) {
                                    object3 = ClassicRequestBuilder.get();
                                    break;
                                }
                                object3 = ClassicRequestBuilder.copy(((ExecChain$Scope)object2).originalRequest);
                                break;
                            }
                            case 303: {
                                if (!Method.GET.isSame(classicHttpRequest.getMethod()) && !Method.HEAD.isSame(classicHttpRequest.getMethod())) {
                                    object3 = ClassicRequestBuilder.get();
                                    break;
                                }
                                object3 = ClassicRequestBuilder.copy(((ExecChain$Scope)object2).originalRequest);
                                break;
                            }
                            default: {
                                object3 = ClassicRequestBuilder.copy(((ExecChain$Scope)object2).originalRequest);
                            }
                        }
                        ((ClassicRequestBuilder)object3).setUri((URI)object);
                        object3 = ((ClassicRequestBuilder)object3).build();
                        object2 = ((ExecChain$Scope)object2).route;
                        HttpHost httpHost = ((HttpRoute)object2).getTargetHost();
                        if (!this.redirectStrategy.isRedirectAllowed(httpHost, (HttpHost)object4, (HttpRequest)object3, httpClientContext)) {
                            if (!LOG.isDebugEnabled()) return classicHttpResponse;
                            LOG.debug("{} cannot redirect due to safety restrictions", (Object)string);
                            return classicHttpResponse;
                        }
                        ((RedirectLocations)object5).add((URI)object);
                        if (Objects.equals(httpHost, object4)) break block27;
                        if (!Objects.equals(object2, object4 = this.routePlanner.determineRoute((HttpHost)object4, httpClientContext))) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("{} new route required", (Object)string);
                            }
                            object5 = httpClientContext.getAuthExchange(httpHost);
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("{} resetting target auth state", (Object)string);
                            }
                            ((AuthExchange)object5).reset();
                            object2 = ((HttpRoute)object2).getProxyHost();
                            if (object2 != null && ((AuthExchange)(object2 = httpClientContext.getAuthExchange((HttpHost)object2))).isConnectionBased()) {
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug("{} resetting proxy auth state", (Object)string);
                                }
                                ((AuthExchange)object2).reset();
                            }
                        }
                        break block28;
                    }
                    object4 = object2;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} redirecting to '{}' via {}", string, object, object4);
                }
                object2 = new ExecChain$Scope(execChain$Scope.exchangeId, (HttpRoute)object4, ClassicRequestBuilder.copy((ClassicHttpRequest)object3).build(), execChain$Scope.execRuntime, execChain$Scope.clientContext);
                object = object3;
                RequestEntityProxy.enhance((ClassicHttpRequest)object);
                EntityUtils.consume(classicHttpResponse.getEntity());
                classicHttpResponse.close();
            }
            catch (IOException | RuntimeException exception) {
                classicHttpResponse.close();
                throw exception;
            }
            catch (HttpException httpException) {
                try {
                    EntityUtils.consume(classicHttpResponse.getEntity());
                    throw httpException;
                }
                catch (IOException iOException) {
                    if (!LOG.isDebugEnabled()) throw httpException;
                    LOG.debug("{} I/O error while releasing connection", (Object)string, (Object)iOException);
                    throw httpException;
                }
                finally {
                    classicHttpResponse.close();
                }
            }
        }
    }
}

