/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.classic;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.util.Arrays;
import java.util.List;
import org.apache.hc.client5.http.classic.ExecRuntime;
import org.apache.hc.client5.http.impl.classic.ResponseEntityProxy$NullOutputStream;
import org.apache.hc.core5.function.Supplier;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.impl.io.ChunkedInputStream;
import org.apache.hc.core5.http.io.EofSensorInputStream;
import org.apache.hc.core5.http.io.EofSensorWatcher;
import org.apache.hc.core5.http.io.entity.HttpEntityWrapper;

class ResponseEntityProxy
extends HttpEntityWrapper
implements EofSensorWatcher {
    private final ExecRuntime execRuntime;

    public static void enhance(ClassicHttpResponse classicHttpResponse, ExecRuntime execRuntime) {
        HttpEntity httpEntity = classicHttpResponse.getEntity();
        if (httpEntity != null && httpEntity.isStreaming() && execRuntime != null) {
            classicHttpResponse.setEntity(new ResponseEntityProxy(httpEntity, execRuntime));
        }
    }

    ResponseEntityProxy(HttpEntity httpEntity, ExecRuntime execRuntime) {
        super(httpEntity);
        this.execRuntime = execRuntime;
    }

    private void cleanup() throws IOException {
        if (this.execRuntime != null) {
            if (this.execRuntime.isEndpointConnected()) {
                this.execRuntime.disconnectEndpoint();
            }
            this.execRuntime.discardEndpoint();
        }
    }

    private void discardConnection() {
        if (this.execRuntime != null) {
            this.execRuntime.discardEndpoint();
        }
    }

    public void releaseConnection() {
        if (this.execRuntime != null) {
            this.execRuntime.releaseEndpoint();
        }
    }

    @Override
    public boolean isRepeatable() {
        return false;
    }

    @Override
    public InputStream getContent() throws IOException {
        return new EofSensorInputStream(super.getContent(), this);
    }

    @Override
    public void writeTo(OutputStream outputStream) throws IOException {
        try {
            super.writeTo(outputStream != null ? outputStream : ResponseEntityProxy$NullOutputStream.access$000());
            this.releaseConnection();
            return;
        }
        catch (IOException | RuntimeException exception) {
            this.discardConnection();
            throw exception;
        }
        finally {
            this.cleanup();
        }
    }

    @Override
    public boolean eofDetected(InputStream inputStream) throws IOException {
        try {
            if (inputStream != null) {
                inputStream.close();
            }
            this.releaseConnection();
        }
        catch (IOException | RuntimeException exception) {
            this.discardConnection();
            throw exception;
        }
        finally {
            this.cleanup();
        }
        return false;
    }

    @Override
    public boolean streamClosed(InputStream inputStream) throws IOException {
        try {
            boolean bl2 = this.execRuntime != null && this.execRuntime.isEndpointAcquired();
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                this.releaseConnection();
            }
            catch (SocketException socketException) {
                if (bl2) {
                    throw socketException;
                }
            }
        }
        catch (IOException | RuntimeException exception) {
            this.discardConnection();
            throw exception;
        }
        finally {
            this.cleanup();
        }
        return false;
    }

    @Override
    public boolean streamAbort(InputStream inputStream) throws IOException {
        this.cleanup();
        return false;
    }

    @Override
    public Supplier<List<? extends Header>> getTrailers() {
        try {
            InputStream inputStream = super.getContent();
            return () -> {
                if (inputStream instanceof ChunkedInputStream) {
                    inputStream = (ChunkedInputStream)inputStream;
                    inputStream = inputStream.getFooters();
                } else {
                    inputStream = new Header[]{};
                }
                return Arrays.asList(inputStream);
            };
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Unable to retrieve input stream", iOException);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            super.close();
            this.releaseConnection();
            return;
        }
        catch (IOException | RuntimeException exception) {
            this.discardConnection();
            throw exception;
        }
        finally {
            this.cleanup();
        }
    }
}

