/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.compat;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hc.client5.http.impl.compat.ClassicToAsyncResponseConsumer$IncomingHttpEntity;
import org.apache.hc.client5.http.impl.compat.ClassicToAsyncResponseConsumer$InternalInputStream;
import org.apache.hc.client5.http.impl.compat.ClassicToAsyncResponseConsumer$ResponseData;
import org.apache.hc.client5.http.impl.compat.ClassicToAsyncSupport;
import org.apache.hc.client5.http.impl.compat.SharedInputBuffer;
import org.apache.hc.core5.annotation.Experimental;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.io.support.ClassicResponseBuilder;
import org.apache.hc.core5.http.nio.AsyncResponseConsumer;
import org.apache.hc.core5.http.nio.CapacityChannel;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.Asserts;
import org.apache.hc.core5.util.Timeout;

@Experimental
@Internal
class ClassicToAsyncResponseConsumer
implements AsyncResponseConsumer<Void> {
    private final int initialBufferSize;
    private final Timeout timeout;
    private final CountDownLatch countDownLatch;
    private final AtomicReference<ClassicToAsyncResponseConsumer$ResponseData> responseRef;
    private final AtomicReference<FutureCallback<Void>> callbackRef;
    private final AtomicReference<SharedInputBuffer> bufferRef;
    private final AtomicReference<Exception> exceptionRef;

    public ClassicToAsyncResponseConsumer(int n2, Timeout timeout) {
        this.initialBufferSize = Args.positive(n2, "Initial buffer size");
        this.timeout = timeout;
        this.countDownLatch = new CountDownLatch(1);
        this.responseRef = new AtomicReference();
        this.callbackRef = new AtomicReference();
        this.bufferRef = new AtomicReference();
        this.exceptionRef = new AtomicReference();
    }

    public ClassicToAsyncResponseConsumer(Timeout timeout) {
        this(2048, timeout);
    }

    void propagateException() throws IOException {
        Exception exception = this.exceptionRef.getAndSet(null);
        if (exception != null) {
            ClassicToAsyncSupport.rethrow(exception);
        }
    }

    void fireComplete() throws IOException {
        FutureCallback futureCallback = this.callbackRef.getAndSet(null);
        if (futureCallback != null) {
            futureCallback.completed(null);
        }
    }

    public ClassicHttpResponse blockWaiting() throws IOException, InterruptedException {
        if (this.timeout == null) {
            this.countDownLatch.await();
        } else if (!this.countDownLatch.await(this.timeout.getDuration(), this.timeout.getTimeUnit())) {
            throw new InterruptedIOException("Timeout blocked waiting for input (" + this.timeout + ")");
        }
        this.propagateException();
        ClassicToAsyncResponseConsumer$ResponseData classicToAsyncResponseConsumer$ResponseData = this.responseRef.getAndSet(null);
        Asserts.notNull(classicToAsyncResponseConsumer$ResponseData, "HTTP response is missing");
        SharedInputBuffer sharedInputBuffer = this.bufferRef.get();
        return ClassicResponseBuilder.create(classicToAsyncResponseConsumer$ResponseData.head.getCode()).setHeaders(classicToAsyncResponseConsumer$ResponseData.head.getHeaders()).setVersion(classicToAsyncResponseConsumer$ResponseData.head.getVersion()).setEntity(classicToAsyncResponseConsumer$ResponseData.entityDetails != null ? new ClassicToAsyncResponseConsumer$IncomingHttpEntity(new ClassicToAsyncResponseConsumer$InternalInputStream(this, sharedInputBuffer), classicToAsyncResponseConsumer$ResponseData.entityDetails) : null).build();
    }

    @Override
    public void consumeResponse(HttpResponse object, EntityDetails entityDetails, HttpContext httpContext, FutureCallback<Void> futureCallback) throws HttpException, IOException {
        this.callbackRef.set(futureCallback);
        object = new ClassicToAsyncResponseConsumer$ResponseData((HttpResponse)object, entityDetails);
        this.responseRef.set((ClassicToAsyncResponseConsumer$ResponseData)object);
        if (entityDetails != null) {
            this.bufferRef.set(new SharedInputBuffer(this.initialBufferSize));
        } else {
            this.fireComplete();
        }
        this.countDownLatch.countDown();
    }

    @Override
    public void informationResponse(HttpResponse httpResponse, HttpContext httpContext) throws HttpException, IOException {
    }

    @Override
    public final void updateCapacity(CapacityChannel capacityChannel) throws IOException {
        SharedInputBuffer sharedInputBuffer = this.bufferRef.get();
        if (sharedInputBuffer != null) {
            sharedInputBuffer.updateCapacity(capacityChannel);
        }
    }

    @Override
    public final void consume(ByteBuffer byteBuffer) throws IOException {
        SharedInputBuffer sharedInputBuffer = this.bufferRef.get();
        if (sharedInputBuffer != null) {
            sharedInputBuffer.fill(byteBuffer);
        }
    }

    @Override
    public final void streamEnd(List<? extends Header> object) throws HttpException, IOException {
        object = this.bufferRef.get();
        if (object != null) {
            ((SharedInputBuffer)object).markEndStream();
        }
    }

    @Override
    public final void failed(Exception exception) {
        try {
            this.exceptionRef.set(exception);
            return;
        }
        finally {
            this.countDownLatch.countDown();
        }
    }

    @Override
    public void releaseResources() {
    }

    static /* synthetic */ Timeout access$000(ClassicToAsyncResponseConsumer classicToAsyncResponseConsumer) {
        return classicToAsyncResponseConsumer.timeout;
    }
}

