/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cookie;

import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import org.apache.hc.client5.http.cookie.CommonCookieAttributeHandler;
import org.apache.hc.client5.http.cookie.MalformedCookieException;
import org.apache.hc.client5.http.cookie.SetCookie;
import org.apache.hc.client5.http.impl.cookie.AbstractCookieAttributeHandler;
import org.apache.hc.client5.http.utils.DateUtils;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.STATELESS)
public class BasicExpiresHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    private final DateTimeFormatter[] datePatterns;

    public BasicExpiresHandler(DateTimeFormatter ... dateTimeFormatterArray) {
        this.datePatterns = dateTimeFormatterArray;
    }

    @Deprecated
    public BasicExpiresHandler(String[] stringArray) {
        Args.notNull(stringArray, "Array of date patterns");
        this.datePatterns = new DateTimeFormatter[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            this.datePatterns[i2] = new DateTimeFormatterBuilder().parseLenient().parseCaseInsensitive().appendPattern(stringArray[i2]).toFormatter();
        }
    }

    @Override
    public void parse(SetCookie setCookie, String string) throws MalformedCookieException {
        Args.notNull(setCookie, "Cookie");
        if (string == null) {
            throw new MalformedCookieException("Missing value for 'expires' attribute");
        }
        Instant instant = DateUtils.parseDate(string, this.datePatterns);
        if (instant == null) {
            throw new MalformedCookieException("Invalid 'expires' attribute: " + string);
        }
        setCookie.setExpiryDate(instant);
    }

    @Override
    public String getAttributeName() {
        return "expires";
    }
}

