/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cookie;

import java.util.concurrent.locks.ReentrantLock;
import org.apache.hc.client5.http.cookie.CookieSpec;
import org.apache.hc.client5.http.cookie.CookieSpecFactory;
import org.apache.hc.client5.http.impl.cookie.BasicDomainHandler;
import org.apache.hc.client5.http.impl.cookie.BasicExpiresHandler;
import org.apache.hc.client5.http.impl.cookie.BasicHttpOnlyHandler;
import org.apache.hc.client5.http.impl.cookie.BasicMaxAgeHandler;
import org.apache.hc.client5.http.impl.cookie.BasicPathHandler;
import org.apache.hc.client5.http.impl.cookie.BasicSecureHandler;
import org.apache.hc.client5.http.impl.cookie.LaxExpiresHandler;
import org.apache.hc.client5.http.impl.cookie.LaxMaxAgeHandler;
import org.apache.hc.client5.http.impl.cookie.PublicSuffixDomainFilter;
import org.apache.hc.client5.http.impl.cookie.RFC6265CookieSpecFactory$1;
import org.apache.hc.client5.http.impl.cookie.RFC6265CookieSpecFactory$CompatibilityLevel;
import org.apache.hc.client5.http.impl.cookie.RFC6265LaxSpec;
import org.apache.hc.client5.http.impl.cookie.RFC6265StrictSpec;
import org.apache.hc.client5.http.psl.PublicSuffixMatcher;
import org.apache.hc.client5.http.utils.DateUtils;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.protocol.HttpContext;

@Contract(threading=ThreadingBehavior.SAFE)
public class RFC6265CookieSpecFactory
implements CookieSpecFactory {
    private final ReentrantLock lock;
    private final RFC6265CookieSpecFactory$CompatibilityLevel compatibilityLevel;
    private final PublicSuffixMatcher publicSuffixMatcher;
    private volatile CookieSpec cookieSpec;

    public RFC6265CookieSpecFactory(RFC6265CookieSpecFactory$CompatibilityLevel rFC6265CookieSpecFactory$CompatibilityLevel, PublicSuffixMatcher publicSuffixMatcher) {
        this.compatibilityLevel = rFC6265CookieSpecFactory$CompatibilityLevel != null ? rFC6265CookieSpecFactory$CompatibilityLevel : RFC6265CookieSpecFactory$CompatibilityLevel.RELAXED;
        this.publicSuffixMatcher = publicSuffixMatcher;
        this.lock = new ReentrantLock();
    }

    public RFC6265CookieSpecFactory(PublicSuffixMatcher publicSuffixMatcher) {
        this(RFC6265CookieSpecFactory$CompatibilityLevel.RELAXED, publicSuffixMatcher);
    }

    public RFC6265CookieSpecFactory() {
        this(RFC6265CookieSpecFactory$CompatibilityLevel.RELAXED, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public CookieSpec create(HttpContext httpContext) {
        if (this.cookieSpec != null) return this.cookieSpec;
        this.lock.lock();
        try {
            if (this.cookieSpec != null) return this.cookieSpec;
            switch (this.compatibilityLevel) {
                case STRICT: {
                    this.cookieSpec = new RFC6265StrictSpec(BasicPathHandler.INSTANCE, PublicSuffixDomainFilter.decorate(BasicDomainHandler.INSTANCE, this.publicSuffixMatcher), BasicMaxAgeHandler.INSTANCE, BasicSecureHandler.INSTANCE, BasicHttpOnlyHandler.INSTANCE, new BasicExpiresHandler(DateUtils.STANDARD_PATTERNS));
                    return this.cookieSpec;
                }
                case IE_MEDIUM_SECURITY: {
                    this.cookieSpec = new RFC6265LaxSpec(new RFC6265CookieSpecFactory$1(this), PublicSuffixDomainFilter.decorate(BasicDomainHandler.INSTANCE, this.publicSuffixMatcher), BasicMaxAgeHandler.INSTANCE, BasicSecureHandler.INSTANCE, BasicHttpOnlyHandler.INSTANCE, new BasicExpiresHandler(DateUtils.STANDARD_PATTERNS));
                    return this.cookieSpec;
                }
                default: {
                    this.cookieSpec = new RFC6265LaxSpec(BasicPathHandler.INSTANCE, PublicSuffixDomainFilter.decorate(BasicDomainHandler.INSTANCE, this.publicSuffixMatcher), LaxMaxAgeHandler.INSTANCE, BasicSecureHandler.INSTANCE, LaxExpiresHandler.INSTANCE);
                    return this.cookieSpec;
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }
}

