/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.io;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.SSLSocket;
import org.apache.hc.client5.http.ConnectExceptionSupport;
import org.apache.hc.client5.http.DnsResolver;
import org.apache.hc.client5.http.SchemePortResolver;
import org.apache.hc.client5.http.SystemDefaultDnsResolver;
import org.apache.hc.client5.http.UnsupportedSchemeException;
import org.apache.hc.client5.http.config.TlsConfig;
import org.apache.hc.client5.http.impl.ConnPoolSupport;
import org.apache.hc.client5.http.impl.DefaultSchemePortResolver;
import org.apache.hc.client5.http.io.DetachedSocketFactory;
import org.apache.hc.client5.http.io.HttpClientConnectionOperator;
import org.apache.hc.client5.http.io.ManagedHttpClientConnection;
import org.apache.hc.client5.http.socket.ConnectionSocketFactory;
import org.apache.hc.client5.http.socket.LayeredConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.TlsSocketStrategy;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.ConnectionClosedException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.URIScheme;
import org.apache.hc.core5.http.config.Lookup;
import org.apache.hc.core5.http.io.SocketConfig;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.io.Closer;
import org.apache.hc.core5.io.SocketSupport;
import org.apache.hc.core5.net.NamedEndpoint;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
@Contract(threading=ThreadingBehavior.STATELESS)
public class DefaultHttpClientConnectionOperator
implements HttpClientConnectionOperator {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultHttpClientConnectionOperator.class);
    static final DetachedSocketFactory PLAIN_SOCKET_FACTORY = proxy -> {
        if (proxy == null) {
            return new Socket();
        }
        return new Socket(proxy);
    };
    private final DetachedSocketFactory detachedSocketFactory;
    private final Lookup<TlsSocketStrategy> tlsSocketStrategyLookup;
    private final SchemePortResolver schemePortResolver;
    private final DnsResolver dnsResolver;

    @Deprecated
    static Lookup<TlsSocketStrategy> adapt(Lookup<ConnectionSocketFactory> lookup) {
        return string -> {
            if ((lookup = (ConnectionSocketFactory)lookup.lookup(string)) instanceof LayeredConnectionSocketFactory) {
                return (arg_0, arg_1, arg_2, arg_3, arg_4) -> DefaultHttpClientConnectionOperator.lambda$null$1((ConnectionSocketFactory)((Object)lookup), arg_0, arg_1, arg_2, arg_3, arg_4);
            }
            return null;
        };
    }

    public DefaultHttpClientConnectionOperator(DetachedSocketFactory detachedSocketFactory, SchemePortResolver schemePortResolver, DnsResolver dnsResolver, Lookup<TlsSocketStrategy> lookup) {
        this.detachedSocketFactory = Args.notNull(detachedSocketFactory, "Plain socket factory");
        this.tlsSocketStrategyLookup = Args.notNull(lookup, "Socket factory registry");
        this.schemePortResolver = schemePortResolver != null ? schemePortResolver : DefaultSchemePortResolver.INSTANCE;
        this.dnsResolver = dnsResolver != null ? dnsResolver : SystemDefaultDnsResolver.INSTANCE;
    }

    @Deprecated
    public DefaultHttpClientConnectionOperator(Lookup<ConnectionSocketFactory> lookup, SchemePortResolver schemePortResolver, DnsResolver dnsResolver) {
        this(PLAIN_SOCKET_FACTORY, schemePortResolver, dnsResolver, DefaultHttpClientConnectionOperator.adapt(lookup));
    }

    public DefaultHttpClientConnectionOperator(SchemePortResolver schemePortResolver, DnsResolver dnsResolver, Lookup<TlsSocketStrategy> lookup) {
        this(PLAIN_SOCKET_FACTORY, schemePortResolver, dnsResolver, lookup);
    }

    @Override
    public void connect(ManagedHttpClientConnection managedHttpClientConnection, HttpHost httpHost, InetSocketAddress inetSocketAddress, TimeValue timeValue, SocketConfig socketConfig, HttpContext httpContext) throws IOException {
        timeValue = timeValue != null ? Timeout.of(timeValue.getDuration(), timeValue.getTimeUnit()) : null;
        this.connect(managedHttpClientConnection, httpHost, null, inetSocketAddress, (Timeout)timeValue, socketConfig, null, httpContext);
    }

    @Override
    public void connect(ManagedHttpClientConnection managedHttpClientConnection, HttpHost httpHost, NamedEndpoint namedEndpoint, InetSocketAddress inetSocketAddress, Timeout timeout, SocketConfig socketConfig, Object object, HttpContext httpContext) throws IOException {
        int n2;
        List<InetSocketAddress> list;
        Args.notNull(managedHttpClientConnection, "Connection");
        Args.notNull(httpHost, "Host");
        Args.notNull(socketConfig, "Socket config");
        Args.notNull(httpContext, "Context");
        Object object2 = socketConfig.getSocksProxyAddress();
        Object object3 = object2 = object2 != null ? new Proxy(Proxy.Type.SOCKS, (SocketAddress)object2) : null;
        if (httpHost.getAddress() != null) {
            list = Collections.singletonList(new InetSocketAddress(httpHost.getAddress(), this.schemePortResolver.resolve(httpHost.getSchemeName(), httpHost)));
        } else {
            n2 = this.schemePortResolver.resolve(httpHost.getSchemeName(), httpHost);
            list = this.dnsResolver.resolve(httpHost.getHostName(), n2);
        }
        for (n2 = 0; n2 < list.size(); ++n2) {
            InetSocketAddress inetSocketAddress2 = list.get(n2);
            boolean bl2 = n2 == list.size() - 1;
            this.onBeforeSocketConnect(httpContext, httpHost);
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} connecting {}->{} ({})", httpHost, inetSocketAddress, inetSocketAddress2, timeout);
            }
            Socket socket = this.detachedSocketFactory.create(httpHost.getSchemeName(), (Proxy)object2);
            try {
                Object object4;
                int n3;
                if (inetSocketAddress != null) {
                    socket.bind(inetSocketAddress);
                }
                managedHttpClientConnection.bind(socket);
                Timeout timeout2 = socketConfig.getSoTimeout();
                if (timeout2 != null) {
                    socket.setSoTimeout(timeout2.toMillisecondsIntBound());
                }
                socket.setReuseAddress(socketConfig.isSoReuseAddress());
                socket.setTcpNoDelay(socketConfig.isTcpNoDelay());
                socket.setKeepAlive(socketConfig.isSoKeepAlive());
                if (socketConfig.getRcvBufSize() > 0) {
                    socket.setReceiveBufferSize(socketConfig.getRcvBufSize());
                }
                if (socketConfig.getSndBufSize() > 0) {
                    socket.setSendBufferSize(socketConfig.getSndBufSize());
                }
                if (socketConfig.getTcpKeepIdle() > 0) {
                    SocketSupport.setOption(socket, "TCP_KEEPIDLE", socketConfig.getTcpKeepIdle());
                }
                if (socketConfig.getTcpKeepInterval() > 0) {
                    SocketSupport.setOption(socket, "TCP_KEEPINTERVAL", socketConfig.getTcpKeepInterval());
                }
                if (socketConfig.getTcpKeepCount() > 0) {
                    SocketSupport.setOption(socket, "TCP_KEEPCOUNT", socketConfig.getTcpKeepCount());
                }
                if ((n3 = socketConfig.getSoLinger().toMillisecondsIntBound()) >= 0) {
                    socket.setSoLinger(true, n3);
                }
                socket.connect(inetSocketAddress2, TimeValue.isPositive(timeout) ? timeout.toMillisecondsIntBound() : 0);
                managedHttpClientConnection.bind(socket);
                this.onAfterSocketConnect(httpContext, httpHost);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} {} connected {}->{}", ConnPoolSupport.getId(managedHttpClientConnection), httpHost, managedHttpClientConnection.getLocalAddress(), managedHttpClientConnection.getRemoteAddress());
                }
                if ((object4 = this.tlsSocketStrategyLookup != null ? this.tlsSocketStrategyLookup.lookup(httpHost.getSchemeName()) : null) != null) {
                    NamedEndpoint namedEndpoint2 = namedEndpoint != null ? namedEndpoint : httpHost;
                    this.onBeforeTlsHandshake(httpContext, httpHost);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("{} {} upgrading to TLS", (Object)ConnPoolSupport.getId(managedHttpClientConnection), (Object)namedEndpoint2);
                    }
                    Object object5 = object instanceof TlsConfig ? (TlsConfig)object : TlsConfig.DEFAULT;
                    int n4 = socket.getSoTimeout();
                    if ((object5 = ((TlsConfig)object5).getHandshakeTimeout() != null ? ((TlsConfig)object5).getHandshakeTimeout() : timeout) != null) {
                        socket.setSoTimeout(((TimeValue)object5).toMillisecondsIntBound());
                    }
                    object4 = object4.upgrade(socket, namedEndpoint2.getHostName(), namedEndpoint2.getPort(), object, httpContext);
                    managedHttpClientConnection.bind((SSLSocket)object4, socket);
                    socket.setSoTimeout(n4);
                    this.onAfterTlsHandshake(httpContext, httpHost);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("{} {} upgraded to TLS", (Object)ConnPoolSupport.getId(managedHttpClientConnection), (Object)namedEndpoint2);
                    }
                }
                return;
            }
            catch (RuntimeException runtimeException) {
                Closer.closeQuietly(socket);
                throw runtimeException;
            }
            catch (IOException iOException) {
                Closer.closeQuietly(socket);
                if (bl2) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("{} connection to {} failed ({}); terminating operation", httpHost, inetSocketAddress2, iOException.getClass());
                    }
                    throw ConnectExceptionSupport.enhance(iOException, httpHost, new InetAddress[0]);
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("{} connection to {} failed ({}); retrying connection to the next address", httpHost, inetSocketAddress2, iOException.getClass());
                continue;
            }
        }
    }

    @Override
    public void upgrade(ManagedHttpClientConnection managedHttpClientConnection, HttpHost httpHost, HttpContext httpContext) throws IOException {
        this.upgrade(managedHttpClientConnection, httpHost, null, null, httpContext);
    }

    @Override
    public void upgrade(ManagedHttpClientConnection managedHttpClientConnection, HttpHost httpHost, NamedEndpoint namedEndpoint, Object object, HttpContext httpContext) throws IOException {
        Socket socket = managedHttpClientConnection.getSocket();
        if (socket == null) {
            throw new ConnectionClosedException("Connection is closed");
        }
        String string = URIScheme.HTTP.same(httpHost.getSchemeName()) ? URIScheme.HTTPS.id : httpHost.getSchemeName();
        TlsSocketStrategy tlsSocketStrategy = this.tlsSocketStrategyLookup != null ? this.tlsSocketStrategyLookup.lookup(string) : null;
        if (tlsSocketStrategy != null) {
            namedEndpoint = namedEndpoint != null ? namedEndpoint : httpHost;
            this.onBeforeTlsHandshake(httpContext, httpHost);
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} upgrading to TLS {}:{}", ConnPoolSupport.getId(managedHttpClientConnection), namedEndpoint.getHostName(), namedEndpoint.getPort());
            }
            object = tlsSocketStrategy.upgrade(socket, namedEndpoint.getHostName(), namedEndpoint.getPort(), object, httpContext);
            managedHttpClientConnection.bind((SSLSocket)object, socket);
            this.onAfterTlsHandshake(httpContext, httpHost);
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} upgraded to TLS {}:{}", ConnPoolSupport.getId(managedHttpClientConnection), namedEndpoint.getHostName(), namedEndpoint.getPort());
            }
            return;
        }
        throw new UnsupportedSchemeException(string + " protocol is not supported");
    }

    protected void onBeforeSocketConnect(HttpContext httpContext, HttpHost httpHost) {
    }

    protected void onAfterSocketConnect(HttpContext httpContext, HttpHost httpHost) {
    }

    protected void onBeforeTlsHandshake(HttpContext httpContext, HttpHost httpHost) {
    }

    protected void onAfterTlsHandshake(HttpContext httpContext, HttpHost httpHost) {
    }

    private static /* synthetic */ SSLSocket lambda$null$1(ConnectionSocketFactory connectionSocketFactory, Socket socket, String string, int n2, Object object, HttpContext httpContext) throws IOException {
        return (SSLSocket)((LayeredConnectionSocketFactory)connectionSocketFactory).createLayeredSocket(socket, string, n2, object, httpContext);
    }
}

