/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.io;

import org.apache.hc.client5.http.impl.io.LenientHttpResponseParser;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpResponseFactory;
import org.apache.hc.core5.http.config.Http1Config;
import org.apache.hc.core5.http.impl.io.DefaultClassicHttpResponseFactory;
import org.apache.hc.core5.http.io.HttpMessageParser;
import org.apache.hc.core5.http.io.HttpMessageParserFactory;
import org.apache.hc.core5.http.message.BasicLineParser;
import org.apache.hc.core5.http.message.LineParser;

@Contract(threading=ThreadingBehavior.STATELESS)
public class DefaultHttpResponseParserFactory
implements HttpMessageParserFactory<ClassicHttpResponse> {
    public static final DefaultHttpResponseParserFactory INSTANCE = new DefaultHttpResponseParserFactory();
    private final Http1Config h1Config;
    private final LineParser lineParser;
    private final HttpResponseFactory<ClassicHttpResponse> responseFactory;

    public DefaultHttpResponseParserFactory(Http1Config http1Config, LineParser lineParser, HttpResponseFactory<ClassicHttpResponse> defaultClassicHttpResponseFactory) {
        this.h1Config = http1Config != null ? http1Config : Http1Config.DEFAULT;
        this.lineParser = lineParser != null ? lineParser : BasicLineParser.INSTANCE;
        this.responseFactory = defaultClassicHttpResponseFactory != null ? defaultClassicHttpResponseFactory : DefaultClassicHttpResponseFactory.INSTANCE;
    }

    public DefaultHttpResponseParserFactory(Http1Config http1Config) {
        this(http1Config, null, null);
    }

    public DefaultHttpResponseParserFactory(LineParser lineParser, HttpResponseFactory<ClassicHttpResponse> httpResponseFactory) {
        this(null, lineParser, httpResponseFactory);
    }

    public DefaultHttpResponseParserFactory(HttpResponseFactory<ClassicHttpResponse> httpResponseFactory) {
        this(null, null, httpResponseFactory);
    }

    public DefaultHttpResponseParserFactory() {
        this(null, null, null);
    }

    @Override
    public HttpMessageParser<ClassicHttpResponse> create() {
        return new LenientHttpResponseParser(this.lineParser, this.responseFactory, this.h1Config);
    }

    @Override
    @Deprecated
    public HttpMessageParser<ClassicHttpResponse> create(Http1Config http1Config) {
        return new LenientHttpResponseParser(this.lineParser, this.responseFactory, http1Config);
    }
}

