/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.io;

import java.io.IOException;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpResponseFactory;
import org.apache.hc.core5.http.config.Http1Config;
import org.apache.hc.core5.http.impl.io.DefaultHttpResponseParser;
import org.apache.hc.core5.http.message.LineParser;
import org.apache.hc.core5.util.CharArrayBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LenientHttpResponseParser
extends DefaultHttpResponseParser {
    private static final Logger LOG = LoggerFactory.getLogger(LenientHttpResponseParser.class);

    public LenientHttpResponseParser(LineParser lineParser, HttpResponseFactory<ClassicHttpResponse> httpResponseFactory, Http1Config http1Config) {
        super(http1Config, lineParser, httpResponseFactory);
    }

    public LenientHttpResponseParser(Http1Config http1Config) {
        this(null, null, http1Config);
    }

    @Override
    protected ClassicHttpResponse createMessage(CharArrayBuffer charArrayBuffer) throws IOException {
        try {
            return super.createMessage(charArrayBuffer);
        }
        catch (HttpException httpException) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Garbage in response: {}", (Object)charArrayBuffer);
            }
            return null;
        }
    }
}

