/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.io;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.hc.client5.http.impl.Wire;

class LoggingOutputStream
extends OutputStream {
    private final OutputStream out;
    private final Wire wire;

    public LoggingOutputStream(OutputStream outputStream, Wire wire) {
        this.out = outputStream;
        this.wire = wire;
    }

    @Override
    public void write(int n2) throws IOException {
        try {
            this.out.write(n2);
            this.wire.output(n2);
            return;
        }
        catch (IOException iOException) {
            this.wire.output("[write] I/O error: " + iOException.getMessage());
            throw iOException;
        }
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        try {
            this.wire.output(byArray);
            this.out.write(byArray);
            return;
        }
        catch (IOException iOException) {
            this.wire.output("[write] I/O error: " + iOException.getMessage());
            throw iOException;
        }
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) throws IOException {
        try {
            this.wire.output(byArray, n2, n3);
            this.out.write(byArray, n2, n3);
            return;
        }
        catch (IOException iOException) {
            this.wire.output("[write] I/O error: " + iOException.getMessage());
            throw iOException;
        }
    }

    @Override
    public void flush() throws IOException {
        try {
            this.out.flush();
            return;
        }
        catch (IOException iOException) {
            this.wire.output("[flush] I/O error: " + iOException.getMessage());
            throw iOException;
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.out.close();
            return;
        }
        catch (IOException iOException) {
            this.wire.output("[close] I/O error: " + iOException.getMessage());
            throw iOException;
        }
    }
}

