/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.nio;

import java.io.IOException;
import java.net.SocketAddress;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import org.apache.hc.client5.http.nio.ManagedAsyncClientConnection;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.EndpointDetails;
import org.apache.hc.core5.http.HttpConnection;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.nio.command.ShutdownCommand;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.net.NamedEndpoint;
import org.apache.hc.core5.reactor.Command;
import org.apache.hc.core5.reactor.Command$Priority;
import org.apache.hc.core5.reactor.IOEventHandler;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.reactor.ProtocolIOSession;
import org.apache.hc.core5.reactor.ssl.SSLBufferMode;
import org.apache.hc.core5.reactor.ssl.SSLSessionInitializer;
import org.apache.hc.core5.reactor.ssl.SSLSessionVerifier;
import org.apache.hc.core5.reactor.ssl.TlsDetails;
import org.apache.hc.core5.reactor.ssl.TransportSecurityLayer;
import org.apache.hc.core5.util.Identifiable;
import org.apache.hc.core5.util.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DefaultManagedAsyncClientConnection
implements ManagedAsyncClientConnection,
Identifiable {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultManagedAsyncClientConnection.class);
    private final IOSession ioSession;
    private final Timeout socketTimeout;
    private final AtomicBoolean closed;

    public DefaultManagedAsyncClientConnection(IOSession iOSession) {
        this.ioSession = iOSession;
        this.socketTimeout = iOSession.getSocketTimeout();
        this.closed = new AtomicBoolean();
    }

    @Override
    public final String getId() {
        return this.ioSession.getId();
    }

    @Override
    public final void close(CloseMode closeMode) {
        if (this.closed.compareAndSet(false, true)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} Shutdown connection {}", (Object)this.getId(), (Object)closeMode);
            }
            this.ioSession.close(closeMode);
        }
    }

    @Override
    public final void close() throws IOException {
        if (this.closed.compareAndSet(false, true)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} Close connection", (Object)this.getId());
            }
            this.ioSession.enqueue(new ShutdownCommand(CloseMode.GRACEFUL), Command$Priority.IMMEDIATE);
        }
    }

    @Override
    public final boolean isOpen() {
        Object object = this.ioSession;
        if (object.isOpen()) {
            if ((object = object.getHandler()) instanceof HttpConnection) {
                return ((HttpConnection)object).isOpen();
            }
            return true;
        }
        return false;
    }

    @Override
    public final void setSocketTimeout(Timeout timeout) {
        this.ioSession.setSocketTimeout(timeout);
    }

    @Override
    public final Timeout getSocketTimeout() {
        return this.ioSession.getSocketTimeout();
    }

    @Override
    public final SocketAddress getRemoteAddress() {
        return this.ioSession.getRemoteAddress();
    }

    @Override
    public final SocketAddress getLocalAddress() {
        return this.ioSession.getLocalAddress();
    }

    @Override
    public final EndpointDetails getEndpointDetails() {
        IOEventHandler iOEventHandler = this.ioSession.getHandler();
        if (iOEventHandler instanceof HttpConnection) {
            return ((HttpConnection)((Object)iOEventHandler)).getEndpointDetails();
        }
        return null;
    }

    @Override
    public final ProtocolVersion getProtocolVersion() {
        Object object = this.ioSession.getHandler();
        if (object instanceof HttpConnection && (object = ((HttpConnection)object).getProtocolVersion()) != null) {
            return object;
        }
        return HttpVersion.DEFAULT;
    }

    @Override
    public final void startTls(SSLContext sSLContext, NamedEndpoint namedEndpoint, SSLBufferMode sSLBufferMode, SSLSessionInitializer sSLSessionInitializer, SSLSessionVerifier sSLSessionVerifier, Timeout timeout, FutureCallback<TransportSecurityLayer> futureCallback) throws UnsupportedOperationException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} start TLS", (Object)this.getId());
        }
        if (this.ioSession instanceof TransportSecurityLayer) {
            ((TransportSecurityLayer)((Object)this.ioSession)).startTls(sSLContext, namedEndpoint, sSLBufferMode, sSLSessionInitializer, sSLSessionVerifier, timeout, futureCallback);
            return;
        }
        throw new UnsupportedOperationException("TLS upgrade not supported");
    }

    @Override
    public final void startTls(SSLContext sSLContext, NamedEndpoint namedEndpoint, SSLBufferMode sSLBufferMode, SSLSessionInitializer sSLSessionInitializer, SSLSessionVerifier sSLSessionVerifier, Timeout timeout) throws UnsupportedOperationException {
        this.startTls(sSLContext, namedEndpoint, sSLBufferMode, sSLSessionInitializer, sSLSessionVerifier, timeout, null);
    }

    @Override
    public final TlsDetails getTlsDetails() {
        if (this.ioSession instanceof TransportSecurityLayer) {
            return ((TransportSecurityLayer)((Object)this.ioSession)).getTlsDetails();
        }
        return null;
    }

    @Override
    public final SSLSession getSSLSession() {
        TlsDetails tlsDetails = this.getTlsDetails();
        if (tlsDetails != null) {
            return tlsDetails.getSSLSession();
        }
        return null;
    }

    @Override
    public final void submitCommand(Command command, Command$Priority command$Priority) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} {} with {} priority", new Object[]{this.getId(), command.getClass().getSimpleName(), command$Priority});
        }
        this.ioSession.enqueue(command, Command$Priority.IMMEDIATE);
    }

    @Override
    public final void passivate() {
        this.ioSession.setSocketTimeout(Timeout.ZERO_MILLISECONDS);
    }

    @Override
    public final void activate() {
        this.ioSession.setSocketTimeout(this.socketTimeout);
    }

    @Override
    public final void switchProtocol(String string, FutureCallback<ProtocolIOSession> futureCallback) throws UnsupportedOperationException {
        if (this.ioSession instanceof ProtocolIOSession) {
            ((ProtocolIOSession)this.ioSession).switchProtocol(string, futureCallback);
            return;
        }
        throw new UnsupportedOperationException("Protocol switch not supported");
    }
}

