/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.nio;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiFunction;
import org.apache.hc.core5.http.HttpConnection;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.pool.PoolEntry;

class H2SharingConnPool$PerRoutePool<T, C extends HttpConnection> {
    private final Map<PoolEntry<T, C>, AtomicLong> entryMap = new HashMap<PoolEntry<T, C>, AtomicLong>();
    private final Lock lock = new ReentrantLock();

    H2SharingConnPool$PerRoutePool() {
    }

    AtomicLong getCounter(PoolEntry<T, C> poolEntry2) {
        return this.entryMap.computeIfAbsent(poolEntry2, poolEntry -> new AtomicLong());
    }

    long track(PoolEntry<T, C> object) {
        this.lock.lock();
        try {
            object = this.getCounter((PoolEntry<T, C>)object);
            long l2 = ((AtomicLong)object).incrementAndGet();
            return l2;
        }
        finally {
            this.lock.unlock();
        }
    }

    PoolEntry<T, C> lease() {
        this.lock.lock();
        try {
            PoolEntry poolEntry = this.entryMap.entrySet().stream().filter(object -> (object = (HttpConnection)((PoolEntry)object.getKey()).getConnection()) != null && object.isOpen()).min(Comparator.comparingLong(entry -> ((AtomicLong)entry.getValue()).get())).map(entry -> {
                ((AtomicLong)entry.getValue()).incrementAndGet();
                return (PoolEntry)entry.getKey();
            }).orElse(null);
            return poolEntry;
        }
        finally {
            this.lock.unlock();
        }
    }

    long release(PoolEntry<T, C> object, boolean bl2) {
        this.lock.lock();
        try {
            if (!bl2) {
                ((PoolEntry)object).discardConnection(CloseMode.GRACEFUL);
            }
            long l2 = (object = this.entryMap.compute((PoolEntry<T, C>)object, (BiFunction<PoolEntry<T, C>, AtomicLong, AtomicLong>)((BiFunction<PoolEntry, AtomicLong, AtomicLong>)(poolEntry, atomicLong) -> {
                if (atomicLong == null) {
                    return null;
                }
                long l2 = atomicLong.decrementAndGet();
                if (l2 > 0L) {
                    return atomicLong;
                }
                return null;
            }))) != null ? ((AtomicLong)object).get() : 0L;
            return l2;
        }
        finally {
            this.lock.unlock();
        }
    }

    long getCount(PoolEntry<T, C> object) {
        this.lock.lock();
        try {
            object = this.entryMap.get(object);
            long l2 = object == null ? 0L : ((AtomicLong)object).get();
            return l2;
        }
        finally {
            this.lock.unlock();
        }
    }
}

