/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.nio;

import java.io.IOException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hc.client5.http.impl.ConnPoolSupport;
import org.apache.hc.client5.http.impl.nio.H2SharingConnPool$1;
import org.apache.hc.client5.http.impl.nio.H2SharingConnPool$PerRoutePool;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.Experimental;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.concurrent.CompletedFuture;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.HttpConnection;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.pool.ManagedConnPool;
import org.apache.hc.core5.pool.PoolEntry;
import org.apache.hc.core5.pool.PoolStats;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.Asserts;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Contract(threading=ThreadingBehavior.SAFE)
@Experimental
public class H2SharingConnPool<T, C extends HttpConnection>
implements ManagedConnPool<T, C> {
    private static final Logger LOG = LoggerFactory.getLogger(H2SharingConnPool.class);
    private final ManagedConnPool<T, C> pool;
    private final ConcurrentMap<T, H2SharingConnPool$PerRoutePool<T, C>> perRouteCache;
    private final AtomicBoolean closed;

    public H2SharingConnPool(ManagedConnPool<T, C> managedConnPool) {
        this.pool = Args.notNull(managedConnPool, "Connection pool");
        this.perRouteCache = new ConcurrentHashMap<T, H2SharingConnPool$PerRoutePool<T, C>>();
        this.closed = new AtomicBoolean();
    }

    @Override
    public void close(CloseMode closeMode) {
        if (this.closed.compareAndSet(false, true)) {
            this.perRouteCache.clear();
            this.pool.close(closeMode);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.closed.compareAndSet(false, true)) {
            this.perRouteCache.clear();
            this.pool.close();
        }
    }

    H2SharingConnPool$PerRoutePool<T, C> getPerRoutePool(T t2) {
        return this.perRouteCache.computeIfAbsent(t2, object -> new H2SharingConnPool$PerRoutePool());
    }

    @Override
    public Future<PoolEntry<T, C>> lease(T object, Object object2, Timeout timeout, FutureCallback<PoolEntry<T, C>> futureCallback) {
        PoolEntry poolEntry;
        H2SharingConnPool$PerRoutePool h2SharingConnPool$PerRoutePool;
        Asserts.check(!this.closed.get(), "Connection pool shut down");
        if (object2 == null && (h2SharingConnPool$PerRoutePool = (H2SharingConnPool$PerRoutePool)this.perRouteCache.get(object)) != null && (poolEntry = h2SharingConnPool$PerRoutePool.lease()) != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Sharing connection {} for message exchange multiplexing (lease count = {})", (Object)ConnPoolSupport.getId(poolEntry.getConnection()), (Object)h2SharingConnPool$PerRoutePool.getCount(poolEntry));
            }
            object = new CompletedFuture(poolEntry);
            if (futureCallback != null) {
                futureCallback.completed(poolEntry);
            }
            return object;
        }
        LOG.debug("No shared connection available");
        return this.pool.lease(object, object2, timeout, new H2SharingConnPool$1(this, futureCallback, object2, object, futureCallback));
    }

    @Override
    public void release(PoolEntry<T, C> poolEntry, boolean bl2) {
        long l2;
        if (poolEntry == null) {
            return;
        }
        if (this.closed.get()) {
            this.pool.release(poolEntry, bl2);
            return;
        }
        Object object = poolEntry.getRoute();
        if ((object = (H2SharingConnPool$PerRoutePool)this.perRouteCache.get(object)) != null && (l2 = ((H2SharingConnPool$PerRoutePool)object).release(poolEntry, bl2)) > 0L) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Connection {} is being shared for message exchange multiplexing (lease count = {})", (Object)ConnPoolSupport.getId(poolEntry.getConnection()), (Object)l2);
            }
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Releasing connection {} back to the pool", (Object)ConnPoolSupport.getId(poolEntry.getConnection()));
        }
        this.pool.release(poolEntry, bl2);
    }

    @Override
    public void setMaxTotal(int n2) {
        this.pool.setMaxTotal(n2);
    }

    @Override
    public int getMaxTotal() {
        return this.pool.getMaxTotal();
    }

    @Override
    public void setDefaultMaxPerRoute(int n2) {
        this.pool.setDefaultMaxPerRoute(n2);
    }

    @Override
    public int getDefaultMaxPerRoute() {
        return this.pool.getDefaultMaxPerRoute();
    }

    @Override
    public void setMaxPerRoute(T t2, int n2) {
        this.pool.setMaxPerRoute(t2, n2);
    }

    @Override
    public int getMaxPerRoute(T t2) {
        return this.pool.getMaxPerRoute(t2);
    }

    @Override
    public void closeIdle(TimeValue timeValue) {
        this.pool.closeIdle(timeValue);
    }

    @Override
    public void closeExpired() {
        this.pool.closeExpired();
    }

    @Override
    public Set<T> getRoutes() {
        return this.pool.getRoutes();
    }

    @Override
    public PoolStats getTotalStats() {
        return this.pool.getTotalStats();
    }

    @Override
    public PoolStats getStats(T t2) {
        return this.pool.getStats(t2);
    }

    public String toString() {
        return this.pool.toString();
    }

    static /* synthetic */ Logger access$000() {
        return LOG;
    }
}

