/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.nio;

import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hc.client5.http.DnsResolver;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.SchemePortResolver;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.config.TlsConfig;
import org.apache.hc.client5.http.impl.ConnPoolSupport;
import org.apache.hc.client5.http.impl.PrefixedIncrementingId;
import org.apache.hc.client5.http.impl.nio.DefaultAsyncClientConnectionOperator;
import org.apache.hc.client5.http.impl.nio.H2SharingConnPool;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManager$1;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManager$2;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManager$3;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManager$4;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManager$5;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManager$InternalConnectionEndpoint;
import org.apache.hc.client5.http.nio.AsyncClientConnectionManager;
import org.apache.hc.client5.http.nio.AsyncClientConnectionOperator;
import org.apache.hc.client5.http.nio.AsyncConnectionEndpoint;
import org.apache.hc.client5.http.nio.ManagedAsyncClientConnection;
import org.apache.hc.client5.http.ssl.DefaultClientTlsStrategy;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.concurrent.BasicFuture;
import org.apache.hc.core5.concurrent.ComplexFuture;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.function.Resolver;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.URIScheme;
import org.apache.hc.core5.http.config.Lookup;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http2.HttpVersionPolicy;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.pool.ConnPoolControl;
import org.apache.hc.core5.pool.DefaultDisposalCallback;
import org.apache.hc.core5.pool.ManagedConnPool;
import org.apache.hc.core5.pool.PoolConcurrencyPolicy;
import org.apache.hc.core5.pool.PoolEntry;
import org.apache.hc.core5.pool.PoolReusePolicy;
import org.apache.hc.core5.pool.PoolStats;
import org.apache.hc.core5.reactor.ConnectionInitiator;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.Deadline;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Contract(threading=ThreadingBehavior.SAFE_CONDITIONAL)
public class PoolingAsyncClientConnectionManager
implements AsyncClientConnectionManager,
ConnPoolControl<HttpRoute> {
    private static final Logger LOG = LoggerFactory.getLogger(PoolingAsyncClientConnectionManager.class);
    public static final int DEFAULT_MAX_TOTAL_CONNECTIONS = 25;
    public static final int DEFAULT_MAX_CONNECTIONS_PER_ROUTE = 5;
    private final ManagedConnPool<HttpRoute, ManagedAsyncClientConnection> pool;
    private final AsyncClientConnectionOperator connectionOperator;
    private final AtomicBoolean closed;
    private volatile Resolver<HttpRoute, ConnectionConfig> connectionConfigResolver;
    private volatile Resolver<HttpHost, TlsConfig> tlsConfigResolver;
    private static final PrefixedIncrementingId INCREMENTING_ID = new PrefixedIncrementingId("ep-");

    public PoolingAsyncClientConnectionManager() {
        this(RegistryBuilder.create().register(URIScheme.HTTPS.getId(), DefaultClientTlsStrategy.createDefault()).build());
    }

    public PoolingAsyncClientConnectionManager(Lookup<TlsStrategy> lookup) {
        this(lookup, PoolConcurrencyPolicy.STRICT, TimeValue.NEG_ONE_MILLISECOND);
    }

    public PoolingAsyncClientConnectionManager(Lookup<TlsStrategy> lookup, PoolConcurrencyPolicy poolConcurrencyPolicy, TimeValue timeValue) {
        this(lookup, poolConcurrencyPolicy, PoolReusePolicy.LIFO, timeValue);
    }

    public PoolingAsyncClientConnectionManager(Lookup<TlsStrategy> lookup, PoolConcurrencyPolicy poolConcurrencyPolicy, PoolReusePolicy poolReusePolicy, TimeValue timeValue) {
        this(lookup, poolConcurrencyPolicy, poolReusePolicy, timeValue, null, null);
    }

    public PoolingAsyncClientConnectionManager(Lookup<TlsStrategy> lookup, PoolConcurrencyPolicy poolConcurrencyPolicy, PoolReusePolicy poolReusePolicy, TimeValue timeValue, SchemePortResolver schemePortResolver, DnsResolver dnsResolver) {
        this(new DefaultAsyncClientConnectionOperator(lookup, schemePortResolver, dnsResolver), poolConcurrencyPolicy, poolReusePolicy, timeValue, false);
    }

    @Internal
    public PoolingAsyncClientConnectionManager(AsyncClientConnectionOperator object, PoolConcurrencyPolicy poolConcurrencyPolicy, PoolReusePolicy poolReusePolicy, TimeValue timeValue, boolean bl2) {
        this.connectionOperator = Args.notNull(object, "Connection operator");
        switch (poolConcurrencyPolicy != null ? poolConcurrencyPolicy : PoolConcurrencyPolicy.STRICT) {
            case STRICT: {
                object = new PoolingAsyncClientConnectionManager$1(this, 5, 25, timeValue, poolReusePolicy, new DefaultDisposalCallback(), null);
                break;
            }
            case LAX: {
                object = new PoolingAsyncClientConnectionManager$2(this, 5, timeValue, poolReusePolicy, null);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected PoolConcurrencyPolicy value: " + (Object)((Object)poolConcurrencyPolicy));
            }
        }
        this.pool = bl2 ? new H2SharingConnPool(object) : object;
        this.closed = new AtomicBoolean(false);
    }

    @Internal
    protected PoolingAsyncClientConnectionManager(ManagedConnPool<HttpRoute, ManagedAsyncClientConnection> managedConnPool, AsyncClientConnectionOperator asyncClientConnectionOperator) {
        this.connectionOperator = Args.notNull(asyncClientConnectionOperator, "Connection operator");
        this.pool = Args.notNull(managedConnPool, "Connection pool");
        this.closed = new AtomicBoolean(false);
    }

    @Override
    public void close() {
        this.close(CloseMode.GRACEFUL);
    }

    @Override
    public void close(CloseMode closeMode) {
        if (this.closed.compareAndSet(false, true)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Shutdown connection pool {}", (Object)closeMode);
            }
            this.pool.close(closeMode);
            LOG.debug("Connection pool shut down");
        }
    }

    private PoolingAsyncClientConnectionManager$InternalConnectionEndpoint cast(AsyncConnectionEndpoint asyncConnectionEndpoint) {
        if (asyncConnectionEndpoint instanceof PoolingAsyncClientConnectionManager$InternalConnectionEndpoint) {
            return (PoolingAsyncClientConnectionManager$InternalConnectionEndpoint)asyncConnectionEndpoint;
        }
        throw new IllegalStateException("Unexpected endpoint class: " + asyncConnectionEndpoint.getClass());
    }

    private ConnectionConfig resolveConnectionConfig(HttpRoute cloneable) {
        Resolver<HttpRoute, ConnectionConfig> resolver = this.connectionConfigResolver;
        cloneable = resolver != null ? resolver.resolve((HttpRoute)cloneable) : null;
        if (cloneable != null) {
            return cloneable;
        }
        return ConnectionConfig.DEFAULT;
    }

    private TlsConfig resolveTlsConfig(HttpHost httpHost) {
        Resolver<HttpHost, TlsConfig> resolver = this.tlsConfigResolver;
        resolver = resolver != null ? resolver.resolve(httpHost) : null;
        if (resolver == null) {
            resolver = TlsConfig.DEFAULT;
        }
        if (URIScheme.HTTP.same(httpHost.getSchemeName()) && ((TlsConfig)((Object)resolver)).getHttpVersionPolicy() == HttpVersionPolicy.NEGOTIATE) {
            resolver = TlsConfig.copy((TlsConfig)((Object)resolver)).setVersionPolicy(HttpVersionPolicy.FORCE_HTTP_1).build();
        }
        return resolver;
    }

    @Override
    public Future<AsyncConnectionEndpoint> lease(String string, HttpRoute httpRoute, Object object, Timeout timeout, FutureCallback<AsyncConnectionEndpoint> futureCallback) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} endpoint lease request ({}) {}", string, timeout, ConnPoolSupport.formatStats(httpRoute, object, this.pool));
        }
        return new PoolingAsyncClientConnectionManager$3(this, httpRoute, futureCallback, object, timeout, string);
    }

    @Override
    public void release(AsyncConnectionEndpoint asyncConnectionEndpoint, Object object, TimeValue timeValue) {
        boolean bl2;
        PoolEntry<HttpRoute, ManagedAsyncClientConnection> poolEntry;
        block9: {
            Args.notNull(asyncConnectionEndpoint, "Managed endpoint");
            Args.notNull(timeValue, "Keep-alive time");
            poolEntry = this.cast(asyncConnectionEndpoint).detach();
            if (poolEntry == null) {
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} releasing endpoint", (Object)ConnPoolSupport.getId(asyncConnectionEndpoint));
            }
            if (this.isClosed()) {
                return;
            }
            ManagedAsyncClientConnection managedAsyncClientConnection = poolEntry.getConnection();
            bl2 = managedAsyncClientConnection != null && managedAsyncClientConnection.isOpen();
            try {
                if (!bl2) break block9;
                poolEntry.updateState(object);
                poolEntry.updateExpiry(timeValue);
                managedAsyncClientConnection.passivate();
                if (!LOG.isDebugEnabled()) break block9;
                object = TimeValue.isPositive(timeValue) ? "for " + timeValue : "indefinitely";
                LOG.debug("{} connection {} can be kept alive {}", ConnPoolSupport.getId(asyncConnectionEndpoint), ConnPoolSupport.getId(managedAsyncClientConnection), object);
            }
            catch (RuntimeException runtimeException) {
                try {
                    bl2 = false;
                    throw runtimeException;
                }
                catch (Throwable throwable) {
                    this.pool.release(poolEntry, bl2);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("{} connection released {}", (Object)ConnPoolSupport.getId(asyncConnectionEndpoint), (Object)ConnPoolSupport.formatStats(poolEntry.getRoute(), poolEntry.getState(), this.pool));
                    }
                    throw throwable;
                }
            }
        }
        this.pool.release(poolEntry, bl2);
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} connection released {}", (Object)ConnPoolSupport.getId(asyncConnectionEndpoint), (Object)ConnPoolSupport.formatStats(poolEntry.getRoute(), poolEntry.getState(), this.pool));
            return;
        }
    }

    @Override
    public Future<AsyncConnectionEndpoint> connect(AsyncConnectionEndpoint object, ConnectionInitiator connectionInitiator, Timeout timeout, Object object2, HttpContext httpContext, FutureCallback<AsyncConnectionEndpoint> object3) {
        Args.notNull(object, "Endpoint");
        Args.notNull(connectionInitiator, "Connection initiator");
        object2 = this.cast((AsyncConnectionEndpoint)object);
        object3 = new ComplexFuture<AsyncConnectionEndpoint>((FutureCallback<AsyncConnectionEndpoint>)object3);
        if (((AsyncConnectionEndpoint)object2).isConnected()) {
            ((BasicFuture)object3).completed(object);
            return object3;
        }
        PoolEntry<HttpRoute, ManagedAsyncClientConnection> poolEntry = ((PoolingAsyncClientConnectionManager$InternalConnectionEndpoint)object2).getPoolEntry();
        HttpRoute httpRoute = poolEntry.getRoute();
        HttpHost httpHost = httpRoute.getProxyHost() != null ? httpRoute.getProxyHost() : httpRoute.getTargetHost();
        ConnectionConfig connectionConfig = this.resolveConnectionConfig(httpRoute);
        Timeout timeout2 = timeout = timeout != null ? timeout : connectionConfig.getConnectTimeout();
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} connecting endpoint to {} ({})", ConnPoolSupport.getId(object), httpHost, timeout);
        }
        object = this.connectionOperator.connect(connectionInitiator, httpHost, httpRoute.getTargetName(), httpRoute.getLocalSocketAddress(), timeout, httpRoute.isTunnelled() ? null : this.resolveTlsConfig(httpRoute.getTargetHost()), httpContext, new PoolingAsyncClientConnectionManager$4(this, (AsyncConnectionEndpoint)object, connectionConfig, poolEntry, (ComplexFuture)object3, (PoolingAsyncClientConnectionManager$InternalConnectionEndpoint)object2));
        ((ComplexFuture)object3).setDependency((Future<?>)object);
        return object3;
    }

    @Override
    public void upgrade(AsyncConnectionEndpoint asyncConnectionEndpoint, Object object, HttpContext httpContext, FutureCallback<AsyncConnectionEndpoint> futureCallback) {
        Args.notNull(asyncConnectionEndpoint, "Managed endpoint");
        PoolingAsyncClientConnectionManager$InternalConnectionEndpoint poolingAsyncClientConnectionManager$InternalConnectionEndpoint = this.cast(asyncConnectionEndpoint);
        PoolEntry<HttpRoute, ManagedAsyncClientConnection> poolEntry = poolingAsyncClientConnectionManager$InternalConnectionEndpoint.getValidatedPoolEntry();
        HttpRoute httpRoute = poolEntry.getRoute();
        HttpHost httpHost = httpRoute.getTargetHost();
        this.connectionOperator.upgrade(poolEntry.getConnection(), httpHost, httpRoute.getTargetName(), object != null ? object : this.resolveTlsConfig(httpHost), httpContext, new PoolingAsyncClientConnectionManager$5(this, futureCallback, poolingAsyncClientConnectionManager$InternalConnectionEndpoint, futureCallback, asyncConnectionEndpoint));
    }

    @Override
    public void upgrade(AsyncConnectionEndpoint asyncConnectionEndpoint, Object object, HttpContext httpContext) {
        this.upgrade(asyncConnectionEndpoint, object, httpContext, null);
    }

    @Override
    public Set<HttpRoute> getRoutes() {
        return this.pool.getRoutes();
    }

    @Override
    public void setMaxTotal(int n2) {
        this.pool.setMaxTotal(n2);
    }

    @Override
    public int getMaxTotal() {
        return this.pool.getMaxTotal();
    }

    @Override
    public void setDefaultMaxPerRoute(int n2) {
        this.pool.setDefaultMaxPerRoute(n2);
    }

    @Override
    public int getDefaultMaxPerRoute() {
        return this.pool.getDefaultMaxPerRoute();
    }

    @Override
    public void setMaxPerRoute(HttpRoute httpRoute, int n2) {
        this.pool.setMaxPerRoute(httpRoute, n2);
    }

    @Override
    public int getMaxPerRoute(HttpRoute httpRoute) {
        return this.pool.getMaxPerRoute(httpRoute);
    }

    @Override
    public void closeIdle(TimeValue timeValue) {
        if (this.isClosed()) {
            return;
        }
        this.pool.closeIdle(timeValue);
    }

    @Override
    public void closeExpired() {
        if (this.isClosed()) {
            return;
        }
        this.pool.closeExpired();
    }

    @Override
    public PoolStats getTotalStats() {
        return this.pool.getTotalStats();
    }

    @Override
    public PoolStats getStats(HttpRoute httpRoute) {
        return this.pool.getStats(httpRoute);
    }

    public void setDefaultConnectionConfig(ConnectionConfig connectionConfig) {
        this.connectionConfigResolver = httpRoute -> connectionConfig;
    }

    public void setConnectionConfigResolver(Resolver<HttpRoute, ConnectionConfig> resolver) {
        this.connectionConfigResolver = resolver;
    }

    public void setDefaultTlsConfig(TlsConfig tlsConfig) {
        this.tlsConfigResolver = httpHost -> tlsConfig;
    }

    public void setTlsConfigResolver(Resolver<HttpHost, TlsConfig> resolver) {
        this.tlsConfigResolver = resolver;
    }

    void closeIfExpired(PoolEntry<HttpRoute, ManagedAsyncClientConnection> poolEntry) {
        long l2 = System.currentTimeMillis();
        if (poolEntry.getExpiryDeadline().isBefore(l2)) {
            poolEntry.discardConnection(CloseMode.GRACEFUL);
            return;
        }
        Object object = this.resolveConnectionConfig(poolEntry.getRoute());
        if ((object = ((ConnectionConfig)object).getTimeToLive()) != null && Deadline.calculate(poolEntry.getCreated(), (TimeValue)object).isBefore(l2)) {
            poolEntry.discardConnection(CloseMode.GRACEFUL);
        }
    }

    @Deprecated
    public TimeValue getValidateAfterInactivity() {
        return ConnectionConfig.DEFAULT.getValidateAfterInactivity();
    }

    @Deprecated
    public void setValidateAfterInactivity(TimeValue timeValue) {
        this.setDefaultConnectionConfig(ConnectionConfig.custom().setValidateAfterInactivity(timeValue).build());
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    static /* synthetic */ ConnectionConfig access$000(PoolingAsyncClientConnectionManager poolingAsyncClientConnectionManager, HttpRoute httpRoute) {
        return poolingAsyncClientConnectionManager.resolveConnectionConfig(httpRoute);
    }

    static /* synthetic */ Logger access$100() {
        return LOG;
    }

    static /* synthetic */ ManagedConnPool access$200(PoolingAsyncClientConnectionManager poolingAsyncClientConnectionManager) {
        return poolingAsyncClientConnectionManager.pool;
    }

    static /* synthetic */ PrefixedIncrementingId access$300() {
        return INCREMENTING_ID;
    }
}

