/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.nio;

import org.apache.hc.client5.http.DnsResolver;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.SchemePortResolver;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.config.TlsConfig;
import org.apache.hc.client5.http.impl.nio.DefaultAsyncClientConnectionOperator;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManager;
import org.apache.hc.client5.http.nio.AsyncClientConnectionOperator;
import org.apache.hc.client5.http.ssl.ConscryptClientTlsStrategy;
import org.apache.hc.client5.http.ssl.DefaultClientTlsStrategy;
import org.apache.hc.core5.annotation.Experimental;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.function.Resolver;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.URIScheme;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import org.apache.hc.core5.pool.PoolConcurrencyPolicy;
import org.apache.hc.core5.pool.PoolReusePolicy;
import org.apache.hc.core5.util.ReflectionUtils;
import org.apache.hc.core5.util.TimeValue;

public class PoolingAsyncClientConnectionManagerBuilder {
    private TlsStrategy tlsStrategy;
    private SchemePortResolver schemePortResolver;
    private DnsResolver dnsResolver;
    private PoolConcurrencyPolicy poolConcurrencyPolicy;
    private PoolReusePolicy poolReusePolicy;
    private boolean systemProperties;
    private int maxConnTotal;
    private int maxConnPerRoute;
    private Resolver<HttpRoute, ConnectionConfig> connectionConfigResolver;
    private Resolver<HttpHost, TlsConfig> tlsConfigResolver;
    private boolean messageMultiplexing;

    public static PoolingAsyncClientConnectionManagerBuilder create() {
        return new PoolingAsyncClientConnectionManagerBuilder();
    }

    @Internal
    protected PoolingAsyncClientConnectionManagerBuilder() {
    }

    public final PoolingAsyncClientConnectionManagerBuilder setTlsStrategy(TlsStrategy tlsStrategy) {
        this.tlsStrategy = tlsStrategy;
        return this;
    }

    public final PoolingAsyncClientConnectionManagerBuilder setDnsResolver(DnsResolver dnsResolver) {
        this.dnsResolver = dnsResolver;
        return this;
    }

    public final PoolingAsyncClientConnectionManagerBuilder setSchemePortResolver(SchemePortResolver schemePortResolver) {
        this.schemePortResolver = schemePortResolver;
        return this;
    }

    public final PoolingAsyncClientConnectionManagerBuilder setPoolConcurrencyPolicy(PoolConcurrencyPolicy poolConcurrencyPolicy) {
        this.poolConcurrencyPolicy = poolConcurrencyPolicy;
        return this;
    }

    public final PoolingAsyncClientConnectionManagerBuilder setConnPoolPolicy(PoolReusePolicy poolReusePolicy) {
        this.poolReusePolicy = poolReusePolicy;
        return this;
    }

    public final PoolingAsyncClientConnectionManagerBuilder setMaxConnTotal(int n2) {
        this.maxConnTotal = n2;
        return this;
    }

    public final PoolingAsyncClientConnectionManagerBuilder setMaxConnPerRoute(int n2) {
        this.maxConnPerRoute = n2;
        return this;
    }

    public final PoolingAsyncClientConnectionManagerBuilder setDefaultConnectionConfig(ConnectionConfig connectionConfig) {
        this.connectionConfigResolver = httpRoute -> connectionConfig;
        return this;
    }

    public final PoolingAsyncClientConnectionManagerBuilder setConnectionConfigResolver(Resolver<HttpRoute, ConnectionConfig> resolver) {
        this.connectionConfigResolver = resolver;
        return this;
    }

    public final PoolingAsyncClientConnectionManagerBuilder setDefaultTlsConfig(TlsConfig tlsConfig) {
        this.tlsConfigResolver = httpHost -> tlsConfig;
        return this;
    }

    public final PoolingAsyncClientConnectionManagerBuilder setTlsConfigResolver(Resolver<HttpHost, TlsConfig> resolver) {
        this.tlsConfigResolver = resolver;
        return this;
    }

    @Deprecated
    public final PoolingAsyncClientConnectionManagerBuilder setConnectionTimeToLive(TimeValue timeValue) {
        this.setDefaultConnectionConfig(ConnectionConfig.custom().setTimeToLive(timeValue).build());
        return this;
    }

    @Deprecated
    public final PoolingAsyncClientConnectionManagerBuilder setValidateAfterInactivity(TimeValue timeValue) {
        this.setDefaultConnectionConfig(ConnectionConfig.custom().setValidateAfterInactivity(timeValue).build());
        return this;
    }

    public final PoolingAsyncClientConnectionManagerBuilder useSystemProperties() {
        this.systemProperties = true;
        return this;
    }

    @Experimental
    public final PoolingAsyncClientConnectionManagerBuilder setMessageMultiplexing(boolean bl2) {
        this.messageMultiplexing = bl2;
        return this;
    }

    @Internal
    protected AsyncClientConnectionOperator createConnectionOperator(TlsStrategy tlsStrategy, SchemePortResolver schemePortResolver, DnsResolver dnsResolver) {
        return new DefaultAsyncClientConnectionOperator(RegistryBuilder.create().register(URIScheme.HTTPS.getId(), tlsStrategy).build(), schemePortResolver, dnsResolver);
    }

    public PoolingAsyncClientConnectionManager build() {
        Object object = this.tlsStrategy != null ? this.tlsStrategy : (ReflectionUtils.determineJRELevel() <= 8 && ConscryptClientTlsStrategy.isSupported() ? (this.systemProperties ? ConscryptClientTlsStrategy.getSystemDefault() : ConscryptClientTlsStrategy.getDefault()) : (this.systemProperties ? DefaultClientTlsStrategy.createSystemDefault() : DefaultClientTlsStrategy.createDefault()));
        object = new PoolingAsyncClientConnectionManager(this.createConnectionOperator((TlsStrategy)object, this.schemePortResolver, this.dnsResolver), this.poolConcurrencyPolicy, this.poolReusePolicy, null, this.messageMultiplexing);
        ((PoolingAsyncClientConnectionManager)object).setConnectionConfigResolver(this.connectionConfigResolver);
        ((PoolingAsyncClientConnectionManager)object).setTlsConfigResolver(this.tlsConfigResolver);
        if (this.maxConnTotal > 0) {
            ((PoolingAsyncClientConnectionManager)object).setMaxTotal(this.maxConnTotal);
        }
        if (this.maxConnPerRoute > 0) {
            ((PoolingAsyncClientConnectionManager)object).setDefaultMaxPerRoute(this.maxConnPerRoute);
        }
        return object;
    }
}

