/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.protocol;

import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.cookie.Cookie;
import org.apache.hc.client5.http.cookie.CookieOrigin;
import org.apache.hc.client5.http.cookie.CookieSpec;
import org.apache.hc.client5.http.cookie.CookieSpecFactory;
import org.apache.hc.client5.http.cookie.CookieStore;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpRequestInterceptor;
import org.apache.hc.core5.http.Method;
import org.apache.hc.core5.http.config.Lookup;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.net.URIAuthority;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.TextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Contract(threading=ThreadingBehavior.STATELESS)
public class RequestAddCookies
implements HttpRequestInterceptor {
    public static final RequestAddCookies INSTANCE = new RequestAddCookies();
    private static final Logger LOG = LoggerFactory.getLogger(RequestAddCookies.class);

    @Override
    public void process(HttpRequest httpRequest, EntityDetails object, HttpContext object22) throws HttpException, IOException {
        int n2;
        String string;
        Args.notNull(httpRequest, "HTTP request");
        Args.notNull(object22, "HTTP context");
        object = httpRequest.getMethod();
        if (Method.CONNECT.isSame((String)object) || Method.TRACE.isSame((String)object)) {
            return;
        }
        if (httpRequest.containsHeader("Cookie")) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Skipping cookie addition, Cookie header already present in the request");
            }
            return;
        }
        object = HttpClientContext.cast((HttpContext)object22);
        String string2 = ((HttpClientContext)object).getExchangeId();
        CookieStore cookieStore = ((HttpClientContext)object).getCookieStore();
        if (cookieStore == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} Cookie store not specified in HTTP context", (Object)string2);
            }
            return;
        }
        Lookup<CookieSpecFactory> lookup = ((HttpClientContext)object).getCookieSpecRegistry();
        if (lookup == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} CookieSpec registry not specified in HTTP context", (Object)string2);
            }
            return;
        }
        Object object2 = ((HttpClientContext)object).getHttpRoute();
        if (object2 == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} Connection route not set in the context", (Object)string2);
            }
            return;
        }
        List<Header> list = ((HttpClientContext)object).getRequestConfigOrDefault();
        if ((list = ((RequestConfig)((Object)list)).getCookieSpec()) == null) {
            list = "strict";
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} Cookie spec selected: {}", (Object)string2, (Object)list);
        }
        URIAuthority uRIAuthority = httpRequest.getAuthority();
        Object object3 = httpRequest.getPath();
        if (TextUtils.isEmpty((CharSequence)object3)) {
            object3 = "/";
        }
        if ((string = uRIAuthority != null ? uRIAuthority.getHostName() : null) == null) {
            string = object2.getTargetHost().getHostName();
        }
        if ((n2 = uRIAuthority != null ? uRIAuthority.getPort() : -1) < 0) {
            n2 = object2.getTargetHost().getPort();
        }
        object2 = new CookieOrigin(string, n2, (String)object3, object2.isSecure());
        if ((lookup = lookup.lookup((String)((Object)list))) == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} Unsupported cookie spec: {}", (Object)string2, (Object)list);
            }
            return;
        }
        lookup = lookup.create((HttpContext)object);
        list = cookieStore.getCookies();
        ArrayList<Cookie> arrayList = new ArrayList<Cookie>();
        object3 = Instant.now();
        boolean bl2 = false;
        for (Cookie cookie : list) {
            if (!cookie.isExpired((Instant)object3)) {
                if (!lookup.match(cookie, (CookieOrigin)object2)) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} Cookie {} match {}", string2, cookie, object2);
                }
                arrayList.add(cookie);
                continue;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} Cookie {} expired", (Object)string2, (Object)cookie);
            }
            bl2 = true;
        }
        if (bl2) {
            cookieStore.clearExpired((Instant)object3);
        }
        if (!arrayList.isEmpty()) {
            list = lookup.formatCookies(arrayList);
            for (Header header : list) {
                httpRequest.addHeader(header);
            }
        }
        ((HttpClientContext)object).setCookieSpec((CookieSpec)((Object)lookup));
        ((HttpClientContext)object).setCookieOrigin((CookieOrigin)object2);
    }
}

