/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.protocol;

import java.io.IOException;
import java.util.Iterator;
import org.apache.hc.client5.http.cookie.Cookie;
import org.apache.hc.client5.http.cookie.CookieOrigin;
import org.apache.hc.client5.http.cookie.CookieSpec;
import org.apache.hc.client5.http.cookie.CookieStore;
import org.apache.hc.client5.http.cookie.MalformedCookieException;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.HttpResponseInterceptor;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.Args;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Contract(threading=ThreadingBehavior.STATELESS)
public class ResponseProcessCookies
implements HttpResponseInterceptor {
    public static final ResponseProcessCookies INSTANCE = new ResponseProcessCookies();
    private static final Logger LOG = LoggerFactory.getLogger(ResponseProcessCookies.class);

    @Override
    public void process(HttpResponse object, EntityDetails object2, HttpContext object3) throws HttpException, IOException {
        Args.notNull(object, "HTTP request");
        Args.notNull(object3, "HTTP context");
        object2 = HttpClientContext.cast((HttpContext)object3);
        object3 = ((HttpClientContext)object2).getExchangeId();
        CookieSpec cookieSpec = ((HttpClientContext)object2).getCookieSpec();
        if (cookieSpec == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} Cookie spec not specified in HTTP context", object3);
            }
            return;
        }
        CookieStore cookieStore = ((HttpClientContext)object2).getCookieStore();
        if (cookieStore == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} Cookie store not specified in HTTP context", object3);
            }
            return;
        }
        if ((object2 = ((HttpClientContext)object2).getCookieOrigin()) == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} Cookie origin not specified in HTTP context", object3);
            }
            return;
        }
        object = object.headerIterator("Set-Cookie");
        this.processCookies((String)object3, (Iterator<Header>)object, cookieSpec, (CookieOrigin)object2, cookieStore);
    }

    private void processCookies(String string, Iterator<Header> iterator, CookieSpec cookieSpec, CookieOrigin cookieOrigin, CookieStore cookieStore) {
        while (iterator.hasNext()) {
            Header header = iterator.next();
            try {
                Object object = cookieSpec.parse(header, cookieOrigin);
                object = object.iterator();
                while (object.hasNext()) {
                    Cookie cookie = (Cookie)object.next();
                    try {
                        cookieSpec.validate(cookie, cookieOrigin);
                        cookieStore.addCookie(cookie);
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug("{} Cookie accepted [{}]", (Object)string, (Object)ResponseProcessCookies.formatCookie(cookie));
                    }
                    catch (MalformedCookieException malformedCookieException) {
                        if (!LOG.isWarnEnabled()) continue;
                        LOG.warn("{} Cookie rejected [{}] {}", string, ResponseProcessCookies.formatCookie(cookie), malformedCookieException.getMessage());
                    }
                }
            }
            catch (MalformedCookieException malformedCookieException) {
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn("{} Invalid cookie header: \"{}\". {}", string, header, malformedCookieException.getMessage());
            }
        }
    }

    private static String formatCookie(Cookie cookie) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(cookie.getName());
        stringBuilder.append("=\"");
        String string = cookie.getValue();
        if (string != null) {
            if (string.length() > 100) {
                string = string.substring(0, 100) + "...";
            }
            stringBuilder.append(string);
        }
        stringBuilder.append("\"");
        stringBuilder.append(", domain:");
        stringBuilder.append(cookie.getDomain());
        stringBuilder.append(", path:");
        stringBuilder.append(cookie.getPath());
        stringBuilder.append(", expiry:");
        stringBuilder.append(cookie.getExpiryInstant());
        return stringBuilder.toString();
    }
}

