/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.psl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.apache.hc.client5.http.psl.DomainType;
import org.apache.hc.client5.http.psl.PublicSuffixList;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;

@Contract(threading=ThreadingBehavior.STATELESS)
public final class PublicSuffixListParser {
    public static final PublicSuffixListParser INSTANCE = new PublicSuffixListParser();

    public final PublicSuffixList parse(Reader reader) throws IOException {
        String string;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        reader = new BufferedReader(reader);
        while ((string = ((BufferedReader)reader).readLine()) != null) {
            boolean bl2;
            if (string.isEmpty() || string.startsWith("//")) continue;
            if (string.startsWith(".")) {
                string = string.substring(1);
            }
            if (bl2 = string.startsWith("!")) {
                string = string.substring(1);
            }
            if (bl2) {
                arrayList2.add(string);
                continue;
            }
            arrayList.add(string);
        }
        return new PublicSuffixList(DomainType.UNKNOWN, arrayList, arrayList2);
    }

    public final List<PublicSuffixList> parseByType(Reader reader) throws IOException {
        String string;
        ArrayList<PublicSuffixList> arrayList = new ArrayList<PublicSuffixList>(2);
        reader = new BufferedReader(reader);
        DomainType domainType = null;
        ArrayList<String> arrayList2 = null;
        ArrayList<String> arrayList3 = null;
        while ((string = ((BufferedReader)reader).readLine()) != null) {
            boolean bl2;
            if (string.isEmpty()) continue;
            if (string.startsWith("//")) {
                if (domainType == null) {
                    if (string.contains("===BEGIN ICANN DOMAINS===")) {
                        domainType = DomainType.ICANN;
                        continue;
                    }
                    if (!string.contains("===BEGIN PRIVATE DOMAINS===")) continue;
                    domainType = DomainType.PRIVATE;
                    continue;
                }
                if (!string.contains("===END ICANN DOMAINS===") && !string.contains("===END PRIVATE DOMAINS===")) continue;
                if (arrayList2 != null) {
                    arrayList.add(new PublicSuffixList(domainType, arrayList2, arrayList3));
                }
                domainType = null;
                arrayList2 = null;
                arrayList3 = null;
                continue;
            }
            if (domainType == null) continue;
            if (string.startsWith(".")) {
                string = string.substring(1);
            }
            if (bl2 = string.startsWith("!")) {
                string = string.substring(1);
            }
            if (bl2) {
                if (arrayList3 == null) {
                    arrayList3 = new ArrayList<String>();
                }
                arrayList3.add(string);
                continue;
            }
            if (arrayList2 == null) {
                arrayList2 = new ArrayList<String>();
            }
            arrayList2.add(string);
        }
        return arrayList;
    }
}

