/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.psl;

import java.net.IDN;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hc.client5.http.psl.DomainType;
import org.apache.hc.client5.http.psl.PublicSuffixList;
import org.apache.hc.client5.http.psl.PublicSuffixMatcher$DomainRootInfo;
import org.apache.hc.client5.http.utils.DnsUtils;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.SAFE)
public final class PublicSuffixMatcher {
    private final Map<String, DomainType> rules;
    private final Map<String, DomainType> exceptions;

    public PublicSuffixMatcher(Collection<String> collection, Collection<String> collection2) {
        this(DomainType.UNKNOWN, collection, collection2);
    }

    public PublicSuffixMatcher(DomainType domainType, Collection<String> iterator, Collection<String> collection) {
        Args.notNull(domainType, "Domain type");
        Args.notNull(iterator, "Domain suffix rules");
        this.rules = new ConcurrentHashMap<String, DomainType>(iterator.size());
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.rules.put(string, domainType);
        }
        this.exceptions = new ConcurrentHashMap<String, DomainType>();
        if (collection != null) {
            for (String string : collection) {
                this.exceptions.put(string, domainType);
            }
        }
    }

    public PublicSuffixMatcher(Collection<PublicSuffixList> object) {
        Args.notNull(object, "Domain suffix lists");
        this.rules = new ConcurrentHashMap<String, DomainType>();
        this.exceptions = new ConcurrentHashMap<String, DomainType>();
        object = object.iterator();
        while (object.hasNext()) {
            Object object32 = (PublicSuffixList)object.next();
            DomainType domainType = ((PublicSuffixList)object32).getType();
            List<String> list = ((PublicSuffixList)object32).getRules();
            for (String string : list) {
                this.rules.put(string, domainType);
            }
            list = ((PublicSuffixList)object32).getExceptions();
            if (list == null) continue;
            for (Object object32 : list) {
                this.exceptions.put((String)object32, domainType);
            }
        }
    }

    private static DomainType findEntry(Map<String, DomainType> map, String string) {
        if (map == null) {
            return null;
        }
        return map.get(string);
    }

    private static boolean match(DomainType domainType, DomainType domainType2) {
        return domainType != null && (domainType2 == null || domainType.equals((Object)domainType2));
    }

    public final String getDomainRoot(String string) {
        return this.getDomainRoot(string, null);
    }

    public final String getDomainRoot(String object, DomainType domainType) {
        if (object == null) {
            return null;
        }
        if (((String)object).startsWith(".")) {
            return null;
        }
        boolean bl2 = ((String)(object = DnsUtils.normalize((String)object))).contains("xn-");
        if (bl2) {
            object = IDN.toUnicode((String)object);
        }
        if ((object = (object = this.resolveDomainRoot((String)object, domainType)) != null ? ((PublicSuffixMatcher$DomainRootInfo)object).root : null) != null && bl2) {
            object = IDN.toASCII((String)object);
        }
        return object;
    }

    final PublicSuffixMatcher$DomainRootInfo resolveDomainRoot(String string, DomainType domainType) {
        String string2 = null;
        while (string != null) {
            String string3 = string;
            Object object = PublicSuffixMatcher.findEntry(this.exceptions, string3);
            if (PublicSuffixMatcher.match(object, domainType)) {
                return new PublicSuffixMatcher$DomainRootInfo(string, string3, (DomainType)((Object)object));
            }
            object = PublicSuffixMatcher.findEntry(this.rules, string3);
            if (PublicSuffixMatcher.match(object, domainType)) {
                return new PublicSuffixMatcher$DomainRootInfo(string2, string3, (DomainType)((Object)object));
            }
            int n2 = string.indexOf(46);
            string3 = n2 != -1 ? string.substring(n2 + 1) : null;
            object = string3 == null ? "*" : "*." + string3;
            DomainType domainType2 = PublicSuffixMatcher.findEntry(this.rules, (String)object);
            if (PublicSuffixMatcher.match(domainType2, domainType)) {
                return new PublicSuffixMatcher$DomainRootInfo(string2, (String)object, domainType2);
            }
            if (string3 == null && (domainType == null || domainType == DomainType.UNKNOWN)) {
                return new PublicSuffixMatcher$DomainRootInfo(string2, null, null);
            }
            string2 = string;
            string = string3;
        }
        if (domainType == null || domainType == DomainType.UNKNOWN) {
            return new PublicSuffixMatcher$DomainRootInfo(string2, null, null);
        }
        return null;
    }

    public final boolean matches(String string) {
        return this.matches(string, null);
    }

    public final boolean matches(String string, DomainType domainType) {
        if (string == null) {
            return false;
        }
        return (string = this.getDomainRoot(string.startsWith(".") ? string.substring(1) : string, domainType)) == null;
    }

    public final boolean verify(String string) {
        if (string == null) {
            return false;
        }
        return this.verifyInternal(string.startsWith(".") ? string.substring(1) : string);
    }

    @Internal
    public final boolean verifyInternal(String object) {
        if ((object = this.resolveDomainRoot((String)object, null)) == null) {
            return false;
        }
        return ((PublicSuffixMatcher$DomainRootInfo)object).root != null || ((PublicSuffixMatcher$DomainRootInfo)object).domainType == DomainType.PRIVATE && ((PublicSuffixMatcher$DomainRootInfo)object).matchingKey != null;
    }
}

