/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.ssl;

import java.io.IOException;
import java.io.Serializable;
import java.net.Socket;
import java.net.SocketAddress;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.security.auth.x500.X500Principal;
import org.apache.hc.client5.http.config.TlsConfig;
import org.apache.hc.client5.http.ssl.DefaultHostnameVerifier;
import org.apache.hc.client5.http.ssl.HostnameVerificationPolicy;
import org.apache.hc.client5.http.ssl.HttpClientHostnameVerifier;
import org.apache.hc.client5.http.ssl.HttpsSupport;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.client5.http.ssl.TlsSocketStrategy;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.URIScheme;
import org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.ssl.TLS;
import org.apache.hc.core5.http.ssl.TlsCiphers;
import org.apache.hc.core5.http2.HttpVersionPolicy;
import org.apache.hc.core5.http2.ssl.ApplicationProtocol;
import org.apache.hc.core5.http2.ssl.H2TlsSupport;
import org.apache.hc.core5.io.Closer;
import org.apache.hc.core5.net.NamedEndpoint;
import org.apache.hc.core5.reactor.ssl.SSLBufferMode;
import org.apache.hc.core5.reactor.ssl.TlsDetails;
import org.apache.hc.core5.reactor.ssl.TransportSecurityLayer;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Contract(threading=ThreadingBehavior.STATELESS)
abstract class AbstractClientTlsStrategy
implements TlsSocketStrategy,
TlsStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractClientTlsStrategy.class);
    private final SSLContext sslContext;
    private final String[] supportedProtocols;
    private final String[] supportedCipherSuites;
    private final SSLBufferMode sslBufferManagement;
    private final HostnameVerificationPolicy hostnameVerificationPolicy;
    private final HostnameVerifier hostnameVerifier;

    AbstractClientTlsStrategy(SSLContext sSLContext, String[] stringArray, String[] stringArray2, SSLBufferMode sSLBufferMode, HostnameVerificationPolicy hostnameVerificationPolicy, HostnameVerifier hostnameVerifier) {
        this.sslContext = Args.notNull(sSLContext, "SSL context");
        this.supportedProtocols = stringArray;
        this.supportedCipherSuites = stringArray2;
        this.sslBufferManagement = sSLBufferMode != null ? sSLBufferMode : SSLBufferMode.STATIC;
        HostnameVerificationPolicy hostnameVerificationPolicy2 = this.hostnameVerificationPolicy = hostnameVerificationPolicy != null ? hostnameVerificationPolicy : HostnameVerificationPolicy.BOTH;
        this.hostnameVerifier = hostnameVerifier != null ? hostnameVerifier : (this.hostnameVerificationPolicy == HostnameVerificationPolicy.BUILTIN ? NoopHostnameVerifier.INSTANCE : HttpsSupport.getDefaultHostnameVerifier());
    }

    @Override
    @Deprecated
    public boolean upgrade(TransportSecurityLayer transportSecurityLayer, HttpHost httpHost, SocketAddress socketAddress, SocketAddress socketAddress2, Object object, Timeout timeout) {
        this.upgrade(transportSecurityLayer, httpHost, object, timeout, null);
        return true;
    }

    @Override
    public void upgrade(TransportSecurityLayer transportSecurityLayer, NamedEndpoint namedEndpoint, Object object3, Timeout timeout, FutureCallback<TransportSecurityLayer> futureCallback) {
        transportSecurityLayer.startTls(this.sslContext, namedEndpoint, this.sslBufferManagement, (object, sSLEngine) -> {
            object3 = object3 instanceof TlsConfig ? (TlsConfig)object3 : TlsConfig.DEFAULT;
            object = object3.getHttpVersionPolicy();
            SSLParameters sSLParameters = sSLEngine.getSSLParameters();
            String[] stringArray2 = object3.getSupportedProtocols();
            if (stringArray2 != null) {
                sSLParameters.setProtocols(stringArray2);
            } else if (this.supportedProtocols != null) {
                sSLParameters.setProtocols(this.supportedProtocols);
            } else if (object != HttpVersionPolicy.FORCE_HTTP_1) {
                SSLParameters sSLParameters2 = sSLParameters;
                sSLParameters2.setProtocols(TLS.excludeWeak(sSLParameters2.getProtocols()));
            }
            object3 = object3.getSupportedCipherSuites();
            if (object3 != null) {
                sSLParameters.setCipherSuites((String[])object3);
            } else if (this.supportedCipherSuites != null) {
                sSLParameters.setCipherSuites(this.supportedCipherSuites);
            } else if (object == HttpVersionPolicy.FORCE_HTTP_2) {
                SSLParameters sSLParameters3 = sSLParameters;
                sSLParameters3.setCipherSuites(TlsCiphers.excludeH2Blacklisted(sSLParameters3.getCipherSuites()));
            }
            if (object != HttpVersionPolicy.FORCE_HTTP_1) {
                H2TlsSupport.setEnableRetransmissions(sSLParameters, false);
            }
            this.applyParameters(sSLEngine, sSLParameters, H2TlsSupport.selectApplicationProtocols(object));
            if (this.hostnameVerificationPolicy == HostnameVerificationPolicy.BUILTIN || this.hostnameVerificationPolicy == HostnameVerificationPolicy.BOTH) {
                sSLParameters.setEndpointIdentificationAlgorithm(URIScheme.HTTPS.id);
            }
            this.initializeEngine(sSLEngine);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Enabled protocols: {}", (Object)Arrays.asList(sSLEngine.getEnabledProtocols()));
                LOG.debug("Enabled cipher suites: {}", (Object)Arrays.asList(sSLEngine.getEnabledCipherSuites()));
                LOG.debug("Starting handshake ({})", (Object)timeout);
            }
        }, (object2, sSLEngine) -> {
            this.verifySession(namedEndpoint.getHostName(), sSLEngine.getSession());
            namedEndpoint = this.createTlsDetails(sSLEngine);
            object2 = sSLEngine.getSession().getCipherSuite();
            if (namedEndpoint != null && ApplicationProtocol.HTTP_2.id.equals(((TlsDetails)((Object)namedEndpoint)).getApplicationProtocol()) && TlsCiphers.isH2Blacklisted((String)((Object)object2))) {
                throw new SSLHandshakeException("Cipher suite `" + (String)((Object)object2) + "` does not provide adequate security for HTTP/2");
            }
            return namedEndpoint;
        }, timeout, futureCallback);
    }

    abstract void applyParameters(SSLEngine var1, SSLParameters var2, String[] var3);

    abstract TlsDetails createTlsDetails(SSLEngine var1);

    protected void initializeEngine(SSLEngine sSLEngine) {
    }

    protected void initializeSocket(SSLSocket sSLSocket) {
    }

    protected void verifySession(String string, SSLSession sSLSession) throws SSLException {
        this.verifySession(string, sSLSession, this.hostnameVerificationPolicy == HostnameVerificationPolicy.CLIENT || this.hostnameVerificationPolicy == HostnameVerificationPolicy.BOTH ? this.hostnameVerifier : null);
    }

    @Override
    public SSLSocket upgrade(Socket socket, String string, int n2, Object object, HttpContext httpContext) throws IOException {
        socket = (SSLSocket)this.sslContext.getSocketFactory().createSocket(socket, string, n2, false);
        try {
            this.executeHandshake((SSLSocket)socket, string, object);
            return socket;
        }
        catch (IOException | RuntimeException exception) {
            Closer.closeQuietly(socket);
            throw exception;
        }
    }

    private void executeHandshake(SSLSocket sSLSocket, String string, Object object) throws IOException {
        object = sSLSocket.getSSLParameters();
        if (this.supportedProtocols != null) {
            ((SSLParameters)object).setProtocols(this.supportedProtocols);
        } else {
            ((SSLParameters)object).setProtocols(TLS.excludeWeak(sSLSocket.getEnabledProtocols()));
        }
        if (this.supportedCipherSuites != null) {
            ((SSLParameters)object).setCipherSuites(this.supportedCipherSuites);
        } else {
            ((SSLParameters)object).setCipherSuites(TlsCiphers.excludeWeak(sSLSocket.getEnabledCipherSuites()));
        }
        if (this.hostnameVerificationPolicy == HostnameVerificationPolicy.BUILTIN || this.hostnameVerificationPolicy == HostnameVerificationPolicy.BOTH) {
            ((SSLParameters)object).setEndpointIdentificationAlgorithm(URIScheme.HTTPS.id);
        }
        sSLSocket.setSSLParameters((SSLParameters)object);
        this.initializeSocket(sSLSocket);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Enabled protocols: {}", (Object)sSLSocket.getEnabledProtocols());
            LOG.debug("Enabled cipher suites: {}", (Object)sSLSocket.getEnabledCipherSuites());
        }
        sSLSocket.startHandshake();
        this.verifySession(string, sSLSocket.getSession());
    }

    void verifySession(String string, SSLSession sSLSession, HostnameVerifier hostnameVerifier) throws SSLException {
        List list2;
        Object object;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Secure session established");
            LOG.debug(" negotiated protocol: {}", (Object)sSLSession.getProtocol());
            LOG.debug(" negotiated cipher suite: {}", (Object)sSLSession.getCipherSuite());
            try {
                object = sSLSession.getPeerCertificates();
                object = object[0];
                if (object instanceof X509Certificate) {
                    Serializable serializable;
                    object = (X509Certificate)object;
                    list2 = ((X509Certificate)object).getSubjectX500Principal();
                    LOG.debug("Peer principal: {}", (Object)this.toEscapedString((X500Principal)((Object)list2)));
                    list2 = ((X509Certificate)object).getSubjectAlternativeNames();
                    if (list2 != null) {
                        serializable = new ArrayList();
                        for (ArrayList<String> arrayList : list2) {
                            if (arrayList.isEmpty()) continue;
                            serializable.add(Objects.toString(arrayList.get(1), null));
                        }
                        LOG.debug(" peer alternative names: {}", (Object)serializable);
                    }
                    serializable = ((X509Certificate)object).getIssuerX500Principal();
                    LOG.debug("Issuer principal: {}", (Object)this.toEscapedString((X500Principal)serializable));
                    list2 = ((X509Certificate)object).getIssuerAlternativeNames();
                    if (list2 != null) {
                        ArrayList<String> arrayList;
                        arrayList = new ArrayList<String>();
                        for (List list2 : list2) {
                            if (list2.isEmpty()) continue;
                            arrayList.add(Objects.toString(list2.get(1), null));
                        }
                        LOG.debug(" issuer alternative names: {}", (Object)arrayList);
                    }
                }
            }
            catch (Exception exception) {}
        }
        if (hostnameVerifier != null) {
            object = sSLSession.getPeerCertificates();
            if (((Certificate[])object).length <= 0) {
                throw new SSLPeerUnverifiedException("Peer certificate chain is empty");
            }
            if (!((object = object[0]) instanceof X509Certificate)) {
                throw new SSLPeerUnverifiedException("Unexpected certificate type: " + ((Certificate)object).getType());
            }
            object = (X509Certificate)object;
            if (hostnameVerifier instanceof HttpClientHostnameVerifier) {
                ((HttpClientHostnameVerifier)hostnameVerifier).verify(string, (X509Certificate)object);
                return;
            }
            if (!hostnameVerifier.verify(string, sSLSession)) {
                list2 = DefaultHostnameVerifier.getSubjectAltNames((X509Certificate)object);
                throw new SSLPeerUnverifiedException("Certificate for <" + string + "> doesn't match any of the subject alternative names: " + list2);
            }
        }
    }

    @Internal
    String toEscapedString(X500Principal object) {
        object = ((X500Principal)object).getName("RFC2253");
        StringBuilder stringBuilder = new StringBuilder(((String)object).length());
        char[] cArray = ((String)object).toCharArray();
        object = cArray;
        int n2 = cArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object2 = object[i2];
            if (Character.isISOControl((char)object2)) {
                stringBuilder.append(String.format("\\x%02x", (int)object2));
                continue;
            }
            stringBuilder.append((char)object2);
        }
        return stringBuilder.toString();
    }
}

