/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.ssl;

import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.apache.hc.client5.http.ssl.DefaultClientTlsStrategy;
import org.apache.hc.client5.http.ssl.HostnameVerificationPolicy;
import org.apache.hc.client5.http.ssl.HttpsSupport;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.client5.http.ssl.TlsSocketStrategy;
import org.apache.hc.core5.function.Factory;
import org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import org.apache.hc.core5.http.ssl.TLS;
import org.apache.hc.core5.reactor.ssl.SSLBufferMode;
import org.apache.hc.core5.reactor.ssl.TlsDetails;
import org.apache.hc.core5.ssl.SSLContexts;

public class ClientTlsStrategyBuilder {
    private SSLContext sslContext;
    private String[] tlsVersions;
    private String[] ciphers;
    private SSLBufferMode sslBufferMode;
    private HostnameVerificationPolicy hostnameVerificationPolicy;
    private HostnameVerifier hostnameVerifier;
    private boolean systemProperties;

    public static ClientTlsStrategyBuilder create() {
        return new ClientTlsStrategyBuilder();
    }

    public ClientTlsStrategyBuilder setSslContext(SSLContext sSLContext) {
        this.sslContext = sSLContext;
        return this;
    }

    public final ClientTlsStrategyBuilder setTlsVersions(String ... stringArray) {
        this.tlsVersions = stringArray;
        return this;
    }

    public final ClientTlsStrategyBuilder setTlsVersions(TLS ... tLSArray) {
        this.tlsVersions = new String[tLSArray.length];
        for (int i2 = 0; i2 < tLSArray.length; ++i2) {
            this.tlsVersions[i2] = tLSArray[i2].id;
        }
        return this;
    }

    public final ClientTlsStrategyBuilder setCiphers(String ... stringArray) {
        this.ciphers = stringArray;
        return this;
    }

    public ClientTlsStrategyBuilder setSslBufferMode(SSLBufferMode sSLBufferMode) {
        this.sslBufferMode = sSLBufferMode;
        return this;
    }

    @Deprecated
    public void setHostnameVerificationPolicy(HostnameVerificationPolicy hostnameVerificationPolicy) {
        this.hostnameVerificationPolicy = hostnameVerificationPolicy;
    }

    public ClientTlsStrategyBuilder setHostVerificationPolicy(HostnameVerificationPolicy hostnameVerificationPolicy) {
        this.hostnameVerificationPolicy = hostnameVerificationPolicy;
        return this;
    }

    public ClientTlsStrategyBuilder setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
        return this;
    }

    @Deprecated
    public ClientTlsStrategyBuilder setTlsDetailsFactory(Factory<SSLEngine, TlsDetails> factory) {
        return this;
    }

    public final ClientTlsStrategyBuilder useSystemProperties() {
        this.systemProperties = true;
        return this;
    }

    @Deprecated
    public TlsStrategy build() {
        return this.buildImpl();
    }

    public TlsStrategy buildAsync() {
        return this.buildImpl();
    }

    public TlsSocketStrategy buildClassic() {
        return this.buildImpl();
    }

    private DefaultClientTlsStrategy buildImpl() {
        HostnameVerificationPolicy hostnameVerificationPolicy;
        String[] stringArray;
        String[] stringArray2;
        SSLContext sSLContext;
        SSLContext sSLContext2 = this.sslContext != null ? this.sslContext : (sSLContext = this.systemProperties ? SSLContexts.createSystemDefault() : SSLContexts.createDefault());
        Object object = this.tlsVersions != null ? this.tlsVersions : (stringArray2 = this.systemProperties ? HttpsSupport.getSystemProtocols() : null);
        Object object2 = this.ciphers != null ? this.ciphers : (stringArray = this.systemProperties ? HttpsSupport.getSystemCipherSuits() : null);
        HostnameVerificationPolicy hostnameVerificationPolicy2 = this.hostnameVerificationPolicy != null ? this.hostnameVerificationPolicy : (hostnameVerificationPolicy = this.hostnameVerifier == null ? HostnameVerificationPolicy.BUILTIN : HostnameVerificationPolicy.BOTH);
        HostnameVerifier hostnameVerifier = this.hostnameVerifier != null ? this.hostnameVerifier : (hostnameVerificationPolicy == HostnameVerificationPolicy.CLIENT || hostnameVerificationPolicy == HostnameVerificationPolicy.BOTH ? HttpsSupport.getDefaultHostnameVerifier() : NoopHostnameVerifier.INSTANCE);
        return new DefaultClientTlsStrategy(sSLContext, stringArray2, stringArray, this.sslBufferMode != null ? this.sslBufferMode : SSLBufferMode.STATIC, hostnameVerificationPolicy, hostnameVerifier);
    }
}

