/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.ssl;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.hc.client5.http.config.TlsConfig;
import org.apache.hc.client5.http.socket.LayeredConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.DefaultHostnameVerifier;
import org.apache.hc.client5.http.ssl.HttpClientHostnameVerifier;
import org.apache.hc.client5.http.ssl.HttpsSupport;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.ssl.TLS;
import org.apache.hc.core5.http.ssl.TlsCiphers;
import org.apache.hc.core5.io.Closer;
import org.apache.hc.core5.ssl.SSLContexts;
import org.apache.hc.core5.ssl.SSLInitializationException;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.Asserts;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
@Contract(threading=ThreadingBehavior.STATELESS)
public class SSLConnectionSocketFactory
implements LayeredConnectionSocketFactory {
    private static final String WEAK_KEY_EXCHANGES = "^(TLS|SSL)_(NULL|ECDH_anon|DH_anon|DH_anon_EXPORT|DHE_RSA_EXPORT|DHE_DSS_EXPORT|DSS_EXPORT|DH_DSS_EXPORT|DH_RSA_EXPORT|RSA_EXPORT|KRB5_EXPORT)_(.*)";
    private static final String WEAK_CIPHERS = "^(TLS|SSL)_(.*)_WITH_(NULL|DES_CBC|DES40_CBC|DES_CBC_40|3DES_EDE_CBC|RC4_128|RC4_40|RC2_CBC_40)_(.*)";
    private static final List<Pattern> WEAK_CIPHER_SUITE_PATTERNS = Collections.unmodifiableList(Arrays.asList(Pattern.compile("^(TLS|SSL)_(NULL|ECDH_anon|DH_anon|DH_anon_EXPORT|DHE_RSA_EXPORT|DHE_DSS_EXPORT|DSS_EXPORT|DH_DSS_EXPORT|DH_RSA_EXPORT|RSA_EXPORT|KRB5_EXPORT)_(.*)", 2), Pattern.compile("^(TLS|SSL)_(.*)_WITH_(NULL|DES_CBC|DES40_CBC|DES_CBC_40|3DES_EDE_CBC|RC4_128|RC4_40|RC2_CBC_40)_(.*)", 2)));
    private static final Logger LOG = LoggerFactory.getLogger(SSLConnectionSocketFactory.class);
    private final SSLSocketFactory socketFactory;
    private final HostnameVerifier hostnameVerifier;
    private final String[] supportedProtocols;
    private final String[] supportedCipherSuites;

    public static SSLConnectionSocketFactory getSocketFactory() throws SSLInitializationException {
        return new SSLConnectionSocketFactory(SSLContexts.createDefault(), HttpsSupport.getDefaultHostnameVerifier());
    }

    public static SSLConnectionSocketFactory getSystemSocketFactory() throws SSLInitializationException {
        return new SSLConnectionSocketFactory((SSLSocketFactory)SSLSocketFactory.getDefault(), HttpsSupport.getSystemProtocols(), HttpsSupport.getSystemCipherSuits(), HttpsSupport.getDefaultHostnameVerifier());
    }

    static boolean isWeakCipherSuite(String string) {
        for (Pattern pattern : WEAK_CIPHER_SUITE_PATTERNS) {
            if (!pattern.matcher(string).matches()) continue;
            return true;
        }
        return false;
    }

    public SSLConnectionSocketFactory(SSLContext sSLContext) {
        this(sSLContext, HttpsSupport.getDefaultHostnameVerifier());
    }

    public SSLConnectionSocketFactory(SSLContext sSLContext, HostnameVerifier hostnameVerifier) {
        this(Args.notNull(sSLContext, "SSL context").getSocketFactory(), null, null, hostnameVerifier);
    }

    public SSLConnectionSocketFactory(SSLContext sSLContext, String[] stringArray, String[] stringArray2, HostnameVerifier hostnameVerifier) {
        this(Args.notNull(sSLContext, "SSL context").getSocketFactory(), stringArray, stringArray2, hostnameVerifier);
    }

    public SSLConnectionSocketFactory(SSLSocketFactory sSLSocketFactory, HostnameVerifier hostnameVerifier) {
        this(sSLSocketFactory, null, null, hostnameVerifier);
    }

    public SSLConnectionSocketFactory(SSLSocketFactory sSLSocketFactory, String[] stringArray, String[] stringArray2, HostnameVerifier hostnameVerifier) {
        this.socketFactory = Args.notNull(sSLSocketFactory, "SSL socket factory");
        this.supportedProtocols = stringArray;
        this.supportedCipherSuites = stringArray2;
        this.hostnameVerifier = hostnameVerifier != null ? hostnameVerifier : HttpsSupport.getDefaultHostnameVerifier();
    }

    @Deprecated
    protected void prepareSocket(SSLSocket sSLSocket) throws IOException {
    }

    protected void prepareSocket(SSLSocket sSLSocket, HttpContext httpContext) throws IOException {
        this.prepareSocket(sSLSocket);
    }

    @Override
    public Socket createSocket(HttpContext httpContext) throws IOException {
        return new Socket();
    }

    @Override
    public Socket createSocket(Proxy proxy, HttpContext httpContext) throws IOException {
        if (proxy != null) {
            return new Socket(proxy);
        }
        return this.createSocket(httpContext);
    }

    @Override
    public Socket connectSocket(TimeValue timeValue, Socket socket, HttpHost httpHost, InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2, HttpContext httpContext) throws IOException {
        TimeValue timeValue2 = timeValue = timeValue != null ? Timeout.of(timeValue.getDuration(), timeValue.getTimeUnit()) : null;
        return this.connectSocket(socket, httpHost, inetSocketAddress, inetSocketAddress2, (Timeout)timeValue2, timeValue2, httpContext);
    }

    @Override
    public Socket connectSocket(Socket socket, HttpHost httpHost, InetSocketAddress object, InetSocketAddress inetSocketAddress, Timeout timeout, Object object2, HttpContext httpContext) throws IOException {
        Args.notNull(httpHost, "HTTP host");
        Args.notNull(object, "Remote address");
        Socket socket2 = socket = socket != null ? socket : this.createSocket(httpContext);
        if (inetSocketAddress != null) {
            socket.bind(inetSocketAddress);
        }
        try {
            this.connectSocket(socket, (InetSocketAddress)object, timeout, httpContext);
        }
        catch (IOException iOException) {
            Closer.closeQuietly(socket);
            throw iOException;
        }
        if (socket instanceof SSLSocket) {
            object = (SSLSocket)socket;
            this.executeHandshake((SSLSocket)object, httpHost.getHostName(), object2, httpContext);
            return socket;
        }
        return this.createLayeredSocket(socket, httpHost.getHostName(), ((InetSocketAddress)object).getPort(), object2, httpContext);
    }

    protected void connectSocket(Socket object, InetSocketAddress inetSocketAddress, Timeout timeout, HttpContext httpContext) throws IOException {
        Args.notNull(object, "Socket");
        Args.notNull(inetSocketAddress, "Remote address");
        if (LOG.isDebugEnabled()) {
            LOG.debug("Connecting socket to {} with timeout {}", (Object)inetSocketAddress, (Object)timeout);
        }
        try {
            AccessController.doPrivileged(() -> SSLConnectionSocketFactory.lambda$connectSocket$0((Socket)object, inetSocketAddress, timeout));
            return;
        }
        catch (PrivilegedActionException privilegedActionException) {
            object = privilegedActionException;
            Asserts.check(privilegedActionException.getCause() instanceof IOException, "method contract violation only checked exceptions are wrapped: " + ((Throwable)object).getCause());
            throw (IOException)((Throwable)object).getCause();
        }
    }

    @Override
    public Socket createLayeredSocket(Socket socket, String string, int n2, HttpContext httpContext) throws IOException {
        return this.createLayeredSocket(socket, string, n2, null, httpContext);
    }

    @Override
    public Socket createLayeredSocket(Socket socket, String string, int n2, Object object, HttpContext httpContext) throws IOException {
        socket = (SSLSocket)this.socketFactory.createSocket(socket, string, n2, true);
        this.executeHandshake((SSLSocket)socket, string, object, httpContext);
        return socket;
    }

    private void executeHandshake(SSLSocket sSLSocket, String string, Object object, HttpContext httpContext) throws IOException {
        Object object2 = object = object instanceof TlsConfig ? (TlsConfig)object : TlsConfig.DEFAULT;
        if (this.supportedProtocols != null) {
            sSLSocket.setEnabledProtocols(this.supportedProtocols);
        } else {
            SSLSocket sSLSocket2 = sSLSocket;
            sSLSocket2.setEnabledProtocols(TLS.excludeWeak(sSLSocket2.getEnabledProtocols()));
        }
        if (this.supportedCipherSuites != null) {
            sSLSocket.setEnabledCipherSuites(this.supportedCipherSuites);
        } else {
            SSLSocket sSLSocket3 = sSLSocket;
            sSLSocket3.setEnabledCipherSuites(TlsCiphers.excludeWeak(sSLSocket3.getEnabledCipherSuites()));
        }
        object = ((TlsConfig)object).getHandshakeTimeout();
        if (object != null) {
            sSLSocket.setSoTimeout(((TimeValue)object).toMillisecondsIntBound());
        }
        this.prepareSocket(sSLSocket, httpContext);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Enabled protocols: {}", (Object)sSLSocket.getEnabledProtocols());
            LOG.debug("Enabled cipher suites: {}", (Object)sSLSocket.getEnabledCipherSuites());
            LOG.debug("Starting handshake ({})", object);
        }
        sSLSocket.startHandshake();
        this.verifyHostname(sSLSocket, string);
    }

    private void verifyHostname(SSLSocket sSLSocket, String string) throws IOException {
        try {
            Object object = sSLSocket.getSession();
            if (object == null) {
                object = sSLSocket.getInputStream();
                ((InputStream)object).available();
                object = sSLSocket.getSession();
                if (object == null) {
                    sSLSocket.startHandshake();
                    object = sSLSocket.getSession();
                }
            }
            if (object == null) {
                throw new SSLHandshakeException("SSL session not available");
            }
            this.verifySession(string, (SSLSession)object);
            return;
        }
        catch (IOException iOException) {
            Closer.closeQuietly(sSLSocket);
            throw iOException;
        }
    }

    protected void verifySession(String string, SSLSession sSLSession) throws SSLException {
        this.verifySession(string, sSLSession, this.hostnameVerifier);
    }

    void verifySession(String string, SSLSession sSLSession, HostnameVerifier hostnameVerifier) throws SSLException {
        List list2;
        Object object;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Secure session established");
            LOG.debug(" negotiated protocol: {}", (Object)sSLSession.getProtocol());
            LOG.debug(" negotiated cipher suite: {}", (Object)sSLSession.getCipherSuite());
            try {
                object = sSLSession.getPeerCertificates();
                object = object[0];
                if (object instanceof X509Certificate) {
                    Serializable serializable;
                    object = (X509Certificate)object;
                    list2 = ((X509Certificate)object).getSubjectX500Principal();
                    LOG.debug(" peer principal: {}", (Object)list2);
                    list2 = ((X509Certificate)object).getSubjectAlternativeNames();
                    if (list2 != null) {
                        serializable = new ArrayList();
                        for (ArrayList<String> arrayList : list2) {
                            if (arrayList.isEmpty()) continue;
                            serializable.add(Objects.toString(arrayList.get(1), null));
                        }
                        LOG.debug(" peer alternative names: {}", (Object)serializable);
                    }
                    serializable = ((X509Certificate)object).getIssuerX500Principal();
                    LOG.debug(" issuer principal: {}", (Object)serializable);
                    list2 = ((X509Certificate)object).getIssuerAlternativeNames();
                    if (list2 != null) {
                        ArrayList<String> arrayList;
                        arrayList = new ArrayList<String>();
                        for (List list2 : list2) {
                            if (list2.isEmpty()) continue;
                            arrayList.add(Objects.toString(list2.get(1), null));
                        }
                        LOG.debug(" issuer alternative names: {}", (Object)arrayList);
                    }
                }
            }
            catch (Exception exception) {}
        }
        if (hostnameVerifier != null) {
            object = sSLSession.getPeerCertificates();
            if (((Certificate[])object).length <= 0) {
                throw new SSLPeerUnverifiedException("Peer certificate chain is empty");
            }
            if (!((object = object[0]) instanceof X509Certificate)) {
                throw new SSLPeerUnverifiedException("Unexpected certificate type: " + ((Certificate)object).getType());
            }
            object = (X509Certificate)object;
            if (hostnameVerifier instanceof HttpClientHostnameVerifier) {
                ((HttpClientHostnameVerifier)hostnameVerifier).verify(string, (X509Certificate)object);
                return;
            }
            if (!hostnameVerifier.verify(string, sSLSession)) {
                list2 = DefaultHostnameVerifier.getSubjectAltNames((X509Certificate)object);
                throw new SSLPeerUnverifiedException("Certificate for <" + string + "> doesn't match any of the subject alternative names: " + list2);
            }
        }
    }

    private static /* synthetic */ Object lambda$connectSocket$0(Socket socket, InetSocketAddress inetSocketAddress, Timeout timeout) throws Exception {
        socket.connect(inetSocketAddress, Timeout.defaultsToDisabled(timeout).toMillisecondsIntBound());
        return null;
    }
}

