/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.utils;

import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.hc.core5.http.MessageHeaders;
import org.apache.hc.core5.util.Args;

public final class DateUtils {
    @Deprecated
    public static final String PATTERN_RFC1123 = "EEE, dd MMM yyyy HH:mm:ss zzz";
    public static final String INTERNET_MESSAGE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss zzz";
    public static final DateTimeFormatter FORMATTER_RFC1123 = new DateTimeFormatterBuilder().parseLenient().parseCaseInsensitive().appendPattern("EEE, dd MMM yyyy HH:mm:ss zzz").toFormatter(Locale.ENGLISH);
    public static final String PATTERN_RFC1036 = "EEE, dd-MMM-yy HH:mm:ss zzz";
    public static final DateTimeFormatter FORMATTER_RFC1036 = new DateTimeFormatterBuilder().parseLenient().parseCaseInsensitive().appendPattern("EEE, dd-MMM-yy HH:mm:ss zzz").toFormatter(Locale.ENGLISH);
    public static final String PATTERN_ASCTIME = "EEE MMM d HH:mm:ss yyyy";
    public static final DateTimeFormatter FORMATTER_ASCTIME = new DateTimeFormatterBuilder().parseLenient().parseCaseInsensitive().appendPattern("EEE MMM d HH:mm:ss yyyy").toFormatter(Locale.ENGLISH);
    public static final DateTimeFormatter[] STANDARD_PATTERNS = new DateTimeFormatter[]{FORMATTER_RFC1123, FORMATTER_RFC1036, FORMATTER_ASCTIME};
    static final ZoneId GMT_ID = ZoneId.of("GMT");
    @Deprecated
    public static final TimeZone GMT = TimeZone.getTimeZone("GMT");

    public static Date toDate(Instant instant) {
        if (instant != null) {
            return new Date(instant.toEpochMilli());
        }
        return null;
    }

    public static Instant toInstant(Date date) {
        if (date != null) {
            return Instant.ofEpochMilli(date.getTime());
        }
        return null;
    }

    public static LocalDateTime toUTC(Instant instant) {
        if (instant != null) {
            return instant.atZone(ZoneOffset.UTC).toLocalDateTime();
        }
        return null;
    }

    public static LocalDateTime toUTC(Date date) {
        return DateUtils.toUTC(DateUtils.toInstant(date));
    }

    public static Instant parseDate(String string, DateTimeFormatter ... dateTimeFormatterArray) {
        Args.notNull(string, "Date value");
        if (string.length() > 1 && string.startsWith("'") && string.endsWith("'")) {
            string = string.substring(1, string.length() - 1);
        }
        for (DateTimeFormatter dateTimeFormatter : dateTimeFormatterArray) {
            try {
                return Instant.from(dateTimeFormatter.parse(string));
            }
            catch (DateTimeException dateTimeException) {
            }
        }
        return null;
    }

    public static Instant parseStandardDate(String string) {
        return DateUtils.parseDate(string, STANDARD_PATTERNS);
    }

    public static Instant parseStandardDate(MessageHeaders object, String string) {
        if (object == null) {
            return null;
        }
        if ((object = object.getFirstHeader(string)) == null) {
            return null;
        }
        return DateUtils.parseStandardDate(object.getValue());
    }

    public static String formatStandardDate(Instant instant) {
        return DateUtils.formatDate(instant, FORMATTER_RFC1123);
    }

    public static String formatDate(Instant instant, DateTimeFormatter dateTimeFormatter) {
        Args.notNull(instant, "Instant");
        Args.notNull(dateTimeFormatter, "DateTimeFormatter");
        return dateTimeFormatter.format(instant.atZone(GMT_ID));
    }

    @Deprecated
    public static Date parseDate(String string) {
        return DateUtils.parseDate(string, null, null);
    }

    @Deprecated
    public static Date parseDate(MessageHeaders messageHeaders, String string) {
        return DateUtils.toDate(DateUtils.parseStandardDate(messageHeaders, string));
    }

    @Deprecated
    public static boolean isAfter(MessageHeaders object, MessageHeaders object2, String string) {
        if (object != null && object2 != null && (object = object.getFirstHeader(string)) != null && (object2 = object2.getFirstHeader(string)) != null && (object = DateUtils.parseDate(object.getValue())) != null && (object2 = DateUtils.parseDate(object2.getValue())) != null) {
            return ((Date)object).after((Date)object2);
        }
        return false;
    }

    @Deprecated
    public static boolean isBefore(MessageHeaders object, MessageHeaders object2, String string) {
        if (object != null && object2 != null && (object = object.getFirstHeader(string)) != null && (object2 = object2.getFirstHeader(string)) != null && (object = DateUtils.parseDate(object.getValue())) != null && (object2 = DateUtils.parseDate(object2.getValue())) != null) {
            return ((Date)object).before((Date)object2);
        }
        return false;
    }

    @Deprecated
    public static Date parseDate(String string, String[] stringArray) {
        return DateUtils.parseDate(string, stringArray, null);
    }

    @Deprecated
    public static Date parseDate(String string, String[] stringArray, Date dateTimeFormatterArray) {
        if (stringArray != null) {
            dateTimeFormatterArray = new DateTimeFormatter[stringArray.length];
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                dateTimeFormatterArray[i2] = new DateTimeFormatterBuilder().parseLenient().parseCaseInsensitive().appendPattern(stringArray[i2]).toFormatter();
            }
        } else {
            dateTimeFormatterArray = STANDARD_PATTERNS;
        }
        return DateUtils.toDate(DateUtils.parseDate(string, dateTimeFormatterArray));
    }

    @Deprecated
    public static String formatDate(Date date) {
        return DateUtils.formatStandardDate(DateUtils.toInstant(date));
    }

    @Deprecated
    public static String formatDate(Date date, String string) {
        Args.notNull(date, "Date");
        Args.notNull(string, "Pattern");
        return DateTimeFormatter.ofPattern(string).format(DateUtils.toInstant(date).atZone(GMT_ID));
    }

    @Deprecated
    public static void clearThreadLocal() {
    }

    private DateUtils() {
    }
}

