/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.concurrent;

import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hc.core5.concurrent.BasicFuture;
import org.apache.hc.core5.concurrent.Cancellable;
import org.apache.hc.core5.concurrent.CancellableDependency;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.util.Args;

public final class ComplexFuture<T>
extends BasicFuture<T>
implements CancellableDependency {
    private final AtomicReference<Cancellable> dependencyRef = new AtomicReference();

    public ComplexFuture(FutureCallback<T> futureCallback) {
        super(futureCallback);
    }

    @Override
    public final void setDependency(Cancellable cancellable) {
        Args.notNull(cancellable, "dependency");
        if (this.isDone()) {
            cancellable.cancel();
            return;
        }
        this.dependencyRef.set(cancellable);
    }

    public final void setDependency(Future<?> future) {
        Args.notNull(future, "dependency");
        if (future instanceof Cancellable) {
            this.setDependency((Cancellable)((Object)future));
            return;
        }
        this.setDependency(() -> future.cancel(true));
    }

    @Override
    public final boolean completed(T t2) {
        boolean bl2 = super.completed(t2);
        this.dependencyRef.set(null);
        return bl2;
    }

    @Override
    public final boolean failed(Exception exception) {
        boolean bl2 = super.failed(exception);
        this.dependencyRef.set(null);
        return bl2;
    }

    @Override
    public final boolean cancel(boolean bl2) {
        bl2 = super.cancel(bl2);
        Cancellable cancellable = this.dependencyRef.getAndSet(null);
        if (cancellable != null) {
            cancellable.cancel();
        }
        return bl2;
    }
}

